/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageCursorProviderImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCUtils;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFile;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactory;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactoryDriver;
import org.apache.activemq.artemis.jdbc.store.sql.GenericSQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public class PagingStoreFactoryDatabase
implements PagingStoreFactory {
    private static final String ADDRESS_FILE = "address.txt";
    private static final String DIRECTORY_NAME = "directory.txt";
    protected final boolean syncNonTransactional;
    private PagingManager pagingManager;
    private final ScheduledExecutorService scheduledExecutor;
    private final long syncTimeout;
    protected final StorageManager storageManager;
    private JDBCSequentialFileFactoryDriver dbDriver;
    private DatabaseStorageConfiguration dbConf;
    private ExecutorFactory executorFactory;
    private JDBCSequentialFileFactory pagingFactoryFileFactory;
    private JDBCSequentialFile directoryList;

    public PagingStoreFactoryDatabase(DatabaseStorageConfiguration dbConf, StorageManager storageManager, long syncTimeout, ScheduledExecutorService scheduledExecutor, ExecutorFactory executorFactory, boolean syncNonTransactional, IOCriticalErrorListener critialErrorListener) throws Exception {
        this.storageManager = storageManager;
        this.executorFactory = executorFactory;
        this.syncNonTransactional = syncNonTransactional;
        this.scheduledExecutor = scheduledExecutor;
        this.syncTimeout = syncTimeout;
        this.dbConf = dbConf;
        if (dbConf.getDataSource() != null) {
            SQLProvider.Factory sqlProviderFactory = dbConf.getSqlProviderFactory();
            if (sqlProviderFactory == null) {
                sqlProviderFactory = new GenericSQLProvider.Factory();
            }
            this.pagingFactoryFileFactory = new JDBCSequentialFileFactory(dbConf.getDataSource(), sqlProviderFactory.create(dbConf.getPageStoreTableName()), executorFactory.getExecutor());
        } else {
            String driverClassName = dbConf.getJdbcDriverClassName();
            this.pagingFactoryFileFactory = new JDBCSequentialFileFactory(dbConf.getJdbcConnectionUrl(), driverClassName, JDBCUtils.getSQLProvider((String)driverClassName, (String)dbConf.getPageStoreTableName()), executorFactory.getExecutor());
        }
        this.pagingFactoryFileFactory.start();
        this.directoryList = (JDBCSequentialFile)this.pagingFactoryFileFactory.createSequentialFile(DIRECTORY_NAME);
        this.directoryList.open();
    }

    @Override
    public void stop() {
        this.pagingFactoryFileFactory.stop();
    }

    @Override
    public void injectMonitor(FileStoreMonitor monitor) throws Exception {
    }

    @Override
    public PageCursorProvider newCursorProvider(PagingStore store, StorageManager storageManager, AddressSettings addressSettings, Executor executor) {
        return new PageCursorProviderImpl(store, storageManager, executor, addressSettings.getPageCacheMaxSize());
    }

    @Override
    public synchronized PagingStore newStore(SimpleString address, AddressSettings settings) {
        return new PagingStoreImpl(address, this.scheduledExecutor, this.syncTimeout, this.pagingManager, this.storageManager, null, this, address, settings, this.executorFactory.getExecutor(), this.syncNonTransactional);
    }

    @Override
    public synchronized SequentialFileFactory newFileFactory(SimpleString address) throws Exception {
        String guid = UUIDGenerator.getInstance().generateStringUUID();
        SequentialFileFactory factory = this.newFileFactory(guid, true);
        factory.start();
        SequentialFile file = factory.createSequentialFile(ADDRESS_FILE);
        file.open();
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)SimpleString.sizeofNullableString((SimpleString)address));
        buffer.writeSimpleString(address);
        file.write(buffer, true);
        return factory;
    }

    @Override
    public void setPagingManager(PagingManager pagingManager) {
        this.pagingManager = pagingManager;
    }

    @Override
    public synchronized List<PagingStore> reloadStores(HierarchicalRepository<AddressSettings> addressSettingsRepository) throws Exception {
        int size = Long.valueOf(this.directoryList.size()).intValue();
        ActiveMQBuffer buffer = this.readActiveMQBuffer((SequentialFile)this.directoryList, size);
        ArrayList<PagingStore> storesReturn = new ArrayList<PagingStore>();
        while (buffer.readableBytes() > 0) {
            SimpleString guid = buffer.readSimpleString();
            JDBCSequentialFileFactory factory = (JDBCSequentialFileFactory)this.newFileFactory(guid.toString(), false);
            factory.start();
            JDBCSequentialFile addressFile = (JDBCSequentialFile)factory.createSequentialFile(ADDRESS_FILE);
            addressFile.open();
            size = Long.valueOf(addressFile.size()).intValue();
            if (size == 0) continue;
            ActiveMQBuffer addrBuffer = this.readActiveMQBuffer((SequentialFile)addressFile, size);
            SimpleString address = addrBuffer.readSimpleString();
            AddressSettings settings = addressSettingsRepository.getMatch(address.toString());
            PagingStoreImpl store = new PagingStoreImpl(address, this.scheduledExecutor, this.syncTimeout, this.pagingManager, this.storageManager, (SequentialFileFactory)factory, this, address, settings, this.executorFactory.getExecutor(), this.syncNonTransactional);
            storesReturn.add(store);
        }
        return storesReturn;
    }

    private synchronized SequentialFileFactory newFileFactory(String directoryName, boolean writeToDirectory) throws Exception {
        SimpleString simpleString = SimpleString.toSimpleString((String)directoryName);
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)simpleString.sizeof());
        buffer.writeSimpleString(simpleString);
        if (writeToDirectory) {
            this.directoryList.write(buffer, true);
        }
        return new JDBCSequentialFileFactory(this.pagingFactoryFileFactory.getDbDriver().getConnection(), JDBCUtils.getSQLProvider((String)this.dbConf.getJdbcDriverClassName(), (String)this.getTableNameForGUID(directoryName)), this.executorFactory.getExecutor());
    }

    private String getTableNameForGUID(String guid) {
        return this.dbConf.getPageStoreTableName() + guid.replace("-", "");
    }

    private ActiveMQBuffer readActiveMQBuffer(SequentialFile file, int size) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        byteBuffer.mark();
        file.read(byteBuffer);
        byteBuffer.reset();
        ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((ByteBuffer)byteBuffer);
        buffer.writerIndex(size);
        return buffer;
    }
}

