/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageCounterRebuildManager;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.SizeAwareMetric;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.collections.LongHashSet;
import org.apache.activemq.artemis.utils.runnables.AtomicRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PagingManagerImpl
implements PagingManager {
    private static final int ARTEMIS_PAGING_COUNTER_SNAPSHOT_INTERVAL = Integer.valueOf(System.getProperty("artemis.paging.counter.snapshot.interval", "60"));
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private volatile boolean started = false;
    private final ReentrantReadWriteLock syncLock = new ReentrantReadWriteLock();
    private final Set<PagingStore> blockedStored = new ConcurrentHashSet();
    private final ConcurrentMap<SimpleString, PagingStore> stores = new ConcurrentHashMap<SimpleString, PagingStore>();
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private PagingStoreFactory pagingStoreFactory;
    private volatile boolean globalFull;
    private final SizeAwareMetric globalSizeMetric;
    private long maxSize;
    private long maxMessages;
    private volatile boolean cleanupEnabled = true;
    private volatile boolean diskFull = false;
    private volatile long diskUsableSpace = 0L;
    private volatile long diskTotalSpace = 0L;
    private final Executor managerExecutor;
    private final Queue<Runnable> memoryCallback = new ConcurrentLinkedQueue<Runnable>();
    private final ConcurrentMap<Long, PageTransactionInfo> transactions = new ConcurrentHashMap<Long, PageTransactionInfo>();
    private ActiveMQScheduledComponent snapshotUpdater = null;
    private final SimpleString managementAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGlobalFull(boolean globalFull) {
        Queue<Runnable> queue = this.memoryCallback;
        synchronized (queue) {
            this.globalFull = globalFull;
            this.checkMemoryRelease();
        }
    }

    public void replacePageStoreFactory(PagingStoreFactory factory) {
        this.pagingStoreFactory = factory;
    }

    public PagingStoreFactory getPagingStoreFactory() {
        return this.pagingStoreFactory;
    }

    public PagingManagerImpl(PagingStoreFactory pagingSPI, HierarchicalRepository<AddressSettings> addressSettingsRepository, long maxSize, long maxMessages, SimpleString managementAddress) {
        this.pagingStoreFactory = pagingSPI;
        this.addressSettingsRepository = addressSettingsRepository;
        addressSettingsRepository.registerListener(this);
        this.maxSize = maxSize;
        this.maxMessages = maxMessages;
        this.globalSizeMetric = new SizeAwareMetric(maxSize, maxSize, maxMessages, maxMessages);
        this.globalSizeMetric.setSizeEnabled(maxSize >= 0L);
        this.globalSizeMetric.setElementsEnabled(maxMessages >= 0L);
        this.globalSizeMetric.setOverCallback(() -> this.setGlobalFull(true));
        this.globalSizeMetric.setUnderCallback(() -> this.setGlobalFull(false));
        this.managerExecutor = pagingSPI.newExecutor();
        this.managementAddress = managementAddress;
    }

    SizeAwareMetric getSizeAwareMetric() {
        return this.globalSizeMetric;
    }

    void resetMaxSize(long maxSize, long maxMessages) {
        this.maxSize = maxSize;
        this.maxMessages = maxMessages;
        this.globalSizeMetric.setMax(maxSize, maxSize, maxMessages, maxMessages);
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public long getMaxMessages() {
        return this.maxMessages;
    }

    public PagingManagerImpl(PagingStoreFactory pagingSPI, HierarchicalRepository<AddressSettings> addressSettingsRepository) {
        this(pagingSPI, addressSettingsRepository, -1L, -1L, null);
    }

    public PagingManagerImpl(PagingStoreFactory pagingSPI, HierarchicalRepository<AddressSettings> addressSettingsRepository, SimpleString managementAddress) {
        this(pagingSPI, addressSettingsRepository, -1L, -1L, managementAddress);
    }

    @Override
    public void addBlockedStore(PagingStore store) {
        this.blockedStored.add(store);
    }

    @Override
    public void onChange() {
        this.reapplySettings();
    }

    private void reapplySettings() {
        for (PagingStore store : this.stores.values()) {
            AddressSettings settings = this.addressSettingsRepository.getMatch(store.getAddress().toString());
            store.applySetting(settings);
        }
    }

    @Override
    public PagingManagerImpl addSize(int size, boolean sizeOnly) {
        long newSize = this.globalSizeMetric.addSize(size, sizeOnly);
        if (newSize < 0L) {
            ActiveMQServerLogger.LOGGER.negativeGlobalAddressSize(newSize);
        }
        return this;
    }

    @Override
    public long getGlobalSize() {
        return this.globalSizeMetric.getSize();
    }

    @Override
    public long getGlobalMessages() {
        return this.globalSizeMetric.getElements();
    }

    protected void checkMemoryRelease() {
        if (!(this.diskFull || this.maxSize >= 0L && this.globalFull || this.blockedStored.isEmpty())) {
            if (!this.memoryCallback.isEmpty()) {
                if (this.managerExecutor != null) {
                    this.managerExecutor.execute(this::memoryReleased);
                } else {
                    this.memoryReleased();
                }
            }
            this.blockedStored.removeIf(PagingStore::checkReleasedMemory);
        }
    }

    @Override
    public void injectMonitor(FileStoreMonitor monitor) throws Exception {
        this.pagingStoreFactory.injectMonitor(monitor);
        monitor.addCallback(new LocalMonitor());
    }

    protected void setDiskFull(boolean diskFull) {
        this.diskFull = diskFull;
    }

    @Override
    public boolean isDiskFull() {
        return this.diskFull;
    }

    @Override
    public long getDiskUsableSpace() {
        return this.diskUsableSpace;
    }

    @Override
    public long getDiskTotalSpace() {
        return this.diskTotalSpace;
    }

    @Override
    public boolean isUsingGlobalSize() {
        return this.maxSize > 0L;
    }

    @Override
    public void checkMemory(Runnable runWhenAvailable) {
        if (this.isGlobalFull()) {
            this.memoryCallback.add((Runnable)AtomicRunnable.checkAtomic((Runnable)runWhenAvailable));
            return;
        }
        runWhenAvailable.run();
    }

    @Override
    public void checkStorage(Runnable runWhenAvailable) {
        if (this.diskFull) {
            this.memoryCallback.add((Runnable)AtomicRunnable.checkAtomic((Runnable)runWhenAvailable));
            return;
        }
        runWhenAvailable.run();
    }

    private void memoryReleased() {
        Runnable runnable;
        while ((runnable = this.memoryCallback.poll()) != null) {
            runnable.run();
        }
    }

    @Override
    public boolean isGlobalFull() {
        return this.diskFull || this.maxSize > 0L && this.globalFull;
    }

    @Override
    public void disableCleanup() {
        if (!this.cleanupEnabled) {
            return;
        }
        this.lock();
        try {
            this.cleanupEnabled = false;
            for (PagingStore store : this.stores.values()) {
                store.disableCleanup();
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void resumeCleanup() {
        if (this.cleanupEnabled) {
            return;
        }
        this.lock();
        try {
            this.cleanupEnabled = true;
            for (PagingStore store : this.stores.values()) {
                store.enableCleanup();
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public SimpleString[] getStoreNames() {
        Set names = this.stores.keySet();
        return names.toArray(new SimpleString[names.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadStores() throws Exception {
        this.lock();
        try {
            List<PagingStore> reloadedStores = this.pagingStoreFactory.reloadStores(this.addressSettingsRepository);
            for (PagingStore store : reloadedStores) {
                PagingStore oldStore = (PagingStore)this.stores.remove(store.getStoreName());
                if (oldStore != null) {
                    oldStore.stop();
                }
                store.getCursorProvider().counterRebuildStarted();
                store.start();
                this.stores.put(store.getStoreName(), store);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void deletePageStore(SimpleString storeName) throws Exception {
        this.syncLock.readLock().lock();
        try {
            PagingStore store = (PagingStore)this.stores.remove(storeName);
            if (store != null) {
                store.stop();
                store.destroy();
            }
        }
        finally {
            this.syncLock.readLock().unlock();
        }
    }

    @Override
    public PagingStore getPageStore(SimpleString storeName) throws Exception {
        if (this.managementAddress != null && storeName.startsWith(this.managementAddress)) {
            return null;
        }
        PagingStore store = (PagingStore)this.stores.get(storeName);
        if (store != null) {
            return store;
        }
        try {
            return this.stores.computeIfAbsent(storeName, s -> {
                try {
                    return this.newStore((SimpleString)s);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            throw (Exception)e.getCause();
        }
    }

    @Override
    public void addTransaction(PageTransactionInfo pageTransaction) {
        if (logger.isTraceEnabled()) {
            logger.trace("Adding pageTransaction {}", (Object)pageTransaction.getTransactionID());
        }
        this.transactions.put(pageTransaction.getTransactionID(), pageTransaction);
    }

    @Override
    public void removeTransaction(long id) {
        if (logger.isTraceEnabled()) {
            logger.trace("Removing pageTransaction {}", (Object)id);
        }
        this.transactions.remove(id);
    }

    @Override
    public PageTransactionInfo getTransaction(long id) {
        if (logger.isTraceEnabled()) {
            logger.trace("looking up pageTX = {}", (Object)id);
        }
        return (PageTransactionInfo)this.transactions.get(id);
    }

    @Override
    public Map<Long, PageTransactionInfo> getTransactions() {
        return this.transactions;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() throws Exception {
        this.lock();
        try {
            if (this.started) {
                return;
            }
            this.pagingStoreFactory.setPagingManager(this);
            this.reloadStores();
            if (ARTEMIS_PAGING_COUNTER_SNAPSHOT_INTERVAL > 0) {
                this.snapshotUpdater = new ActiveMQScheduledComponent(this.pagingStoreFactory.getScheduledExecutor(), this.pagingStoreFactory.newExecutor(), ARTEMIS_PAGING_COUNTER_SNAPSHOT_INTERVAL, TimeUnit.SECONDS, false){

                    public void run() {
                        try {
                            logger.debug("Updating counter snapshots");
                            PagingManagerImpl.this.counterSnapshot();
                        }
                        catch (Throwable e) {
                            logger.warn(e.getMessage(), e);
                        }
                    }
                };
                this.snapshotUpdater.start();
            }
            this.started = true;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void counterSnapshot() {
        for (PagingStore store : this.stores.values()) {
            store.counterSnapshot();
        }
    }

    public synchronized void stop() throws Exception {
        if (!this.started) {
            return;
        }
        this.started = false;
        if (this.snapshotUpdater != null) {
            this.snapshotUpdater.stop();
            this.snapshotUpdater = null;
        }
        this.lock();
        try {
            for (PagingStore store : this.stores.values()) {
                store.stop();
            }
            this.pagingStoreFactory.stop();
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void processReload() throws Exception {
        logger.debug("Processing reload");
        for (PagingStore store : this.stores.values()) {
            logger.debug("Processing reload on page store {}", (Object)store.getAddress());
            store.processReload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PagingStore newStore(SimpleString address) throws Exception {
        assert (this.managementAddress == null || this.managementAddress != null && !address.startsWith(this.managementAddress));
        this.syncLock.readLock().lock();
        try {
            PagingStore store = this.pagingStoreFactory.newStore(address, this.addressSettingsRepository.getMatch(address.toString()));
            store.start();
            if (!this.cleanupEnabled) {
                store.disableCleanup();
            }
            PagingStore pagingStore = store;
            return pagingStore;
        }
        finally {
            this.syncLock.readLock().unlock();
        }
    }

    @Override
    public void unlock() {
        this.syncLock.writeLock().unlock();
    }

    @Override
    public void lock() {
        this.syncLock.writeLock().lock();
    }

    @Override
    public void forEachTransaction(BiConsumer<Long, PageTransactionInfo> transactionConsumer) {
        this.transactions.forEach(transactionConsumer);
    }

    @Override
    public Future<Object> rebuildCounters() {
        LongHashSet transactionsSet = new LongHashSet();
        this.transactions.forEach((txId, tx) -> transactionsSet.add(txId));
        this.stores.forEach((address, pgStore) -> {
            PageCounterRebuildManager rebuildManager = new PageCounterRebuildManager((PagingStore)pgStore, transactionsSet);
            logger.debug("Setting destination {} to rebuild counters", address);
            this.managerExecutor.execute(rebuildManager);
        });
        FutureTask<Object> task = new FutureTask<Object>(() -> null);
        this.managerExecutor.execute(task);
        return task;
    }

    class LocalMonitor
    implements FileStoreMonitor.Callback {
        private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

        LocalMonitor() {
        }

        @Override
        public void tick(long usableSpace, long totalSpace) {
            PagingManagerImpl.this.diskUsableSpace = usableSpace;
            PagingManagerImpl.this.diskTotalSpace = totalSpace;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Tick:: usable space at {}, total space at {}", (Object)ByteUtil.getHumanReadableByteCount((long)usableSpace), (Object)ByteUtil.getHumanReadableByteCount((long)totalSpace));
            }
        }

        @Override
        public void over(long usableSpace, long totalSpace) {
            if (!PagingManagerImpl.this.diskFull) {
                ActiveMQServerLogger.LOGGER.diskBeyondCapacity(ByteUtil.getHumanReadableByteCount((long)usableSpace), ByteUtil.getHumanReadableByteCount((long)totalSpace), String.format("%.1f%%", FileStoreMonitor.calculateUsage(usableSpace, totalSpace) * 100.0));
                PagingManagerImpl.this.diskFull = true;
            }
        }

        @Override
        public void under(long usableSpace, long totalSpace) {
            boolean diskFull = PagingManagerImpl.this.diskFull;
            if (diskFull || !PagingManagerImpl.this.blockedStored.isEmpty() || !PagingManagerImpl.this.memoryCallback.isEmpty()) {
                if (diskFull) {
                    ActiveMQServerLogger.LOGGER.diskCapacityRestored(ByteUtil.getHumanReadableByteCount((long)usableSpace), ByteUtil.getHumanReadableByteCount((long)totalSpace), String.format("%.1f%%", FileStoreMonitor.calculateUsage(usableSpace, totalSpace) * 100.0));
                    PagingManagerImpl.this.diskFull = false;
                }
                PagingManagerImpl.this.checkMemoryRelease();
            }
        }
    }
}

