/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster;

import java.util.Optional;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.ConfigurationUtils;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.ChannelImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupRegistrationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupRequestMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterConnectMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterConnectReplyMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.NodeAnnounceMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ScaleDownAnnounceMessage;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;

public class ClusterControl
implements AutoCloseable {
    private Channel clusterChannel;
    private final ClientSessionFactoryInternal sessionFactory;
    private final ActiveMQServer server;
    private final String clusterUser;
    private final String clusterPassword;

    public ClusterControl(ClientSessionFactoryInternal sessionFactory, ActiveMQServer server) {
        this.sessionFactory = sessionFactory;
        this.server = server;
        this.clusterUser = server.getConfiguration().getClusterUser();
        this.clusterPassword = server.getConfiguration().getClusterPassword();
    }

    public Optional<Channel> getClusterChannel() {
        return Optional.ofNullable(this.clusterChannel);
    }

    public void authorize() throws ActiveMQException {
        CoreRemotingConnection connection = (CoreRemotingConnection)this.sessionFactory.getConnection();
        this.clusterChannel = connection.getChannel(ChannelImpl.CHANNEL_ID.CLUSTER.id, -1);
        ClusterConnectReplyMessage packet = (ClusterConnectReplyMessage)this.clusterChannel.sendBlocking((Packet)new ClusterConnectMessage(this.clusterUser, this.clusterPassword), (byte)126);
        if (!packet.isAuthorized()) {
            throw ActiveMQMessageBundle.BUNDLE.unableToValidateClusterUser(this.clusterUser);
        }
    }

    public void announceReplicatingBackupToPrimary(boolean attemptingFailBack, String replicationClusterName) throws ActiveMQException {
        ClusterConnectionConfiguration config = ConfigurationUtils.getReplicationClusterConfiguration(this.server.getConfiguration(), replicationClusterName);
        if (config == null) {
            ActiveMQServerLogger.LOGGER.announceBackupNoClusterConnections();
            throw new ActiveMQException("lacking cluster connection");
        }
        TransportConfiguration connector = this.server.getConfiguration().getConnectorConfigurations().get(config.getConnectorName());
        if (connector == null) {
            ActiveMQServerLogger.LOGGER.announceBackupNoConnector(config.getConnectorName());
            throw new ActiveMQException("lacking cluster connection");
        }
        this.clusterChannel.send((Packet)new BackupRegistrationMessage(connector, this.clusterUser, this.clusterPassword, attemptingFailBack));
    }

    public void sendNodeAnnounce(long currentEventID, String nodeID, String backupGroupName, String scaleDownGroupName, boolean isBackup, TransportConfiguration config, TransportConfiguration backupConfig) {
        this.clusterChannel.send((Packet)new NodeAnnounceMessage(currentEventID, nodeID, backupGroupName, scaleDownGroupName, isBackup, config, backupConfig));
    }

    public Channel createReplicationChannel() {
        CoreRemotingConnection connection = (CoreRemotingConnection)this.sessionFactory.getConnection();
        return connection.getChannel(ChannelImpl.CHANNEL_ID.REPLICATION.id, -1);
    }

    public ClientSessionFactoryInternal getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public void close() {
        this.sessionFactory.close();
    }

    public boolean requestReplicatedBackup(int backupSize, SimpleString nodeID) {
        BackupRequestMessage backupRequestMessage = new BackupRequestMessage(backupSize, nodeID);
        return this.requestBackup(backupRequestMessage);
    }

    private boolean requestBackup(BackupRequestMessage backupRequestMessage) {
        BackupResponseMessage packet;
        try {
            packet = (BackupResponseMessage)this.clusterChannel.sendBlocking((Packet)backupRequestMessage, (byte)-1);
        }
        catch (ActiveMQException e) {
            return false;
        }
        return packet.isBackupStarted();
    }

    public boolean requestSharedStoreBackup(int backupSize, String journalDirectory, String bindingsDirectory, String largeMessagesDirectory, String pagingDirectory) {
        BackupRequestMessage backupRequestMessage = new BackupRequestMessage(backupSize, journalDirectory, bindingsDirectory, largeMessagesDirectory, pagingDirectory);
        return this.requestBackup(backupRequestMessage);
    }

    public void announceScaleDown(SimpleString targetNodeId, SimpleString scaledDownNodeId) {
        ScaleDownAnnounceMessage announceMessage = new ScaleDownAnnounceMessage(targetNodeId, scaledDownNodeId);
        this.clusterChannel.send((Packet)announceMessage);
    }

    public String getClusterUser() {
        return this.clusterUser;
    }

    public String getClusterPassword() {
        return this.clusterPassword;
    }
}

