/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.container.NamespaceHandlerRegistry;
import org.apache.aries.blueprint.container.ParserContextImpl;
import org.apache.aries.blueprint.reflect.BeanArgumentImpl;
import org.apache.aries.blueprint.reflect.BeanMetadataImpl;
import org.apache.aries.blueprint.reflect.BeanPropertyImpl;
import org.apache.aries.blueprint.reflect.CollectionMetadataImpl;
import org.apache.aries.blueprint.reflect.IdRefMetadataImpl;
import org.apache.aries.blueprint.reflect.MapEntryImpl;
import org.apache.aries.blueprint.reflect.MapMetadataImpl;
import org.apache.aries.blueprint.reflect.MetadataUtil;
import org.apache.aries.blueprint.reflect.PropsMetadataImpl;
import org.apache.aries.blueprint.reflect.RefMetadataImpl;
import org.apache.aries.blueprint.reflect.ReferenceListMetadataImpl;
import org.apache.aries.blueprint.reflect.ReferenceListenerImpl;
import org.apache.aries.blueprint.reflect.ReferenceMetadataImpl;
import org.apache.aries.blueprint.reflect.RegistrationListenerImpl;
import org.apache.aries.blueprint.reflect.ServiceMetadataImpl;
import org.apache.aries.blueprint.reflect.ServiceReferenceMetadataImpl;
import org.apache.aries.blueprint.reflect.ValueMetadataImpl;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.IdRefMetadata;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.NullMetadata;
import org.osgi.service.blueprint.reflect.PropsMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListener;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;
import org.osgi.service.blueprint.reflect.RegistrationListener;
import org.osgi.service.blueprint.reflect.Target;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    public static final String BLUEPRINT_NAMESPACE = "http://www.osgi.org/xmlns/blueprint/v1.0.0";
    public static final String BLUEPRINT_ELEMENT = "blueprint";
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String TYPE_CONVERTERS_ELEMENT = "type-converters";
    public static final String BEAN_ELEMENT = "bean";
    public static final String ARGUMENT_ELEMENT = "argument";
    public static final String REF_ELEMENT = "ref";
    public static final String IDREF_ELEMENT = "idref";
    public static final String LIST_ELEMENT = "list";
    public static final String SET_ELEMENT = "set";
    public static final String MAP_ELEMENT = "map";
    public static final String ARRAY_ELEMENT = "array";
    public static final String PROPS_ELEMENT = "props";
    public static final String PROP_ELEMENT = "prop";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String NULL_ELEMENT = "null";
    public static final String VALUE_ELEMENT = "value";
    public static final String SERVICE_ELEMENT = "service";
    public static final String REFERENCE_ELEMENT = "reference";
    public static final String REFERENCE_LIST_ELEMENT = "reference-list";
    public static final String INTERFACES_ELEMENT = "interfaces";
    public static final String REFERENCE_LISTENER_ELEMENT = "reference-listener";
    public static final String SERVICE_PROPERTIES_ELEMENT = "service-properties";
    public static final String REGISTRATION_LISTENER_ELEMENT = "registration-listener";
    public static final String ENTRY_ELEMENT = "entry";
    public static final String KEY_ELEMENT = "key";
    public static final String DEFAULT_ACTIVATION_ATTRIBUTE = "default-activation";
    public static final String DEFAULT_TIMEOUT_ATTRIBUTE = "default-timeout";
    public static final String DEFAULT_AVAILABILITY_ATTRIBUTE = "default-availability";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ID_ATTRIBUTE = "id";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String INDEX_ATTRIBUTE = "index";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String VALUE_REF_ATTRIBUTE = "value-ref";
    public static final String KEY_ATTRIBUTE = "key";
    public static final String KEY_REF_ATTRIBUTE = "key-ref";
    public static final String REF_ATTRIBUTE = "ref";
    public static final String COMPONENT_ID_ATTRIBUTE = "component-id";
    public static final String INTERFACE_ATTRIBUTE = "interface";
    public static final String DEPENDS_ON_ATTRIBUTE = "depends-on";
    public static final String AUTO_EXPORT_ATTRIBUTE = "auto-export";
    public static final String RANKING_ATTRIBUTE = "ranking";
    public static final String TIMEOUT_ATTRIBUTE = "timeout";
    public static final String FILTER_ATTRIBUTE = "filter";
    public static final String COMPONENT_NAME_ATTRIBUTE = "component-name";
    public static final String AVAILABILITY_ATTRIBUTE = "availability";
    public static final String REGISTRATION_METHOD_ATTRIBUTE = "registration-method";
    public static final String UNREGISTRATION_METHOD_ATTRIBUTE = "unregistration-method";
    public static final String BIND_METHOD_ATTRIBUTE = "bind-method";
    public static final String UNBIND_METHOD_ATTRIBUTE = "unbind-method";
    public static final String KEY_TYPE_ATTRIBUTE = "key-type";
    public static final String VALUE_TYPE_ATTRIBUTE = "value-type";
    public static final String MEMBER_TYPE_ATTRIBUTE = "member-type";
    public static final String SCOPE_ATTRIBUTE = "scope";
    public static final String INIT_METHOD_ATTRIBUTE = "init-method";
    public static final String DESTROY_METHOD_ATTRIBUTE = "destroy-method";
    public static final String ACTIVATION_ATTRIBUTE = "activation";
    public static final String FACTORY_REF_ATTRIBUTE = "factory-ref";
    public static final String FACTORY_METHOD_ATTRIBUTE = "factory-method";
    public static final String AUTO_EXPORT_DISABLED = "disabled";
    public static final String AUTO_EXPORT_INTERFACES = "interfaces";
    public static final String AUTO_EXPORT_CLASS_HIERARCHY = "class-hierarchy";
    public static final String AUTO_EXPORT_ALL = "all-classes";
    public static final String AUTO_EXPORT_DEFAULT = "disabled";
    public static final String RANKING_DEFAULT = "0";
    public static final String AVAILABILITY_MANDATORY = "mandatory";
    public static final String AVAILABILITY_OPTIONAL = "optional";
    public static final String AVAILABILITY_DEFAULT = "mandatory";
    public static final String TIMEOUT_DEFAULT = "300000";
    public static final String USE_SERVICE_OBJECT = "service-object";
    public static final String USE_SERVICE_REFERENCE = "service-reference";
    public static final String ACTIVATION_EAGER = "eager";
    public static final String ACTIVATION_LAZY = "lazy";
    public static final String ACTIVATION_DEFAULT = "eager";
    private static final Logger LOGGER = LoggerFactory.getLogger(Parser.class);
    private static DocumentBuilderFactory documentBuilderFactory;
    private List<Document> documents;
    private ComponentDefinitionRegistry registry;
    private NamespaceHandlerRegistry namespaceHandlerRegistry;
    private String idPrefix = "component-";
    private Set<String> ids = new HashSet<String>();
    private int idCounter;
    private String defaultTimeout;
    private String defaultAvailability;
    private String defaultActivation;
    private Set<URI> namespaces;
    private boolean validation;
    private boolean validated;

    public Parser() {
    }

    public Parser(String idPrefix) {
        this.idPrefix = idPrefix;
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(List<URL> urls) throws Exception {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (URL url : urls) {
            InputStream inputStream = url.openStream();
            try {
                InputSource inputSource = new InputSource(inputStream);
                DocumentBuilder builder = Parser.getDocumentBuilderFactory().newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                documents.add(doc);
            }
            finally {
                inputStream.close();
            }
        }
        this.documents = documents;
    }

    public Set<URI> getNamespaces() {
        if (this.namespaces == null) {
            if (this.documents == null) {
                throw new IllegalStateException("Documents should be parsed before retrieving required namespaces");
            }
            LinkedHashSet<URI> namespaces = new LinkedHashSet<URI>();
            for (Document doc : this.documents) {
                this.findNamespaces(namespaces, doc);
            }
            this.namespaces = namespaces;
        }
        return this.namespaces;
    }

    private void findNamespaces(Set<URI> namespaces, Node node) {
        String ns;
        if ((node instanceof Element || node instanceof Attr) && (ns = node.getNamespaceURI()) != null && !Parser.isBlueprintNamespace(ns)) {
            namespaces.add(URI.create(ns));
        }
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            this.findNamespaces(namespaces, nl.item(i));
        }
    }

    public void populate(NamespaceHandlerRegistry handlers, ComponentDefinitionRegistry registry) {
        this.namespaceHandlerRegistry = handlers;
        this.registry = registry;
        if (this.documents == null) {
            throw new IllegalStateException("Documents should be parsed before populating the registry");
        }
        if (!this.validated && this.validation) {
            this.validate();
            this.validated = true;
        }
        for (Document doc : this.documents) {
            this.loadComponents(doc);
        }
    }

    private void validate() {
        try {
            Schema schema = this.namespaceHandlerRegistry.getSchema(this.getNamespaces());
            Validator validator = schema.newValidator();
            for (Document doc : this.documents) {
                validator.validate(new DOMSource(doc));
            }
        }
        catch (Exception e) {
            throw new ComponentDefinitionException("Unable to validate xml", e);
        }
    }

    private void loadComponents(Document doc) {
        NamedNodeMap attributes;
        this.defaultTimeout = TIMEOUT_DEFAULT;
        this.defaultAvailability = "mandatory";
        this.defaultActivation = "eager";
        Element root = doc.getDocumentElement();
        if (!Parser.isBlueprintNamespace(root.getNamespaceURI()) || !Parser.nodeNameEquals(root, BLUEPRINT_ELEMENT)) {
            throw new ComponentDefinitionException("Root element must be {http://www.osgi.org/xmlns/blueprint/v1.0.0}blueprint element");
        }
        if (root.hasAttribute(DEFAULT_ACTIVATION_ATTRIBUTE)) {
            this.defaultActivation = root.getAttribute(DEFAULT_ACTIVATION_ATTRIBUTE);
        }
        if (root.hasAttribute(DEFAULT_TIMEOUT_ATTRIBUTE)) {
            this.defaultTimeout = root.getAttribute(DEFAULT_TIMEOUT_ATTRIBUTE);
        }
        if (root.hasAttribute(DEFAULT_AVAILABILITY_ATTRIBUTE)) {
            this.defaultAvailability = root.getAttribute(DEFAULT_AVAILABILITY_ATTRIBUTE);
        }
        if ((attributes = root.getAttributes()) != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node node = attributes.item(i);
                if (!(node instanceof Attr) || node.getNamespaceURI() == null || Parser.isBlueprintNamespace(node.getNamespaceURI()) || "http://www.w3.org/2000/xmlns/".equals(node.getNamespaceURI()) || !"xmlns".equals(node.getNodeName())) continue;
                this.decorateCustomNode(node, null);
            }
        }
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            String namespaceUri = element.getNamespaceURI();
            if (Parser.isBlueprintNamespace(namespaceUri)) {
                this.parseBlueprintElement(element);
                continue;
            }
            Metadata component = this.parseCustomElement(element, null);
            if (component == null) continue;
            if (!(component instanceof ComponentMetadata)) {
                throw new ComponentDefinitionException("Expected a ComponentMetadata to be returned when parsing element " + element.getNodeName());
            }
            this.registry.registerComponentDefinition((ComponentMetadata)component);
        }
    }

    public <T> T parseElement(Class<T> type, ComponentMetadata enclosingComponent, Element element) {
        if (BeanArgument.class.isAssignableFrom(type)) {
            return type.cast(this.parseBeanArgument(enclosingComponent, element));
        }
        if (BeanProperty.class.isAssignableFrom(type)) {
            return type.cast(this.parseBeanProperty(enclosingComponent, element));
        }
        if (MapEntry.class.isAssignableFrom(type)) {
            return type.cast(this.parseMapEntry(element, enclosingComponent, null, null));
        }
        if (MapMetadata.class.isAssignableFrom(type)) {
            return type.cast(this.parseMap(element, enclosingComponent));
        }
        if (BeanMetadata.class.isAssignableFrom(type)) {
            return type.cast(this.parseBeanMetadata(element, false));
        }
        if (NullMetadata.class.isAssignableFrom(type)) {
            return type.cast(NullMetadata.NULL);
        }
        if (CollectionMetadata.class.isAssignableFrom(type)) {
            return type.cast(this.parseCollection(Collection.class, element, enclosingComponent));
        }
        if (PropsMetadata.class.isAssignableFrom(type)) {
            return type.cast(this.parseProps(element));
        }
        if (ReferenceMetadata.class.isAssignableFrom(type)) {
            return type.cast(this.parseReference(element, enclosingComponent == null));
        }
        if (ReferenceListMetadata.class.isAssignableFrom(type)) {
            return type.cast(this.parseRefList(element, enclosingComponent == null));
        }
        if (IdRefMetadata.class.isAssignableFrom(type)) {
            return type.cast(this.parseIdRef(element));
        }
        if (RefMetadata.class.isAssignableFrom(type)) {
            return type.cast(this.parseRef(element));
        }
        if (ValueMetadata.class.isAssignableFrom(type)) {
            return type.cast(this.parseValue(element, null));
        }
        throw new ComponentDefinitionException("Unknown type to parse element: " + type.getName());
    }

    private void parseBlueprintElement(Element element) {
        if (!Parser.nodeNameEquals(element, DESCRIPTION_ELEMENT)) {
            if (Parser.nodeNameEquals(element, TYPE_CONVERTERS_ELEMENT)) {
                this.parseTypeConverters(element);
            } else if (Parser.nodeNameEquals(element, BEAN_ELEMENT)) {
                ComponentMetadata component = this.parseBeanMetadata(element, true);
                this.registry.registerComponentDefinition(component);
            } else if (Parser.nodeNameEquals(element, SERVICE_ELEMENT)) {
                ComponentMetadata service = this.parseService(element, true);
                this.registry.registerComponentDefinition(service);
            } else if (Parser.nodeNameEquals(element, REFERENCE_ELEMENT)) {
                ComponentMetadata reference = this.parseReference(element, true);
                this.registry.registerComponentDefinition(reference);
            } else if (Parser.nodeNameEquals(element, REFERENCE_LIST_ELEMENT)) {
                ComponentMetadata references = this.parseRefList(element, true);
                this.registry.registerComponentDefinition(references);
            } else {
                throw new ComponentDefinitionException("Unknown element " + element.getNodeName() + " in namespace " + BLUEPRINT_NAMESPACE);
            }
        }
    }

    private void parseTypeConverters(Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            Metadata target = null;
            if (Parser.isBlueprintNamespace(e.getNamespaceURI())) {
                if (Parser.nodeNameEquals(e, BEAN_ELEMENT)) {
                    target = this.parseBeanMetadata(e, true);
                } else if (Parser.nodeNameEquals(e, "ref")) {
                    String componentName = e.getAttribute(COMPONENT_ID_ATTRIBUTE);
                    target = new RefMetadataImpl(componentName);
                } else if (Parser.nodeNameEquals(e, REFERENCE_ELEMENT)) {
                    target = this.parseReference(e, true);
                }
            } else {
                target = this.parseCustomElement(e, null);
            }
            if (!(target instanceof Target)) {
                throw new ComponentDefinitionException("Metadata parsed for element " + e.getNodeName() + " can not be used as a type converter");
            }
            this.registry.registerTypeConverter((Target)target);
        }
    }

    private ComponentMetadata parseBeanMetadata(Element element, boolean topElement) {
        BeanMetadataImpl metadata = new BeanMetadataImpl();
        if (topElement) {
            metadata.setId(this.getId(element));
            if (element.hasAttribute(SCOPE_ATTRIBUTE)) {
                metadata.setScope(element.getAttribute(SCOPE_ATTRIBUTE));
                if (metadata.getScope().equals("prototype")) {
                    if (element.hasAttribute(ACTIVATION_ATTRIBUTE) && element.getAttribute(ACTIVATION_ATTRIBUTE).equals("eager")) {
                        throw new ComponentDefinitionException("A <bean> with a prototype scope can not have an eager activation");
                    }
                    metadata.setActivation(2);
                } else {
                    metadata.setActivation(this.parseActivation(element));
                }
            } else {
                metadata.setActivation(this.parseActivation(element));
            }
        } else {
            metadata.setActivation(2);
        }
        if (element.hasAttribute(CLASS_ATTRIBUTE)) {
            metadata.setClassName(element.getAttribute(CLASS_ATTRIBUTE));
        }
        if (element.hasAttribute(DEPENDS_ON_ATTRIBUTE)) {
            metadata.setDependsOn(Parser.parseList(element.getAttribute(DEPENDS_ON_ATTRIBUTE)));
        }
        if (element.hasAttribute(INIT_METHOD_ATTRIBUTE)) {
            metadata.setInitMethod(element.getAttribute(INIT_METHOD_ATTRIBUTE));
        }
        if (element.hasAttribute(DESTROY_METHOD_ATTRIBUTE)) {
            metadata.setDestroyMethod(element.getAttribute(DESTROY_METHOD_ATTRIBUTE));
        }
        if (element.hasAttribute(FACTORY_REF_ATTRIBUTE)) {
            metadata.setFactoryComponent(new RefMetadataImpl(element.getAttribute(FACTORY_REF_ATTRIBUTE)));
        }
        if (element.hasAttribute(FACTORY_METHOD_ATTRIBUTE)) {
            String factoryMethod = element.getAttribute(FACTORY_METHOD_ATTRIBUTE);
            metadata.setFactoryMethod(factoryMethod);
        }
        if (metadata.getClassName() == null && metadata.getFactoryComponent() == null) {
            throw new ComponentDefinitionException("Bean class or factory-ref must be specified");
        }
        if (metadata.getFactoryComponent() != null && metadata.getFactoryMethod() == null) {
            throw new ComponentDefinitionException("factory-method is required when factory-component is set");
        }
        if (MetadataUtil.isPrototypeScope(metadata) && metadata.getDestroyMethod() != null) {
            throw new ComponentDefinitionException("destroy-method must not be set for a <bean> with a prototype scope");
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (!Parser.isBlueprintNamespace(node.getNamespaceURI())) continue;
            if (Parser.nodeNameEquals(node, ARGUMENT_ELEMENT)) {
                metadata.addArgument(this.parseBeanArgument(metadata, e));
                continue;
            }
            if (!Parser.nodeNameEquals(node, PROPERTY_ELEMENT)) continue;
            metadata.addProperty(this.parseBeanProperty(metadata, e));
        }
        MetadataUtil.validateBeanArguments(metadata.getArguments());
        ComponentMetadata m = metadata;
        m = this.handleCustomAttributes(element.getAttributes(), m);
        m = this.handleCustomElements(element, m);
        return m;
    }

    public BeanProperty parseBeanProperty(ComponentMetadata enclosingComponent, Element element) {
        String name = element.hasAttribute(NAME_ATTRIBUTE) ? element.getAttribute(NAME_ATTRIBUTE) : null;
        Metadata value = this.parseArgumentOrPropertyValue(element, enclosingComponent);
        return new BeanPropertyImpl(name, value);
    }

    private BeanArgument parseBeanArgument(ComponentMetadata enclosingComponent, Element element) {
        int index = element.hasAttribute(INDEX_ATTRIBUTE) ? Integer.parseInt(element.getAttribute(INDEX_ATTRIBUTE)) : -1;
        String type = element.hasAttribute(TYPE_ATTRIBUTE) ? element.getAttribute(TYPE_ATTRIBUTE) : null;
        Metadata value = this.parseArgumentOrPropertyValue(element, enclosingComponent);
        return new BeanArgumentImpl(value, type, index);
    }

    private ComponentMetadata parseService(Element element, boolean topElement) {
        String autoExport;
        ServiceMetadataImpl service = new ServiceMetadataImpl();
        boolean hasInterfaceNameAttribute = false;
        if (topElement) {
            service.setId(this.getId(element));
            service.setActivation(this.parseActivation(element));
        } else {
            service.setActivation(2);
        }
        if (element.hasAttribute(INTERFACE_ATTRIBUTE)) {
            service.setInterfaceNames(Collections.singletonList(element.getAttribute(INTERFACE_ATTRIBUTE)));
            hasInterfaceNameAttribute = true;
        }
        if (element.hasAttribute("ref")) {
            service.setServiceComponent(new RefMetadataImpl(element.getAttribute("ref")));
        }
        if (element.hasAttribute(DEPENDS_ON_ATTRIBUTE)) {
            service.setDependsOn(Parser.parseList(element.getAttribute(DEPENDS_ON_ATTRIBUTE)));
        }
        String string = autoExport = element.hasAttribute(AUTO_EXPORT_ATTRIBUTE) ? element.getAttribute(AUTO_EXPORT_ATTRIBUTE) : "disabled";
        if ("disabled".equals(autoExport)) {
            service.setAutoExport(1);
        } else if ("interfaces".equals(autoExport)) {
            service.setAutoExport(2);
        } else if (AUTO_EXPORT_CLASS_HIERARCHY.equals(autoExport)) {
            service.setAutoExport(3);
        } else if (AUTO_EXPORT_ALL.equals(autoExport)) {
            service.setAutoExport(4);
        } else {
            throw new ComponentDefinitionException("Illegal value (" + autoExport + ") for " + AUTO_EXPORT_ATTRIBUTE + " attribute");
        }
        String ranking = element.hasAttribute(RANKING_ATTRIBUTE) ? element.getAttribute(RANKING_ATTRIBUTE) : RANKING_DEFAULT;
        try {
            service.setRanking(Integer.parseInt(ranking));
        }
        catch (NumberFormatException e) {
            throw new ComponentDefinitionException("Attribute ranking must be a valid integer (was: " + ranking + ")");
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e;
            Node node = nl.item(i);
            if (!(node instanceof Element) || !Parser.isBlueprintNamespace((e = (Element)node).getNamespaceURI())) continue;
            if (Parser.nodeNameEquals(e, "interfaces")) {
                if (hasInterfaceNameAttribute) {
                    throw new ComponentDefinitionException("Only one of interface attribute or interfaces element must be used");
                }
                service.setInterfaceNames(this.parseInterfaceNames(e));
                continue;
            }
            if (Parser.nodeNameEquals(e, SERVICE_PROPERTIES_ELEMENT)) {
                List<MapEntry> entries = this.parseServiceProperties(e, service).getEntries();
                service.setServiceProperties(entries);
                continue;
            }
            if (Parser.nodeNameEquals(e, REGISTRATION_LISTENER_ELEMENT)) {
                service.addRegistrationListener(this.parseRegistrationListener(e, service));
                continue;
            }
            if (Parser.nodeNameEquals(e, BEAN_ELEMENT)) {
                if (service.getServiceComponent() != null) {
                    throw new ComponentDefinitionException("Only one of ref attribute, bean element, reference element or ref element can be set");
                }
                service.setServiceComponent((Target)((Object)this.parseBeanMetadata(e, false)));
                continue;
            }
            if (Parser.nodeNameEquals(e, "ref")) {
                if (service.getServiceComponent() != null) {
                    throw new ComponentDefinitionException("Only one of ref attribute, bean element, reference element or ref element can be set");
                }
                String component = e.getAttribute(COMPONENT_ID_ATTRIBUTE);
                if (component == null || component.length() == 0) {
                    throw new ComponentDefinitionException("Element ref must have a valid component-id attribute");
                }
                service.setServiceComponent(new RefMetadataImpl(component));
                continue;
            }
            if (!Parser.nodeNameEquals(e, REFERENCE_ELEMENT)) continue;
            if (service.getServiceComponent() != null) {
                throw new ComponentDefinitionException("Only one of ref attribute, bean element, reference element or ref element can be set");
            }
            service.setServiceComponent((Target)((Object)this.parseReference(e, false)));
        }
        if (service.getServiceComponent() == null) {
            throw new ComponentDefinitionException("One of ref attribute, bean element, reference element or ref element must be set");
        }
        if (service.getAutoExport() == 1 && service.getInterfaces().isEmpty()) {
            throw new ComponentDefinitionException("interface attribute or interfaces element must be set when auto-export is set to disabled");
        }
        if (service.getAutoExport() != 1 && !service.getInterfaces().isEmpty()) {
            throw new ComponentDefinitionException("interface attribute or  interfaces element must not be set when auto-export is set to anything else than disabled");
        }
        ComponentMetadata s = service;
        s = this.handleCustomAttributes(element.getAttributes(), s);
        s = this.handleCustomElements(element, s);
        return s;
    }

    private CollectionMetadata parseArray(Element element, ComponentMetadata enclosingComponent) {
        return this.parseCollection(Object[].class, element, enclosingComponent);
    }

    private CollectionMetadata parseList(Element element, ComponentMetadata enclosingComponent) {
        return this.parseCollection(List.class, element, enclosingComponent);
    }

    private CollectionMetadata parseSet(Element element, ComponentMetadata enclosingComponent) {
        return this.parseCollection(Set.class, element, enclosingComponent);
    }

    private CollectionMetadata parseCollection(Class collectionType, Element element, ComponentMetadata enclosingComponent) {
        String valueType = element.hasAttribute(VALUE_TYPE_ATTRIBUTE) ? element.getAttribute(VALUE_TYPE_ATTRIBUTE) : null;
        ArrayList<Metadata> list = new ArrayList<Metadata>();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Metadata val = this.parseValueGroup((Element)node, enclosingComponent, null, true);
            list.add(val);
        }
        return new CollectionMetadataImpl(collectionType, valueType, list);
    }

    public PropsMetadata parseProps(Element element) {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e;
            Node node = nl.item(i);
            if (!(node instanceof Element) || !Parser.isBlueprintNamespace((e = (Element)node).getNamespaceURI()) || !Parser.nodeNameEquals(e, PROP_ELEMENT)) continue;
            entries.add(this.parseProperty(e));
        }
        return new PropsMetadataImpl(entries);
    }

    private MapEntry parseProperty(Element element) {
        if (!element.hasAttribute("key")) {
            throw new ComponentDefinitionException("key attribute is required");
        }
        String value = null;
        value = element.hasAttribute("value") ? element.getAttribute("value") : Parser.getTextValue(element);
        String key = element.getAttribute("key");
        return new MapEntryImpl(new ValueMetadataImpl(key), new ValueMetadataImpl(value));
    }

    public MapMetadata parseMap(Element element, ComponentMetadata enclosingComponent) {
        String keyType = element.hasAttribute(KEY_TYPE_ATTRIBUTE) ? element.getAttribute(KEY_TYPE_ATTRIBUTE) : null;
        String valueType = element.hasAttribute(VALUE_TYPE_ATTRIBUTE) ? element.getAttribute(VALUE_TYPE_ATTRIBUTE) : null;
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e;
            Node node = nl.item(i);
            if (!(node instanceof Element) || !Parser.nodeNameEquals(e = (Element)node, ENTRY_ELEMENT)) continue;
            entries.add(this.parseMapEntry(e, enclosingComponent, null, null));
        }
        return new MapMetadataImpl(keyType, valueType, entries);
    }

    private MapEntry parseMapEntry(Element element, ComponentMetadata enclosingComponent, String keyType, String valueType) {
        String key = element.hasAttribute("key") ? element.getAttribute("key") : null;
        String keyRef = element.hasAttribute(KEY_REF_ATTRIBUTE) ? element.getAttribute(KEY_REF_ATTRIBUTE) : null;
        String value = element.hasAttribute("value") ? element.getAttribute("value") : null;
        String valueRef = element.hasAttribute(VALUE_REF_ATTRIBUTE) ? element.getAttribute(VALUE_REF_ATTRIBUTE) : null;
        NonNullMetadata keyValue = null;
        Metadata valValue = null;
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (Parser.nodeNameEquals(e, "key")) {
                keyValue = this.parseMapKeyEntry(e, enclosingComponent, keyType);
                continue;
            }
            valValue = this.parseValueGroup(e, enclosingComponent, valueType, true);
        }
        if (keyValue != null && (key != null || keyRef != null) || keyValue == null && key == null && keyRef == null) {
            throw new ComponentDefinitionException("Only and only one of key attribute, key-ref attribute or key element must be set");
        }
        if (keyValue == null && key != null) {
            keyValue = new ValueMetadataImpl(key, keyType);
        } else if (keyValue == null) {
            keyValue = new RefMetadataImpl(keyRef);
        }
        if (valValue != null && (value != null || valueRef != null) || valValue == null && value == null && valueRef == null) {
            throw new ComponentDefinitionException("Only and only one of value attribute, value-ref attribute or sub element must be set");
        }
        if (valValue == null && value != null) {
            valValue = new ValueMetadataImpl(value, valueType);
        } else if (valValue == null) {
            valValue = new RefMetadataImpl(valueRef);
        }
        return new MapEntryImpl(keyValue, valValue);
    }

    private NonNullMetadata parseMapKeyEntry(Element element, ComponentMetadata enclosingComponent, String keyType) {
        NonNullMetadata keyValue = null;
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (keyValue != null) {
                // empty if block
            }
            keyValue = (NonNullMetadata)this.parseValueGroup(e, enclosingComponent, keyType, false);
            break;
        }
        if (keyValue == null) {
            // empty if block
        }
        return keyValue;
    }

    public MapMetadata parseServiceProperties(Element element, ComponentMetadata enclosingComponent) {
        MapMetadata map = this.parseMap(element, enclosingComponent);
        this.handleCustomElements(element, enclosingComponent);
        return map;
    }

    public RegistrationListener parseRegistrationListener(Element element, ComponentMetadata enclosingComponent) {
        RegistrationListenerImpl listener = new RegistrationListenerImpl();
        Metadata listenerComponent = null;
        if (element.hasAttribute("ref")) {
            listenerComponent = new RefMetadataImpl(element.getAttribute("ref"));
        }
        String registrationMethod = null;
        if (element.hasAttribute(REGISTRATION_METHOD_ATTRIBUTE)) {
            registrationMethod = element.getAttribute(REGISTRATION_METHOD_ATTRIBUTE);
            listener.setRegistrationMethod(registrationMethod);
        }
        String unregistrationMethod = null;
        if (element.hasAttribute(UNREGISTRATION_METHOD_ATTRIBUTE)) {
            unregistrationMethod = element.getAttribute(UNREGISTRATION_METHOD_ATTRIBUTE);
            listener.setUnregistrationMethod(unregistrationMethod);
        }
        if (registrationMethod == null && unregistrationMethod == null) {
            throw new ComponentDefinitionException("One of registration-method or unregistration-method must be set");
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (Parser.isBlueprintNamespace(e.getNamespaceURI())) {
                if (Parser.nodeNameEquals(e, "ref")) {
                    if (listenerComponent != null) {
                        throw new ComponentDefinitionException("Only one of ref attribute, ref, bean, reference, service or custom element can be set");
                    }
                    String component = e.getAttribute(COMPONENT_ID_ATTRIBUTE);
                    if (component == null || component.length() == 0) {
                        throw new ComponentDefinitionException("Element ref must have a valid component-id attribute");
                    }
                    listenerComponent = new RefMetadataImpl(component);
                    continue;
                }
                if (Parser.nodeNameEquals(e, BEAN_ELEMENT)) {
                    if (listenerComponent != null) {
                        throw new ComponentDefinitionException("Only one of ref attribute, ref, bean, reference, service or custom element can be set");
                    }
                    listenerComponent = this.parseBeanMetadata(e, false);
                    continue;
                }
                if (Parser.nodeNameEquals(e, REFERENCE_ELEMENT)) {
                    if (listenerComponent != null) {
                        throw new ComponentDefinitionException("Only one of ref attribute, ref, bean, reference, service or custom element can be set");
                    }
                    listenerComponent = this.parseReference(e, false);
                    continue;
                }
                if (!Parser.nodeNameEquals(e, SERVICE_ELEMENT)) continue;
                if (listenerComponent != null) {
                    throw new ComponentDefinitionException("Only one of ref attribute, ref, bean, reference, service or custom element can be set");
                }
                listenerComponent = this.parseService(e, false);
                continue;
            }
            if (listenerComponent != null) {
                throw new ComponentDefinitionException("Only one of ref attribute, ref, bean, reference, service or custom element can be set");
            }
            listenerComponent = this.parseCustomElement(e, enclosingComponent);
        }
        if (listenerComponent == null) {
            throw new ComponentDefinitionException("One of ref attribute, ref, bean, reference, service or custom element must be set");
        }
        listener.setListenerComponent((Target)listenerComponent);
        return listener;
    }

    private ComponentMetadata parseReference(Element element, boolean topElement) {
        ReferenceMetadataImpl reference = new ReferenceMetadataImpl();
        if (topElement) {
            reference.setId(this.getId(element));
        }
        this.parseReference(element, reference, topElement);
        String timeout = element.hasAttribute(TIMEOUT_ATTRIBUTE) ? element.getAttribute(TIMEOUT_ATTRIBUTE) : this.defaultTimeout;
        try {
            reference.setTimeout(Long.parseLong(timeout));
        }
        catch (NumberFormatException e) {
            throw new ComponentDefinitionException("Attribute timeout must be a valid long (was: " + timeout + ")");
        }
        ComponentMetadata r = reference;
        r = this.handleCustomAttributes(element.getAttributes(), r);
        r = this.handleCustomElements(element, r);
        return r;
    }

    private ComponentMetadata parseRefList(Element element, boolean topElement) {
        ReferenceListMetadataImpl references = new ReferenceListMetadataImpl();
        if (topElement) {
            references.setId(this.getId(element));
        }
        if (element.hasAttribute(MEMBER_TYPE_ATTRIBUTE)) {
            String memberType = element.getAttribute(MEMBER_TYPE_ATTRIBUTE);
            if (USE_SERVICE_OBJECT.equals(memberType)) {
                references.setMemberType(1);
            } else if (USE_SERVICE_REFERENCE.equals(memberType)) {
                references.setMemberType(2);
            }
        } else {
            references.setMemberType(1);
        }
        this.parseReference(element, references, topElement);
        ComponentMetadata r = references;
        r = this.handleCustomAttributes(element.getAttributes(), r);
        r = this.handleCustomElements(element, r);
        return r;
    }

    private void parseReference(Element element, ServiceReferenceMetadataImpl reference, boolean topElement) {
        String availability;
        if (topElement) {
            reference.setActivation(this.parseActivation(element));
        } else {
            reference.setActivation(2);
        }
        if (element.hasAttribute(DEPENDS_ON_ATTRIBUTE)) {
            reference.setDependsOn(Parser.parseList(element.getAttribute(DEPENDS_ON_ATTRIBUTE)));
        }
        if (element.hasAttribute(INTERFACE_ATTRIBUTE)) {
            reference.setInterface(element.getAttribute(INTERFACE_ATTRIBUTE));
        }
        if (element.hasAttribute(FILTER_ATTRIBUTE)) {
            reference.setFilter(element.getAttribute(FILTER_ATTRIBUTE));
        }
        if (element.hasAttribute(COMPONENT_NAME_ATTRIBUTE)) {
            reference.setComponentName(element.getAttribute(COMPONENT_NAME_ATTRIBUTE));
        }
        String string = availability = element.hasAttribute(AVAILABILITY_ATTRIBUTE) ? element.getAttribute(AVAILABILITY_ATTRIBUTE) : this.defaultAvailability;
        if ("mandatory".equals(availability)) {
            reference.setAvailability(1);
        } else if (AVAILABILITY_OPTIONAL.equals(availability)) {
            reference.setAvailability(2);
        } else {
            throw new ComponentDefinitionException("Illegal value for availability attribute: " + availability);
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e;
            Node node = nl.item(i);
            if (!(node instanceof Element) || !Parser.isBlueprintNamespace((e = (Element)node).getNamespaceURI()) || !Parser.nodeNameEquals(e, REFERENCE_LISTENER_ELEMENT)) continue;
            reference.addServiceListener(this.parseServiceListener(e, reference));
        }
    }

    private ReferenceListener parseServiceListener(Element element, ComponentMetadata enclosingComponent) {
        ReferenceListenerImpl listener = new ReferenceListenerImpl();
        Metadata listenerComponent = null;
        if (element.hasAttribute("ref")) {
            listenerComponent = new RefMetadataImpl(element.getAttribute("ref"));
        }
        String bindMethodName = null;
        String unbindMethodName = null;
        if (element.hasAttribute(BIND_METHOD_ATTRIBUTE)) {
            bindMethodName = element.getAttribute(BIND_METHOD_ATTRIBUTE);
            listener.setBindMethod(bindMethodName);
        }
        if (element.hasAttribute(UNBIND_METHOD_ATTRIBUTE)) {
            unbindMethodName = element.getAttribute(UNBIND_METHOD_ATTRIBUTE);
            listener.setUnbindMethod(unbindMethodName);
        }
        if (bindMethodName == null && unbindMethodName == null) {
            throw new ComponentDefinitionException("One of bind-method or unbind-method must be set");
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (Parser.isBlueprintNamespace(e.getNamespaceURI())) {
                if (Parser.nodeNameEquals(e, "ref")) {
                    if (listenerComponent != null) {
                        throw new ComponentDefinitionException("Only one of ref attribute, ref, blueprint, reference, service or custom element can be set");
                    }
                    String component = e.getAttribute(COMPONENT_ID_ATTRIBUTE);
                    if (component == null || component.length() == 0) {
                        throw new ComponentDefinitionException("Element ref must have a valid component-id attribute");
                    }
                    listenerComponent = new RefMetadataImpl(component);
                    continue;
                }
                if (Parser.nodeNameEquals(e, BEAN_ELEMENT)) {
                    if (listenerComponent != null) {
                        throw new ComponentDefinitionException("Only one of ref attribute, ref, blueprint, reference, service or custom element can be set");
                    }
                    listenerComponent = this.parseBeanMetadata(e, false);
                    continue;
                }
                if (Parser.nodeNameEquals(e, REFERENCE_ELEMENT)) {
                    if (listenerComponent != null) {
                        throw new ComponentDefinitionException("Only one of ref attribute, ref, blueprint, reference, service or custom element can be set");
                    }
                    listenerComponent = this.parseReference(e, false);
                    continue;
                }
                if (!Parser.nodeNameEquals(e, SERVICE_ELEMENT)) continue;
                if (listenerComponent != null) {
                    throw new ComponentDefinitionException("Only one of ref attribute, ref, blueprint, reference, service or custom element can be set");
                }
                listenerComponent = this.parseService(e, false);
                continue;
            }
            if (listenerComponent != null) {
                throw new ComponentDefinitionException("Only one of ref attribute, ref, blueprint, reference, service or custom element can be set");
            }
            listenerComponent = this.parseCustomElement(e, enclosingComponent);
        }
        if (listenerComponent == null) {
            throw new ComponentDefinitionException("One of ref attribute, ref, blueprint, reference, service or custom element must be set");
        }
        listener.setListenerComponent((Target)listenerComponent);
        return listener;
    }

    public List<String> parseInterfaceNames(Element element) {
        ArrayList<String> interfaceNames = new ArrayList<String>();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (Parser.nodeNameEquals(e, "value")) {
                String v = Parser.getTextValue(e).trim();
                if (interfaceNames.contains(v)) {
                    throw new ComponentDefinitionException("The element interfaces should not contain the same interface twice");
                }
                interfaceNames.add(Parser.getTextValue(e));
                continue;
            }
            throw new ComponentDefinitionException("Unsupported element " + e.getNodeName() + " inside an " + "interfaces" + " element");
        }
        return interfaceNames;
    }

    private Metadata parseArgumentOrPropertyValue(Element element, ComponentMetadata enclosingComponent) {
        Metadata[] values = new Metadata[3];
        if (element.hasAttribute("ref")) {
            values[0] = new RefMetadataImpl(element.getAttribute("ref"));
        }
        if (element.hasAttribute("value")) {
            values[1] = new ValueMetadataImpl(element.getAttribute("value"));
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (Parser.isBlueprintNamespace(node.getNamespaceURI()) && Parser.nodeNameEquals(node, DESCRIPTION_ELEMENT)) continue;
            values[2] = this.parseValueGroup(e, enclosingComponent, null, true);
            break;
        }
        Metadata value = null;
        for (Metadata v : values) {
            if (v == null) continue;
            if (value == null) {
                value = v;
                continue;
            }
            throw new ComponentDefinitionException("Only one of ref attribute, value attribute or sub element must be set");
        }
        if (value == null) {
            throw new ComponentDefinitionException("One of ref attribute, value attribute or sub element must be set");
        }
        return value;
    }

    private Metadata parseValueGroup(Element element, ComponentMetadata enclosingComponent, String collectionType, boolean allowNull) {
        if (Parser.isBlueprintNamespace(element.getNamespaceURI())) {
            if (Parser.nodeNameEquals(element, BEAN_ELEMENT)) {
                return this.parseBeanMetadata(element, false);
            }
            if (Parser.nodeNameEquals(element, REFERENCE_ELEMENT)) {
                return this.parseReference(element, false);
            }
            if (Parser.nodeNameEquals(element, SERVICE_ELEMENT)) {
                return this.parseService(element, false);
            }
            if (Parser.nodeNameEquals(element, REFERENCE_LIST_ELEMENT)) {
                return this.parseRefList(element, false);
            }
            if (Parser.nodeNameEquals(element, NULL_ELEMENT) && allowNull) {
                return NullMetadata.NULL;
            }
            if (Parser.nodeNameEquals(element, "value")) {
                return this.parseValue(element, collectionType);
            }
            if (Parser.nodeNameEquals(element, "ref")) {
                return this.parseRef(element);
            }
            if (Parser.nodeNameEquals(element, IDREF_ELEMENT)) {
                return this.parseIdRef(element);
            }
            if (Parser.nodeNameEquals(element, LIST_ELEMENT)) {
                return this.parseList(element, enclosingComponent);
            }
            if (Parser.nodeNameEquals(element, SET_ELEMENT)) {
                return this.parseSet(element, enclosingComponent);
            }
            if (Parser.nodeNameEquals(element, MAP_ELEMENT)) {
                return this.parseMap(element, enclosingComponent);
            }
            if (Parser.nodeNameEquals(element, PROPS_ELEMENT)) {
                return this.parseProps(element);
            }
            if (Parser.nodeNameEquals(element, ARRAY_ELEMENT)) {
                return this.parseArray(element, enclosingComponent);
            }
            throw new ComponentDefinitionException("Unknown blueprint element " + element.getNodeName());
        }
        return this.parseCustomElement(element, enclosingComponent);
    }

    private ValueMetadata parseValue(Element element, String collectionType) {
        String type = null;
        type = element.hasAttribute(TYPE_ATTRIBUTE) ? element.getAttribute(TYPE_ATTRIBUTE) : collectionType;
        return new ValueMetadataImpl(Parser.getTextValue(element), type);
    }

    private RefMetadata parseRef(Element element) {
        String component = element.getAttribute(COMPONENT_ID_ATTRIBUTE);
        if (component == null || component.length() == 0) {
            throw new ComponentDefinitionException("Element ref must have a valid component-id attribute");
        }
        return new RefMetadataImpl(component);
    }

    private Metadata parseIdRef(Element element) {
        String component = element.getAttribute(COMPONENT_ID_ATTRIBUTE);
        if (component == null || component.length() == 0) {
            throw new ComponentDefinitionException("Element idref must have a valid component-id attribute");
        }
        return new IdRefMetadataImpl(component);
    }

    private int parseActivation(Element element) {
        String initialization;
        String string = initialization = element.hasAttribute(ACTIVATION_ATTRIBUTE) ? element.getAttribute(ACTIVATION_ATTRIBUTE) : this.defaultActivation;
        if ("eager".equals(initialization)) {
            return 1;
        }
        if (ACTIVATION_LAZY.equals(initialization)) {
            return 2;
        }
        throw new ComponentDefinitionException("Attribute activation must be equal to eager or lazy");
    }

    private ComponentMetadata handleCustomAttributes(NamedNodeMap attributes, ComponentMetadata enclosingComponent) {
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node node = attributes.item(i);
                if (!(node instanceof Attr) || node.getNamespaceURI() == null || Parser.isBlueprintNamespace(node.getNamespaceURI())) continue;
                enclosingComponent = this.decorateCustomNode(node, enclosingComponent);
            }
        }
        return enclosingComponent;
    }

    private ComponentMetadata handleCustomElements(Element element, ComponentMetadata enclosingComponent) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || Parser.isBlueprintNamespace(node.getNamespaceURI())) continue;
            enclosingComponent = this.decorateCustomNode(node, enclosingComponent);
        }
        return enclosingComponent;
    }

    private ComponentMetadata decorateCustomNode(Node node, ComponentMetadata enclosingComponent) {
        NamespaceHandler handler = this.getNamespaceHandler(node);
        ParserContextImpl context = new ParserContextImpl(this, this.registry, enclosingComponent, node);
        return handler.decorate(node, enclosingComponent, context);
    }

    private Metadata parseCustomElement(Element element, ComponentMetadata enclosingComponent) {
        NamespaceHandler handler = this.getNamespaceHandler(element);
        ParserContextImpl context = new ParserContextImpl(this, this.registry, enclosingComponent, element);
        return handler.parse(element, context);
    }

    private NamespaceHandler getNamespaceHandler(Node node) {
        if (this.namespaceHandlerRegistry == null) {
            throw new ComponentDefinitionException("Unsupported node (namespace handler registry is not set): " + node);
        }
        URI ns = URI.create(node.getNamespaceURI());
        NamespaceHandler handler = this.namespaceHandlerRegistry.getNamespaceHandler(ns);
        if (handler == null) {
            throw new ComponentDefinitionException("Unsupported node namespace: " + node.getNamespaceURI());
        }
        return handler;
    }

    public String getId(Element element) {
        String id;
        if (element.hasAttribute(ID_ATTRIBUTE)) {
            id = element.getAttribute(ID_ATTRIBUTE);
        } else {
            while (this.ids.contains(id = "." + this.idPrefix + ++this.idCounter)) {
            }
        }
        this.ids.add(id);
        return id;
    }

    public static boolean isBlueprintNamespace(String ns) {
        return BLUEPRINT_NAMESPACE.equals(ns);
    }

    private static boolean nodeNameEquals(Node node, String name) {
        return name.equals(node.getNodeName()) || name.equals(node.getLocalName());
    }

    private static List<String> parseList(String list) {
        String[] items = list.split(" ");
        ArrayList<String> set = new ArrayList<String>();
        for (String item : items) {
            if ((item = item.trim()).length() <= 0) continue;
            set.add(item);
        }
        return set;
    }

    private static String getTextValue(Element element) {
        StringBuffer value = new StringBuffer();
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference)) continue;
            value.append(item.getNodeValue());
        }
        return value.toString();
    }

    private static DocumentBuilderFactory getDocumentBuilderFactory() {
        if (documentBuilderFactory == null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            documentBuilderFactory = dbf;
        }
        return documentBuilderFactory;
    }
}

