/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.namespace;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URL;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.container.NamespaceHandlerRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceHandlerRegistryImpl
implements NamespaceHandlerRegistry,
ServiceTrackerCustomizer {
    public static final URI BLUEPRINT_NAMESPACE = URI.create("http://www.osgi.org/xmlns/blueprint/v1.0.0");
    public static final String NAMESPACE = "osgi.service.blueprint.namespace";
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceHandlerRegistryImpl.class);
    private final BundleContext bundleContext;
    private final Map<URI, NamespaceHandler> handlers;
    private final ServiceTracker tracker;
    private final Map<NamespaceHandlerRegistry.Listener, Boolean> listeners;
    private final Map<Set<URI>, Reference<Schema>> schemas = new LRUMap<Set<URI>, Reference<Schema>>(10);
    private SchemaFactory schemaFactory;

    public NamespaceHandlerRegistryImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.handlers = new HashMap<URI, NamespaceHandler>();
        this.tracker = new ServiceTracker(bundleContext, NamespaceHandler.class.getName(), (ServiceTrackerCustomizer)this);
        this.tracker.open();
        this.listeners = new HashMap<NamespaceHandlerRegistry.Listener, Boolean>();
    }

    public Object addingService(ServiceReference reference) {
        NamespaceHandler handler = (NamespaceHandler)this.bundleContext.getService(reference);
        try {
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (String name : reference.getPropertyKeys()) {
                props.put(name, reference.getProperty(name));
            }
            this.registerHandler(handler, props);
        }
        catch (Exception e) {
            LOGGER.warn("Error registering NamespaceHandler", (Throwable)e);
        }
        return handler;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.removedService(reference, service);
        this.addingService(reference);
    }

    public void removedService(ServiceReference reference, Object service) {
        try {
            NamespaceHandler handler = (NamespaceHandler)service;
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (String name : reference.getPropertyKeys()) {
                props.put(name, reference.getProperty(name));
            }
            this.unregisterHandler(handler, props);
        }
        catch (Exception e) {
            LOGGER.warn("Error unregistering NamespaceHandler", (Throwable)e);
        }
    }

    public synchronized void registerHandler(NamespaceHandler handler, Map properties) {
        List<URI> namespaces = NamespaceHandlerRegistryImpl.getNamespaces(properties);
        for (URI uri : namespaces) {
            if (this.handlers.containsKey(uri)) {
                LOGGER.warn("Ignoring NamespaceHandler for namespace {}, as another handler has already been registered for the same namespace", (Object)uri);
                continue;
            }
            this.handlers.put(uri, handler);
            this.callListeners(uri, true);
        }
    }

    public synchronized void unregisterHandler(NamespaceHandler handler, Map properties) {
        List<URI> namespaces = NamespaceHandlerRegistryImpl.getNamespaces(properties);
        for (URI uri : namespaces) {
            if (this.handlers.get(uri) != handler) continue;
            this.handlers.remove(uri);
            this.callListeners(uri, false);
        }
        this.removeSchemasFor(namespaces);
    }

    private void callListeners(URI uri, boolean registered) {
        for (NamespaceHandlerRegistry.Listener listener : this.listeners.keySet()) {
            try {
                if (registered) {
                    listener.namespaceHandlerRegistered(uri);
                    continue;
                }
                listener.namespaceHandlerUnregistered(uri);
            }
            catch (Throwable t) {
                LOGGER.debug("Unexpected exception when notifying a NamespaceHandler listener", t);
            }
        }
    }

    private static List<URI> getNamespaces(Map properties) {
        Object ns;
        Object v0 = ns = properties != null ? properties.get(NAMESPACE) : null;
        if (ns == null) {
            throw new IllegalArgumentException("NamespaceHandler service does not have an associated osgi.service.blueprint.namespace property defined");
        }
        if (ns instanceof URI[]) {
            return Arrays.asList(ns);
        }
        if (ns instanceof URI) {
            return Collections.singletonList(ns);
        }
        if (ns instanceof String) {
            return Collections.singletonList(URI.create(ns));
        }
        if (ns instanceof String[]) {
            String[] strings = ns;
            ArrayList<URI> namespaces = new ArrayList<URI>(strings.length);
            for (String string : strings) {
                namespaces.add(URI.create(string));
            }
            return namespaces;
        }
        if (ns instanceof Collection) {
            Collection col = ns;
            ArrayList<URI> namespaces = new ArrayList<URI>(col.size());
            for (Object o : col) {
                namespaces.add(NamespaceHandlerRegistryImpl.toURI(o));
            }
            return namespaces;
        }
        if (ns instanceof Object[]) {
            Object[] array = ns;
            ArrayList<URI> namespaces = new ArrayList<URI>(array.length);
            for (Object o : array) {
                namespaces.add(NamespaceHandlerRegistryImpl.toURI(o));
            }
            return namespaces;
        }
        throw new IllegalArgumentException("NamespaceHandler service has an associated osgi.service.blueprint.namespace property defined which can not be converted to an array of URI");
    }

    private static URI toURI(Object o) {
        if (o instanceof URI) {
            return (URI)o;
        }
        if (o instanceof String) {
            return URI.create((String)o);
        }
        throw new IllegalArgumentException("NamespaceHandler service has an associated osgi.service.blueprint.namespace property defined which can not be converted to an array of URI");
    }

    @Override
    public synchronized NamespaceHandler getNamespaceHandler(URI uri) {
        return this.handlers.get(uri);
    }

    @Override
    public void destroy() {
        this.tracker.close();
    }

    @Override
    public synchronized void addListener(NamespaceHandlerRegistry.Listener listener) {
        this.listeners.put(listener, Boolean.TRUE);
    }

    @Override
    public synchronized void removeListener(NamespaceHandlerRegistry.Listener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Schema getSchema(Set<URI> namespaces) throws IOException, SAXException {
        Schema schema = null;
        for (Set<URI> key : this.schemas.keySet()) {
            if (!key.containsAll(namespaces)) continue;
            schema = this.schemas.get(key).get();
            break;
        }
        if (schema == null) {
            ArrayList<StreamSource> schemaSources = new ArrayList<StreamSource>();
            try {
                schemaSources.add(new StreamSource(this.getClass().getResourceAsStream("/org/apache/aries/blueprint/blueprint.xsd")));
                namespaces = new HashSet<URI>(this.handlers.keySet());
                namespaces.add(BLUEPRINT_NAMESPACE);
                for (URI ns : namespaces) {
                    if (BLUEPRINT_NAMESPACE.equals(ns)) continue;
                    NamespaceHandler handler = this.getNamespaceHandler(ns);
                    if (handler == null) {
                        throw new IllegalArgumentException("No namespace handler has been registered for " + ns);
                    }
                    URL url = handler.getSchemaLocation(ns.toString());
                    if (url == null) {
                        LOGGER.warn("No URL is defined for schema " + ns + ". This schema will not be validated");
                        continue;
                    }
                    schemaSources.add(new StreamSource(url.openStream()));
                }
                schema = this.getSchemaFactory().newSchema(schemaSources.toArray(new Source[schemaSources.size()]));
                this.schemas.put(namespaces, new SoftReference<Schema>(schema));
            }
            finally {
                for (StreamSource s : schemaSources) {
                    try {
                        s.getInputStream().close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return schema;
    }

    protected synchronized void removeSchemasFor(List<URI> namespaces) {
        ArrayList<Set<URI>> keys = new ArrayList<Set<URI>>();
        for (URI uRI : namespaces) {
            for (Set<URI> key : this.schemas.keySet()) {
                if (!key.contains(uRI)) continue;
                keys.add(key);
            }
        }
        for (Set set : keys) {
            this.schemas.remove(set);
        }
    }

    private SchemaFactory getSchemaFactory() {
        if (this.schemaFactory == null) {
            this.schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        }
        return this.schemaFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LRUMap<K, V>
    extends AbstractMap<K, V> {
        private final int bound;
        private final LinkedList<Map.Entry<K, V>> entries = new LinkedList();

        private LRUMap(int bound) {
            this.bound = bound;
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            for (Map.Entry entry : this.entries) {
                if (!entry.getKey().equals(key)) continue;
                this.entries.remove(entry);
                this.entries.addFirst(entry);
                return entry.getValue();
            }
            return null;
        }

        @Override
        public V put(K key, V value) {
            if (key == null) {
                throw new NullPointerException();
            }
            V old = null;
            for (Map.Entry entry : this.entries) {
                if (!entry.getKey().equals(key)) continue;
                this.entries.remove(entry);
                old = entry.getValue();
                break;
            }
            if (value != null) {
                this.entries.addFirst(new LRUEntry(key, value));
                while (this.entries.size() > this.bound) {
                    this.entries.removeLast();
                }
            }
            return old;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return LRUMap.this.entries.iterator();
                }

                @Override
                public int size() {
                    return LRUMap.this.entries.size();
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class LRUEntry<K, V>
        implements Map.Entry<K, V> {
            private final K key;
            private final V value;

            private LRUEntry(K key, V value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

