/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    private static Map<Class, PropertyDescriptor[]> beanInfos = Collections.synchronizedMap(new WeakHashMap());

    public static boolean hasDefaultConstructor(Class type) {
        Constructor<?>[] constructors;
        if (!Modifier.isPublic(type.getModifiers())) {
            return false;
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            return false;
        }
        for (Constructor<?> constructor : constructors = type.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getImplementedInterfaces(Set<String> classes, Class clazz) {
        if (clazz != null && clazz != Object.class) {
            for (Class<?> itf : clazz.getInterfaces()) {
                if (Modifier.isPublic(itf.getModifiers())) {
                    classes.add(itf.getName());
                }
                ReflectionUtils.getImplementedInterfaces(classes, itf);
            }
            ReflectionUtils.getImplementedInterfaces(classes, clazz.getSuperclass());
        }
        return classes;
    }

    public static Set<String> getSuperClasses(Set<String> classes, Class clazz) {
        if (clazz != null && clazz != Object.class) {
            if (Modifier.isPublic(clazz.getModifiers())) {
                classes.add(clazz.getName());
            }
            ReflectionUtils.getSuperClasses(classes, clazz.getSuperclass());
        }
        return classes;
    }

    public static Method getLifecycleMethod(Class clazz, String name) {
        if (name != null) {
            try {
                Method method = clazz.getMethod(name, new Class[0]);
                if (Void.TYPE.equals(method.getReturnType())) {
                    return method;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<Method> findCompatibleMethods(Class clazz, String name, Class[] paramTypes) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            Class<?>[] methodParams = method.getParameterTypes();
            if (!name.equals(method.getName()) || !Void.TYPE.equals(method.getReturnType()) || methodParams.length != paramTypes.length) continue;
            boolean assignable = true;
            for (int i = 0; i < paramTypes.length && assignable; assignable &= paramTypes[i] == null || methodParams[i].isAssignableFrom(paramTypes[i]), ++i) {
            }
            if (!assignable) continue;
            methods.add(method);
        }
        return methods;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class clazz) {
        PropertyDescriptor[] properties = beanInfos.get(clazz);
        if (properties == null) {
            int i;
            ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
            for (Method method : clazz.getMethods()) {
                if (Modifier.isStatic(method.getModifiers())) continue;
                String name = method.getName();
                Class<?>[] argTypes = method.getParameterTypes();
                Class<?> resultType = method.getReturnType();
                if (name.length() > 3 && name.startsWith("set") && resultType == Void.TYPE && argTypes.length == 1) {
                    props.add(new PropertyDescriptor(ReflectionUtils.decapitalize(name.substring(3)), argTypes[0], null, method));
                    continue;
                }
                if (name.length() > 3 && name.startsWith("get") && argTypes.length == 0) {
                    props.add(new PropertyDescriptor(ReflectionUtils.decapitalize(name.substring(3)), resultType, method, null));
                    continue;
                }
                if (name.length() <= 2 || !name.startsWith("is") || argTypes.length != 0 || resultType != Boolean.TYPE) continue;
                props.add(new PropertyDescriptor(ReflectionUtils.decapitalize(name.substring(2)), resultType, method, null));
            }
            PropertyDescriptor[] pds = props.toArray(new PropertyDescriptor[props.size()]);
            for (i = 0; i < pds.length - 1; ++i) {
                boolean remove = false;
                for (int j = i + 1; j < pds.length; ++j) {
                    if (pds[i] == null || pds[j] == null || !pds[i].name.equals(pds[j].name)) continue;
                    if (remove || !pds[i].type.equals(pds[j].type)) {
                        remove = true;
                        pds[j] = null;
                        continue;
                    }
                    if (pds[j].getter != null) {
                        if (pds[i].getter == null) {
                            pds[i].getter = pds[j].getter;
                        } else if (pds[i].getter != pds[j].getter) {
                            remove = true;
                            pds[j] = null;
                            continue;
                        }
                    }
                    if (pds[j].setter == null) continue;
                    if (pds[i].setter == null) {
                        pds[i].setter = pds[j].setter;
                        continue;
                    }
                    if (pds[i].setter == pds[j].setter) continue;
                    remove = true;
                    pds[j] = null;
                }
                if (!remove) continue;
                pds[i] = null;
            }
            props.clear();
            for (i = 0; i < pds.length - 1; ++i) {
                if (pds[i] == null) continue;
                pds[i].type = null;
                props.add(pds[i]);
            }
            properties = props.toArray(new PropertyDescriptor[props.size()]);
            beanInfos.put(clazz, properties);
        }
        return properties;
    }

    private static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static Object invoke(AccessControlContext acc, final Method method, final Object instance, final Object ... args) throws Exception {
        if (acc == null) {
            return method.invoke(instance, args);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return method.invoke(instance, args);
                }
            }, acc);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static Object newInstance(AccessControlContext acc, final Class clazz) throws Exception {
        if (acc == null) {
            return clazz.newInstance();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return clazz.newInstance();
                }
            }, acc);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static Object newInstance(AccessControlContext acc, final Constructor constructor, final Object ... args) throws Exception {
        if (acc == null) {
            return constructor.newInstance(args);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return constructor.newInstance(args);
                }
            }, acc);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static Throwable getRealCause(Throwable t) {
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            return t.getCause();
        }
        return t;
    }

    public static class PropertyDescriptor {
        private String name;
        private Class type;
        private Method getter;
        private Method setter;

        public PropertyDescriptor(String name, Class type, Method getter, Method setter) {
            this.name = name;
            this.type = type;
            this.getter = getter;
            this.setter = setter;
        }

        public String getName() {
            return this.name;
        }

        public Method getGetter() {
            return this.getter;
        }

        public Method getSetter() {
            return this.setter;
        }
    }
}

