/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.plugin.esa;

import aQute.lib.osgi.Analyzer;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.aries.plugin.esa.ContentInfo;
import org.apache.aries.util.manifest.BundleManifest;
import org.apache.maven.archiver.PomPropertiesUtil;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class EsaMojo
extends AbstractMojo {
    public static final String SUBSYSTEM_MF_URI = "OSGI-INF/SUBSYSTEM.MF";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final Set<String> SKIP_INSTRUCTIONS = new HashSet<String>();
    private File esaSourceDirectory;
    private File subsystemManifestFile;
    private File manifestFile;
    private String workDirectory;
    private String sharedResources;
    private String outputDirectory;
    private String finalName;
    private MavenProject project;
    private ZipArchiver zipArchiver;
    private boolean generateManifest;
    private Map instructions = new LinkedHashMap();
    private boolean addMavenDescriptor;
    private boolean includeEmptyDirs;
    private boolean forceCreation;
    private String archiveContent;
    private String manifestContent;
    private String startOrder;
    private File buildDir;

    private void addDependenciesToArchive() throws MojoExecutionException {
        try {
            Set<Artifact> artifacts = null;
            switch (EsaContent.valueOf(this.archiveContent)) {
                case none: {
                    this.getLog().info((CharSequence)"archiveContent=none: subsystem archive will not contain any bundles.");
                    break;
                }
                case content: {
                    artifacts = this.project.getDependencyArtifacts();
                    break;
                }
                case all: {
                    artifacts = this.project.getArtifacts();
                    break;
                }
                default: {
                    throw new MojoExecutionException("Invalid configuration for <archiveContent/>.  Valid values are none, content and all.");
                }
            }
            if (artifacts != null) {
                Artifact selfArtifact = this.project.getArtifact();
                if (!"esa".equals(selfArtifact.getType()) && selfArtifact.getFile() != null) {
                    this.getLog().info((CharSequence)("Explicitly adding artifact[" + selfArtifact.getGroupId() + ", " + selfArtifact.getId() + ", " + selfArtifact.getScope() + "]"));
                    artifacts.add(this.project.getArtifact());
                }
                artifacts = this.selectArtifactsInCompileOrRuntimeScope(artifacts);
                artifacts = this.selectNonJarArtifactsAndBundles(artifacts);
                int cnt = 0;
                for (Artifact artifact : artifacts) {
                    if (artifact.isOptional()) continue;
                    this.getLog().info((CharSequence)("Copying artifact[" + artifact.getGroupId() + ", " + artifact.getId() + ", " + artifact.getScope() + "]"));
                    this.zipArchiver.addFile(artifact.getFile(), artifact.getArtifactId() + "-" + artifact.getVersion() + "." + (artifact.getType() == null ? "jar" : artifact.getType()));
                    ++cnt;
                }
                this.getLog().info((CharSequence)String.format("Added %s artifacts to subsystem subsystem archive.", cnt));
            }
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error copying esa dependencies", (Exception)((Object)e));
        }
    }

    private void copyEsaSourceFiles() throws MojoExecutionException {
        try {
            File esaSourceDir = this.esaSourceDirectory;
            if (esaSourceDir.exists()) {
                this.getLog().info((CharSequence)("Copy esa resources to " + this.getBuildDir().getAbsolutePath()));
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(esaSourceDir.getAbsolutePath());
                scanner.setIncludes(DEFAULT_INCLUDES);
                scanner.addDefaultExcludes();
                scanner.scan();
                String[] dirs = scanner.getIncludedDirectories();
                for (int j = 0; j < dirs.length; ++j) {
                    new File(this.getBuildDir(), dirs[j]).mkdirs();
                }
                String[] files = scanner.getIncludedFiles();
                for (int j = 0; j < files.length; ++j) {
                    File targetFile = new File(this.getBuildDir(), files[j]);
                    targetFile.getParentFile().mkdirs();
                    File file = new File(esaSourceDir, files[j]);
                    FileUtils.copyFileToDirectory((File)file, (File)targetFile.getParentFile());
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error copying esa resources", e);
        }
    }

    private void includeCustomManifest() throws MojoExecutionException {
        try {
            if (!this.generateManifest) {
                this.includeCustomSubsystemManifestFile();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying SUBSYSTEM.MF file", (Exception)e);
        }
    }

    private void generateSubsystemManifest() throws MojoExecutionException {
        File ddFile;
        if (this.generateManifest) {
            String fileName = new String(this.getBuildDir() + "/" + SUBSYSTEM_MF_URI);
            File appMfFile = new File(fileName);
            try {
                if (appMfFile.exists()) {
                    FileUtils.fileDelete((String)fileName);
                }
                appMfFile.getParentFile().mkdirs();
                if (appMfFile.createNewFile()) {
                    this.writeSubsystemManifest(fileName);
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error generating SUBSYSTEM.MF file: " + fileName, (Exception)e);
            }
        }
        if (!(ddFile = new File(this.getBuildDir(), SUBSYSTEM_MF_URI)).exists()) {
            this.getLog().warn((CharSequence)("Subsystem manifest: " + ddFile.getAbsolutePath() + " does not exist."));
        }
    }

    private void addMavenDescriptor() throws MojoExecutionException {
        try {
            if (this.addMavenDescriptor) {
                if (this.project.getArtifact().isSnapshot()) {
                    this.project.setVersion(this.project.getArtifact().getVersion());
                }
                String groupId = this.project.getGroupId();
                String artifactId = this.project.getArtifactId();
                this.zipArchiver.addFile(this.project.getFile(), "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
                PomPropertiesUtil pomPropertiesUtil = new PomPropertiesUtil();
                File dir = new File(this.project.getBuild().getDirectory(), "maven-zip-plugin");
                File pomPropertiesFile = new File(dir, "pom.properties");
                pomPropertiesUtil.createPomProperties(this.project, (Archiver)this.zipArchiver, pomPropertiesFile, this.forceCreation);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling esa", e);
        }
    }

    private void init() {
        this.getLog().debug((CharSequence)" ======= esaMojo settings =======");
        this.getLog().debug((CharSequence)("esaSourceDirectory[" + this.esaSourceDirectory + "]"));
        this.getLog().debug((CharSequence)("manifestFile[" + this.manifestFile + "]"));
        this.getLog().debug((CharSequence)("subsystemManifestFile[" + this.subsystemManifestFile + "]"));
        this.getLog().debug((CharSequence)("workDirectory[" + this.workDirectory + "]"));
        this.getLog().debug((CharSequence)("outputDirectory[" + this.outputDirectory + "]"));
        this.getLog().debug((CharSequence)("finalName[" + this.finalName + "]"));
        this.getLog().debug((CharSequence)("generateManifest[" + this.generateManifest + "]"));
        if (this.archiveContent == null) {
            this.archiveContent = new String("content");
        }
        this.getLog().debug((CharSequence)("archiveContent[" + this.archiveContent + "]"));
        this.getLog().info((CharSequence)("archiveContent[" + this.archiveContent + "]"));
        if (this.manifestContent == null) {
            this.manifestContent = new String("content");
        }
        this.getLog().debug((CharSequence)("manifestContent[" + this.archiveContent + "]"));
        this.getLog().info((CharSequence)("manifestContent[" + this.archiveContent + "]"));
        this.zipArchiver.setIncludeEmptyDirs(this.includeEmptyDirs);
        this.zipArchiver.setCompress(true);
        this.zipArchiver.setForced(this.forceCreation);
    }

    private void writeSubsystemManifest(String fileName) throws MojoExecutionException {
        try {
            FileUtils.fileAppend((String)fileName, (String)"Subsystem-ManifestVersion: 1\n");
            FileUtils.fileAppend((String)fileName, (String)("Subsystem-SymbolicName: " + this.getSubsystemSymbolicName(this.project.getArtifact()) + "\n"));
            FileUtils.fileAppend((String)fileName, (String)("Subsystem-Version: " + this.getSubsystemVersion() + "\n"));
            FileUtils.fileAppend((String)fileName, (String)("Subsystem-Name: " + this.getSubsystemName() + "\n"));
            String description = this.getSubsystemDescription();
            if (description != null) {
                FileUtils.fileAppend((String)fileName, (String)("Subsystem-Description: " + description + "\n"));
            }
            Set<Artifact> artifacts = null;
            switch (EsaManifestContent.valueOf(this.manifestContent)) {
                case content: {
                    artifacts = this.project.getDependencyArtifacts();
                    break;
                }
                case all: {
                    artifacts = this.project.getArtifacts();
                    break;
                }
                default: {
                    throw new MojoExecutionException("Invalid configuration for <manifestContent/>.  Valid values are content and all.");
                }
            }
            artifacts = this.selectArtifactsInCompileOrRuntimeScope(artifacts);
            artifacts = this.selectNonJarArtifactsAndBundles(artifacts);
            Iterator<Artifact> iter = artifacts.iterator();
            FileUtils.fileAppend((String)fileName, (String)"Subsystem-Content: ");
            int order = 0;
            int nbInSubsystemContent = 0;
            while (iter.hasNext()) {
                Artifact artifact = iter.next();
                ++order;
                ContentInfo info = ContentInfo.create(artifact, this.getLog());
                if (info == null) continue;
                String entry = info.getContentLine();
                if ("dependencies".equals(this.startOrder)) {
                    entry = entry + ";start-order:=\"" + order + "\"";
                }
                if (iter.hasNext()) {
                    entry = entry + ",\n ";
                }
                ++nbInSubsystemContent;
                FileUtils.fileAppend((String)fileName, (String)entry);
            }
            this.getLog().info((CharSequence)("Added '" + nbInSubsystemContent + "' artefacts to the Subsystem-Content header"));
            FileUtils.fileAppend((String)fileName, (String)"\n");
            for (Map.Entry entry : this.instructions.entrySet()) {
                String header = entry.getKey().toString();
                if (SKIP_INSTRUCTIONS.contains(header)) continue;
                this.getLog().debug((CharSequence)("Adding header: " + header));
                FileUtils.fileAppend((String)fileName, (String)(header + ": " + entry.getValue() + "\n"));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error writing dependencies into SUBSYSTEM.MF", e);
        }
    }

    private String getSubsystemSymbolicName(Artifact artifact) {
        if (this.instructions.containsKey("Subsystem-SymbolicName")) {
            return this.instructions.get("Subsystem-SymbolicName").toString();
        }
        return artifact.getGroupId() + "." + artifact.getArtifactId();
    }

    private String getSubsystemVersion() {
        if (this.instructions.containsKey("Subsystem-Version")) {
            return this.instructions.get("Subsystem-Version").toString();
        }
        return Analyzer.cleanupVersion((String)this.project.getVersion());
    }

    private String getSubsystemName() {
        if (this.instructions.containsKey("Subsystem-Name")) {
            return this.instructions.get("Subsystem-Name").toString();
        }
        return this.project.getName();
    }

    private String getSubsystemDescription() {
        if (this.instructions.containsKey("Subsystem-Description")) {
            return this.instructions.get("Subsystem-Description").toString();
        }
        return this.project.getDescription();
    }

    private File getBuildDir() {
        if (this.buildDir == null) {
            this.buildDir = new File(this.workDirectory);
        }
        return this.buildDir;
    }

    private void addBuildDir() throws MojoExecutionException {
        try {
            if (this.buildDir.isDirectory()) {
                this.zipArchiver.addDirectory(this.buildDir);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error writing dependencies into SUBSYSTEM.MF", e);
        }
    }

    private void includeCustomSubsystemManifestFile() throws IOException {
        if (this.subsystemManifestFile == null) {
            throw new NullPointerException("Subsystem manifest file location not set.  Use <generateManifest>true</generateManifest> if you want it to be generated.");
        }
        File appMfFile = this.subsystemManifestFile;
        if (appMfFile.exists()) {
            this.getLog().info((CharSequence)("Using SUBSYSTEM.MF " + this.subsystemManifestFile));
            File osgiInfDir = new File(this.getBuildDir(), "OSGI-INF");
            FileUtils.copyFileToDirectory((File)appMfFile, (File)osgiInfDir);
        }
    }

    private Set<Artifact> selectArtifactsInCompileOrRuntimeScope(Set<Artifact> artifacts) {
        LinkedHashSet<Artifact> selected = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            String scope = artifact.getScope();
            if (scope != null && !"compile".equals(scope) && !"runtime".equals(scope) || artifact.getType() != null && artifact.getType().equals("pom")) continue;
            selected.add(artifact);
        }
        return selected;
    }

    private Set<Artifact> selectNonJarArtifactsAndBundles(Set<Artifact> artifacts) {
        LinkedHashSet<Artifact> selected = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (this.isNonJarOrOSGiBundle(artifact)) {
                selected.add(artifact);
                continue;
            }
            this.getLog().warn((CharSequence)("Skipping dependency on non-bundle JAR! groupId: " + artifact.getGroupId() + " artifactId:" + artifact.getArtifactId()));
        }
        return selected;
    }

    private boolean isNonJarOrOSGiBundle(Artifact artifact) {
        if (!artifact.getFile().getName().endsWith(".jar")) {
            return true;
        }
        BundleManifest manifest = BundleManifest.fromBundle((File)artifact.getFile());
        return manifest != null && manifest.getSymbolicName() != null;
    }

    private void includeSharedResources() throws MojoExecutionException {
        try {
            File sharedResourcesDir = new File(this.sharedResources);
            if (sharedResourcesDir.isDirectory()) {
                this.zipArchiver.addDirectory(sharedResourcesDir);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling esa", e);
        }
    }

    private void createEsaFile() throws MojoExecutionException {
        try {
            File esaFile = new File(this.outputDirectory, this.finalName + ".esa");
            this.zipArchiver.setDestFile(esaFile);
            this.zipArchiver.createArchive();
            this.project.getArtifact().setFile(esaFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling esa", e);
        }
    }

    public void execute() throws MojoExecutionException {
        this.init();
        this.addDependenciesToArchive();
        this.copyEsaSourceFiles();
        this.includeCustomManifest();
        this.generateSubsystemManifest();
        this.addMavenDescriptor();
        this.addBuildDir();
        this.includeSharedResources();
        this.createEsaFile();
    }

    static {
        SKIP_INSTRUCTIONS.add("Subsystem-ManifestVersion");
        SKIP_INSTRUCTIONS.add("Subsystem-SymbolicName");
        SKIP_INSTRUCTIONS.add("Subsystem-Version");
        SKIP_INSTRUCTIONS.add("Subsystem-Name");
        SKIP_INSTRUCTIONS.add("Subsystem-Description");
        SKIP_INSTRUCTIONS.add("Subsystem-Content");
    }

    public static enum EsaManifestContent {
        all,
        content;

    }

    public static enum EsaContent {
        none,
        all,
        content;

    }
}

