/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.types.xsd;

import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.ADBDataSource;
import org.apache.axis2.databinding.ADBException;
import org.apache.axis2.databinding.types.xsd.ExtensionMapper;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.ConverterUtil;

public class Name
implements ADBBean {
    protected org.apache.axis2.databinding.types.Name localName;

    private static String generatePrefix(String namespace) {
        if (namespace.equals("http://www.w3.org/2001/XMLSchema")) {
            return "xsd";
        }
        return BeanUtil.getUniquePrefix();
    }

    public org.apache.axis2.databinding.types.Name getName() {
        return this.localName;
    }

    public void setName(org.apache.axis2.databinding.types.Name param) {
        this.localName = param;
    }

    public String toString() {
        return this.localName.toString();
    }

    public static boolean isReaderMTOMAware(XMLStreamReader reader) {
        boolean isReaderMTOMAware = false;
        try {
            isReaderMTOMAware = Boolean.TRUE.equals(reader.getProperty("IsDatahandlersAwareParsing"));
        }
        catch (IllegalArgumentException e) {
            isReaderMTOMAware = false;
        }
        return isReaderMTOMAware;
    }

    public OMElement getOMElement(QName parentQName, OMFactory factory) throws ADBException {
        ADBDataSource dataSource = new ADBDataSource(this, parentQName);
        return factory.createOMElement((OMDataSource)dataSource, parentQName);
    }

    public void serialize(QName parentQName, XMLStreamWriter xmlWriter) throws XMLStreamException, ADBException {
        this.serialize(parentQName, xmlWriter, false);
    }

    public void serialize(QName parentQName, XMLStreamWriter xmlWriter, boolean serializeType) throws XMLStreamException, ADBException {
        String prefix = null;
        String namespace = null;
        prefix = parentQName.getPrefix();
        namespace = parentQName.getNamespaceURI();
        if (namespace != null && namespace.trim().length() > 0) {
            String writerPrefix = xmlWriter.getPrefix(namespace);
            if (writerPrefix != null) {
                xmlWriter.writeStartElement(namespace, parentQName.getLocalPart());
            } else {
                if (prefix == null) {
                    prefix = Name.generatePrefix(namespace);
                }
                xmlWriter.writeStartElement(prefix, parentQName.getLocalPart(), namespace);
                xmlWriter.writeNamespace(prefix, namespace);
                xmlWriter.setPrefix(prefix, namespace);
            }
        } else {
            xmlWriter.writeStartElement(parentQName.getLocalPart());
        }
        if (serializeType) {
            String namespacePrefix = this.registerPrefix(xmlWriter, "http://www.w3.org/2001/XMLSchema");
            if (namespacePrefix != null && namespacePrefix.trim().length() > 0) {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", namespacePrefix + ":Name", xmlWriter);
            } else {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "Name", xmlWriter);
            }
        }
        if (this.localName == null) {
            throw new ADBException("Name cannot be null!!");
        }
        xmlWriter.writeCharacters(ConverterUtil.convertToString(this.localName));
        xmlWriter.writeEndElement();
    }

    private void writeAttribute(String prefix, String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (xmlWriter.getPrefix(namespace) == null) {
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        xmlWriter.writeAttribute(namespace, attName, attValue);
    }

    private void writeAttribute(String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attValue);
        }
    }

    private void writeQNameAttribute(String namespace, String attName, QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String attributeNamespace = qname.getNamespaceURI();
        String attributePrefix = xmlWriter.getPrefix(attributeNamespace);
        if (attributePrefix == null) {
            attributePrefix = this.registerPrefix(xmlWriter, attributeNamespace);
        }
        String attributeValue = attributePrefix.trim().length() > 0 ? attributePrefix + ":" + qname.getLocalPart() : qname.getLocalPart();
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attributeValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attributeValue);
        }
    }

    private void writeQName(QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI != null) {
            String prefix = xmlWriter.getPrefix(namespaceURI);
            if (prefix == null) {
                prefix = Name.generatePrefix(namespaceURI);
                xmlWriter.writeNamespace(prefix, namespaceURI);
                xmlWriter.setPrefix(prefix, namespaceURI);
            }
            if (prefix.trim().length() > 0) {
                xmlWriter.writeCharacters(prefix + ":" + ConverterUtil.convertToString(qname));
            } else {
                xmlWriter.writeCharacters(ConverterUtil.convertToString(qname));
            }
        } else {
            xmlWriter.writeCharacters(ConverterUtil.convertToString(qname));
        }
    }

    private void writeQNames(QName[] qnames, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (qnames != null) {
            StringBuffer stringToWrite = new StringBuffer();
            String namespaceURI = null;
            String prefix = null;
            for (int i = 0; i < qnames.length; ++i) {
                if (i > 0) {
                    stringToWrite.append(" ");
                }
                if ((namespaceURI = qnames[i].getNamespaceURI()) != null) {
                    prefix = xmlWriter.getPrefix(namespaceURI);
                    if (prefix == null || prefix.length() == 0) {
                        prefix = Name.generatePrefix(namespaceURI);
                        xmlWriter.writeNamespace(prefix, namespaceURI);
                        xmlWriter.setPrefix(prefix, namespaceURI);
                    }
                    if (prefix.trim().length() > 0) {
                        stringToWrite.append(prefix).append(":").append(ConverterUtil.convertToString(qnames[i]));
                        continue;
                    }
                    stringToWrite.append(ConverterUtil.convertToString(qnames[i]));
                    continue;
                }
                stringToWrite.append(ConverterUtil.convertToString(qnames[i]));
            }
            xmlWriter.writeCharacters(stringToWrite.toString());
        }
    }

    private String registerPrefix(XMLStreamWriter xmlWriter, String namespace) throws XMLStreamException {
        String prefix = xmlWriter.getPrefix(namespace);
        if (prefix == null) {
            String uri;
            prefix = Name.generatePrefix(namespace);
            NamespaceContext nsContext = xmlWriter.getNamespaceContext();
            while ((uri = nsContext.getNamespaceURI(prefix)) != null && uri.length() != 0) {
                prefix = BeanUtil.getUniquePrefix();
            }
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        return prefix;
    }

    public static class Factory {
        public static Name fromString(String value, String namespaceURI) {
            Name returnValue = new Name();
            returnValue.setName(ConverterUtil.convertToName(value));
            return returnValue;
        }

        public static Name fromString(XMLStreamReader xmlStreamReader, String content) {
            if (content.indexOf(":") > -1) {
                String prefix = content.substring(0, content.indexOf(":"));
                String namespaceUri = xmlStreamReader.getNamespaceContext().getNamespaceURI(prefix);
                return Factory.fromString(content, namespaceUri);
            }
            return Factory.fromString(content, "");
        }

        public static Name parse(XMLStreamReader reader) throws Exception {
            Name object = new Name();
            Object nillableValue = null;
            String prefix = "";
            String namespaceuri = "";
            try {
                String fullTypeName;
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type") != null && (fullTypeName = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) != null) {
                    String nsPrefix = null;
                    if (fullTypeName.indexOf(":") > -1) {
                        nsPrefix = fullTypeName.substring(0, fullTypeName.indexOf(":"));
                    }
                    nsPrefix = nsPrefix == null ? "" : nsPrefix;
                    String type = fullTypeName.substring(fullTypeName.indexOf(":") + 1);
                    if (!"Name".equals(type)) {
                        String nsUri = reader.getNamespaceContext().getNamespaceURI(nsPrefix);
                        return (Name)ExtensionMapper.getTypeObject(nsUri, type, reader);
                    }
                }
                Vector handledAttributes = new Vector();
                while (!reader.isEndElement()) {
                    if (reader.isStartElement() || reader.hasText()) {
                        if (reader.isStartElement() || reader.hasText()) {
                            String content = reader.getElementText();
                            object.setName(ConverterUtil.convertToName(content));
                            continue;
                        }
                        throw new ADBException("Unexpected subelement " + reader.getLocalName());
                    }
                    reader.next();
                }
            }
            catch (XMLStreamException e) {
                throw new Exception(e);
            }
            return object;
        }
    }
}

