/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.context.listener;

import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.MessageContextListener;
import org.apache.axis2.jaxws.context.listener.ParserInputStreamCustomBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProviderOMContextListener
implements MessageContextListener {
    private static final Log log = LogFactory.getLog(ProviderOMContextListener.class);

    public static void create(ServiceContext sc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start ProviderOMContextListener.create(ServiceContext)");
        }
        if (sc == null || sc.getAxisService() == null || sc.getAxisService().hasMessageContextListener(ProviderOMContextListener.class)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ProviderOMContextListener already installed on AxisService");
            }
            return;
        }
        ProviderOMContextListener listener = new ProviderOMContextListener();
        sc.getAxisService().addMessageContextListener((MessageContextListener)listener);
        if (log.isDebugEnabled()) {
            log.debug((Object)"End ProviderOMContextListener.create(ServiceContext)");
        }
    }

    private void installParserInputStreamCustomBuilder(ServiceContext sc, MessageContext mc) {
        SOAPEnvelope envelope;
        if (log.isDebugEnabled()) {
            log.debug((Object)("attachEvent for sc= " + sc.getName() + "and  mc=" + mc.getLogCorrelationID()));
        }
        if ((envelope = mc.getEnvelope()) == null) {
            return;
        }
        if (!(envelope.getBuilder() instanceof StAXOMBuilder)) {
            return;
        }
        AxisOperation axisOp = mc.getAxisOperation();
        if (axisOp == null) {
            return;
        }
        ParserInputStreamCustomBuilder pacb = new ParserInputStreamCustomBuilder(null);
        ((StAXOMBuilder)envelope.getBuilder()).registerCustomBuilderForPayload((CustomBuilder)pacb);
    }

    public void attachEnvelopeEvent(MessageContext mc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start attachEnvelopeEvent");
        }
        if (mc.getServiceContext() != null) {
            this.installParserInputStreamCustomBuilder(mc.getServiceContext(), mc);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Installed ParserInputStreamCustomBuilder");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stop attachEnvelopeEvent");
        }
    }

    public void attachServiceContextEvent(ServiceContext sc, MessageContext mc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start attachServiceContextEvent");
        }
        if (mc.getEnvelope() != null) {
            this.installParserInputStreamCustomBuilder(sc, mc);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Installed ParserInputStreamCustomBuilder");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stop attachServiceContextEvent");
        }
    }
}

