/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dataretrieval;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.dataretrieval.DataRetrievalException;
import org.apache.axis2.dataretrieval.DataRetrievalUtil;

public class ServiceData {
    OMElement data;
    String identifier;
    String dialect;
    String fileName;

    public ServiceData(OMElement in_data) {
        this.data = in_data;
        this.identifier = this.getAttributeValue("identifier");
        this.dialect = this.getAttributeValue("dialect");
        this.fileName = this.getAttributeValue("file");
    }

    public String getAttributeValue(String qName) {
        String value = null;
        OMAttribute attribute = this.data.getAttribute(new QName(qName));
        if (attribute != null) {
            value = attribute.getAttributeValue();
        }
        return value;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDialect() {
        return this.dialect;
    }

    public OMElement getOMData() {
        return this.data;
    }

    public String getURL() {
        String urlValue = null;
        OMElement url = this.data.getFirstChildWithName(new QName("URL"));
        if (url != null) {
            urlValue = url.getText();
        }
        return urlValue;
    }

    public OMElement getEndpointReference() {
        OMElement epr = this.data.getFirstChildWithName(new QName("EndpointReference"));
        return epr;
    }

    public OMElement getFileContent(ClassLoader classloader) throws DataRetrievalException {
        OMElement metaElement = null;
        if (this.fileName != null) {
            DataRetrievalUtil util = DataRetrievalUtil.getInstance();
            metaElement = util.buildOM(classloader, this.fileName);
        }
        return metaElement;
    }
}

