/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyRegistry;

public class AxisPolicyLocator
implements PolicyRegistry {
    AxisDescription subject = null;
    private static final short AXIS_BINDING_MESSAGE = 1;
    private static final short AXIS_MESSAGE = 2;
    private static final short AXIS_BINDING_OPERATION = 3;
    private static final short AXIS_OPERATION = 4;
    private static final short AXIS_BINDING = 5;
    private static final short AXIS_ENDPOINT = 6;
    private static final short AXIS_SERVICE = 7;
    private static final short AXIS_SERVICE_GROUP = 8;
    private static final short AXIS_CONFIGURATION = 9;

    public AxisPolicyLocator(AxisDescription subject) {
        this.subject = subject;
    }

    public Policy lookup(String key) {
        if (this.subject == null) {
            return null;
        }
        Policy policy = null;
        PolicySubject policySubject = this.subject.getPolicySubject();
        PolicyComponent attachedPolicyComponent = policySubject.getAttachedPolicyComponent(key);
        if (attachedPolicyComponent != null && attachedPolicyComponent instanceof Policy && (policy = (Policy)attachedPolicyComponent) != null) {
            return policy;
        }
        if (this.subject instanceof AxisService && (policy = ((AxisService)this.subject).lookupPolicy(key)) != null) {
            return policy;
        }
        short type = this.getType(this.subject);
        AxisDescription parallelLevel = null;
        switch (type) {
            case 1: {
                parallelLevel = ((AxisBindingMessage)this.subject).getAxisMessage();
                break;
            }
            case 3: {
                parallelLevel = ((AxisBindingOperation)this.subject).getAxisOperation();
                break;
            }
        }
        if (parallelLevel != null && (policy = new AxisPolicyLocator(parallelLevel).lookup(key)) != null) {
            return policy;
        }
        AxisDescription upperLevel = this.getUpperLevel(type, this.subject);
        if (upperLevel != null) {
            policy = new AxisPolicyLocator(upperLevel).lookup(key);
            return policy;
        }
        return null;
    }

    public void register(String key, Policy policy) {
        throw new UnsupportedOperationException();
    }

    public void remove(String key) {
        throw new UnsupportedOperationException();
    }

    private AxisDescription getUpperLevel(short type, AxisDescription thisLevel) {
        switch (type) {
            case 1: {
                return ((AxisBindingMessage)thisLevel).getAxisBindingOperation();
            }
            case 3: {
                return ((AxisBindingOperation)thisLevel).getAxisBinding();
            }
            case 5: {
                return ((AxisBinding)thisLevel).getAxisEndpoint();
            }
            case 6: {
                return ((AxisEndpoint)thisLevel).getAxisService();
            }
            case 2: {
                return ((AxisMessage)thisLevel).getAxisOperation();
            }
            case 4: {
                return ((AxisOperation)thisLevel).getAxisService();
            }
            case 7: {
                return ((AxisService)thisLevel).getAxisServiceGroup();
            }
            case 8: {
                return ((AxisServiceGroup)thisLevel).getAxisConfiguration();
            }
        }
        return null;
    }

    private short getType(AxisDescription description) {
        if (description instanceof AxisBindingMessage) {
            return 1;
        }
        if (description instanceof AxisMessage) {
            return 2;
        }
        if (description instanceof AxisBindingOperation) {
            return 3;
        }
        if (description instanceof AxisOperation) {
            return 4;
        }
        if (description instanceof AxisBinding) {
            return 5;
        }
        if (description instanceof AxisEndpoint) {
            return 6;
        }
        if (description instanceof AxisService) {
            return 7;
        }
        if (description instanceof AxisServiceGroup) {
            return 8;
        }
        if (description instanceof AxisConfiguration) {
            return 9;
        }
        return -1;
    }
}

