/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SelfManagedDataHolder
implements Externalizable {
    private transient String classname;
    private transient String id;
    private transient byte[] data;

    public SelfManagedDataHolder() {
    }

    public SelfManagedDataHolder(String classname, String id, byte[] data) throws Exception {
        if (classname == null || id == null) {
            throw new Exception("Argument cannot be null: classname = " + classname + ", id = " + id);
        }
        this.classname = classname;
        this.id = id;
        this.data = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            this.data[i] = data[i];
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.classname = in.readUTF();
        this.id = in.readUTF();
        int datalength = in.readInt();
        this.data = new byte[datalength];
        in.read(this.data);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.classname);
        out.writeUTF(this.id);
        out.writeInt(this.data.length);
        out.write(this.data);
    }

    public String getClassname() {
        return this.classname;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getId() {
        return this.id;
    }
}

