/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.OMMultipartWriter;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPMessageFormatter
implements MessageFormatter {
    private static final Log log = LogFactory.getLog(SOAPMessageFormatter.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTo(MessageContext msgCtxt, OMOutputFormat format, OutputStream out, boolean preserve) throws AxisFault {
        int optimizedThreshold;
        if (log.isDebugEnabled()) {
            log.debug((Object)"start writeTo()");
            log.debug((Object)("  preserve=" + preserve));
            log.debug((Object)("  isOptimized=" + format.isOptimized()));
            log.debug((Object)("  isDoingSWA=" + format.isDoingSWA()));
        }
        if (msgCtxt.isDoingMTOM() && (optimizedThreshold = Utils.getMtomThreshold((MessageContext)msgCtxt)) > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting MTOM optimized Threshold Value on OMOutputFormat");
            }
            format.setOptimizedThreshold(optimizedThreshold);
        }
        try {
            try {
                if (!format.isOptimized() && format.isDoingSWA()) {
                    this.writeSwAMessage(msgCtxt, out, format, preserve);
                }
                SOAPEnvelope element = msgCtxt.getEnvelope();
                if (preserve) {
                    element.serialize(out, format);
                }
                element.serializeAndConsume(out, format);
            }
            catch (XMLStreamException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!log.isDebugEnabled()) throw throwable;
            log.debug((Object)"end writeTo()");
            throw throwable;
        }
        if (!log.isDebugEnabled()) return;
        log.debug((Object)"end writeTo()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes(MessageContext msgCtxt, OMOutputFormat format) throws AxisFault {
        byte[] byArray;
        block11: {
            byte[] byArray2;
            block10: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"start getBytes()");
                    log.debug((Object)("  isOptimized=" + format.isOptimized()));
                    log.debug((Object)("  isDoingSWA=" + format.isDoingSWA()));
                }
                SOAPEnvelope element = msgCtxt.getEnvelope();
                try {
                    try {
                        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                        if (!format.isOptimized()) {
                            if (format.isDoingSWA()) {
                                this.writeSwAMessage(msgCtxt, bytesOut, format, false);
                            } else {
                                element.serializeAndConsume((OutputStream)bytesOut, format);
                            }
                            byArray2 = bytesOut.toByteArray();
                            Object var7_9 = null;
                            break block10;
                        }
                        element.serializeAndConsume((OutputStream)bytesOut, format);
                        byArray = bytesOut.toByteArray();
                        break block11;
                    }
                    catch (XMLStreamException e) {
                        throw AxisFault.makeFault((Throwable)e);
                    }
                    catch (FactoryConfigurationError e) {
                        throw AxisFault.makeFault((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    if (!log.isDebugEnabled()) throw throwable;
                    log.debug((Object)"end getBytes()");
                    throw throwable;
                }
            }
            if (!log.isDebugEnabled()) return byArray2;
            log.debug((Object)"end getBytes()");
            return byArray2;
        }
        Object var7_10 = null;
        if (!log.isDebugEnabled()) return byArray;
        log.debug((Object)"end getBytes()");
        return byArray;
    }

    public String getContentType(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        String encoding = format.getCharSetEncoding();
        String contentType = format.getContentType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("contentType from the OMOutputFormat =" + contentType));
        }
        if (encoding != null && contentType != null && contentType.indexOf("multipart/related") == -1) {
            contentType = contentType + "; charset=" + encoding;
        }
        if (!(msgCtxt.isSOAP11() || soapActionString == null || "".equals(soapActionString.trim()) || "\"\"".equals(soapActionString.trim()))) {
            contentType = contentType + "; action=\"" + soapActionString + "\"";
        }
        if ((contentType = contentType.trim()).lastIndexOf(";") == contentType.length() - 1) {
            contentType = contentType.substring(0, contentType.length() - 1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("contentType returned =" + contentType));
        }
        return contentType;
    }

    public String formatSOAPAction(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        if (msgCtxt.isSOAP11()) {
            if ("".equals(soapActionString)) {
                return "\"\"";
            }
            if (soapActionString != null && !soapActionString.startsWith("\"")) {
                soapActionString = "\"" + soapActionString + "\"";
            }
            return soapActionString;
        }
        return null;
    }

    public URL getTargetAddress(MessageContext msgCtxt, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL(targetURL, msgCtxt, false);
        return targetURL;
    }

    private void writeSwAMessage(MessageContext msgCtxt, OutputStream outputStream, OMOutputFormat format, boolean preserve) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start writeSwAMessage()");
        }
        Object property = msgCtxt.getProperty("MM7Compatible");
        boolean MM7CompatMode = false;
        if (property != null) {
            MM7CompatMode = JavaUtils.isTrueExplicitly((Object)property);
        }
        try {
            OutputStream innerOutputStream;
            OMMultipartWriter attachmentsWriter;
            OMMultipartWriter mpw = new OMMultipartWriter(outputStream, format);
            OutputStream rootPartOutputStream = mpw.writeRootPart();
            SOAPEnvelope element = msgCtxt.getEnvelope();
            if (preserve) {
                element.serialize(rootPartOutputStream, format);
            } else {
                element.serializeAndConsume(rootPartOutputStream, format);
            }
            rootPartOutputStream.close();
            if (!MM7CompatMode) {
                attachmentsWriter = mpw;
                innerOutputStream = null;
            } else {
                Object innerBoundaryProperty = msgCtxt.getProperty("MM7InnerBoundary");
                String innerBoundary = innerBoundaryProperty != null ? (String)innerBoundaryProperty : "innerBoundary" + UIDGenerator.generateMimeBoundary();
                Object partCIDProperty = msgCtxt.getProperty("MM7PartCID");
                String partCID = partCIDProperty != null ? (String)partCIDProperty : "innerCID" + UIDGenerator.generateContentId();
                OMOutputFormat innerFormat = new OMOutputFormat(format);
                innerFormat.setMimeBoundary(innerBoundary);
                innerOutputStream = mpw.writePart("multipart/related; boundary=\"" + innerBoundary + "\"", partCID);
                attachmentsWriter = new OMMultipartWriter(innerOutputStream, innerFormat);
            }
            Attachments attachments = msgCtxt.getAttachmentMap();
            for (String contentID : attachments.getAllContentIDs()) {
                attachmentsWriter.writePart(attachments.getDataHandler(contentID), contentID);
            }
            if (MM7CompatMode) {
                attachmentsWriter.complete();
                innerOutputStream.close();
            }
            mpw.complete();
        }
        catch (IOException ex) {
            throw AxisFault.makeFault((Throwable)ex);
        }
        catch (XMLStreamException ex) {
            throw AxisFault.makeFault((Throwable)ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end writeSwAMessage()");
        }
    }
}

