/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptListener;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

class RelSet {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    final List<RelNode> rels = new ArrayList<RelNode>();
    final List<RelNode> parents = new ArrayList<RelNode>();
    final List<RelSubset> subsets = new ArrayList<RelSubset>();
    final List<AbstractConverter> abstractConverters = new ArrayList<AbstractConverter>();
    RelSet equivalentSet;
    RelNode rel;
    final Set<CorrelationId> variablesPropagated;
    final Set<CorrelationId> variablesUsed;
    final int id;
    boolean inMetadataQuery;

    RelSet(int id, Set<CorrelationId> variablesPropagated, Set<CorrelationId> variablesUsed) {
        this.id = id;
        this.variablesPropagated = variablesPropagated;
        this.variablesUsed = variablesUsed;
    }

    public List<RelNode> getParentRels() {
        return this.parents;
    }

    public List<RelNode> getRelsFromAllSubsets() {
        return this.rels;
    }

    public RelSubset getSubset(RelTraitSet traits) {
        for (RelSubset subset : this.subsets) {
            if (!subset.getTraitSet().equals(traits)) continue;
            return subset;
        }
        return null;
    }

    void obliterateRelNode(RelNode rel) {
        this.parents.remove(rel);
    }

    public RelSubset add(RelNode rel) {
        assert (this.equivalentSet == null) : "adding to a dead set";
        RelTraitSet traitSet = rel.getTraitSet().simplify();
        RelSubset subset = this.getOrCreateSubset(rel.getCluster(), traitSet);
        subset.add(rel);
        return subset;
    }

    RelSubset getOrCreateSubset(RelOptCluster cluster, RelTraitSet traits) {
        RelSubset subset = this.getSubset(traits);
        if (subset == null) {
            subset = new RelSubset(cluster, this, traits);
            VolcanoPlanner planner = (VolcanoPlanner)cluster.getPlanner();
            this.subsets.add(subset);
            if (planner.root != null && planner.root.set == this) {
                planner.ensureRootConverters();
            }
            if (planner.listener != null) {
                this.postEquivalenceEvent(planner, subset);
            }
        }
        return subset;
    }

    private void postEquivalenceEvent(VolcanoPlanner planner, RelNode rel) {
        RelOptListener.RelEquivalenceEvent event = new RelOptListener.RelEquivalenceEvent(planner, rel, "equivalence class " + this.id, false);
        planner.listener.relEquivalenceFound(event);
    }

    void addInternal(RelNode rel) {
        if (!this.rels.contains(rel)) {
            this.rels.add(rel);
            for (RelTrait trait : rel.getTraitSet()) {
                assert (trait == trait.getTraitDef().canonize(trait));
            }
            VolcanoPlanner planner = (VolcanoPlanner)rel.getCluster().getPlanner();
            if (planner.listener != null) {
                this.postEquivalenceEvent(planner, rel);
            }
        }
        if (this.rel == null) {
            this.rel = rel;
        } else {
            RelOptUtil.verifyTypeEquivalence(this.rel, rel, this);
        }
    }

    void mergeWith(VolcanoPlanner planner, RelSet otherSet) {
        assert (this != otherSet);
        assert (this.equivalentSet == null);
        assert (otherSet.equivalentSet == null);
        LOGGER.trace("Merge set#{} into set#{}", (Object)otherSet.id, (Object)this.id);
        otherSet.equivalentSet = this;
        boolean existed = planner.allSets.remove(otherSet);
        assert (existed) : "merging with a dead otherSet";
        for (RelSubset relSubset : otherSet.subsets) {
            planner.ruleQueue.subsetImportances.remove(relSubset);
            RelSubset subset = this.getOrCreateSubset(relSubset.getCluster(), relSubset.getTraitSet());
            if (relSubset.bestCost.isLt(subset.bestCost)) {
                subset.bestCost = relSubset.bestCost;
                subset.best = relSubset.best;
            }
            for (RelNode otherRel : relSubset.getRels()) {
                planner.reregister(this, otherRel);
            }
        }
        assert (this.equivalentSet == null);
        ImmutableList previousParents = ImmutableList.copyOf(otherSet.getParentRels());
        for (RelNode parentRel : previousParents) {
            planner.rename(parentRel);
        }
        if (this.equivalentSet != null) {
            return;
        }
        HashSet<RelSubset> hashSet = new HashSet<RelSubset>();
        RelMetadataQuery mq = RelMetadataQuery.instance();
        for (RelNode parentRel : this.getParentRels()) {
            RelSubset parentSubset = planner.getSubset(parentRel);
            parentSubset.propagateCostImprovements(planner, mq, parentRel, hashSet);
        }
        assert (hashSet.isEmpty());
        assert (this.equivalentSet == null);
        for (RelNode rel : this.rels) {
            assert (planner.getSet(rel) == this);
            planner.fireRules(rel, true);
        }
    }
}

