/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.CalciteSqlValidator;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class PlannerImpl
implements Planner {
    private final SqlOperatorTable operatorTable;
    private final ImmutableList<Program> programs;
    private final FrameworkConfig config;
    private final ImmutableList<RelTraitDef> traitDefs;
    private final SqlParser.Config parserConfig;
    private final SqlRexConvertletTable convertletTable;
    private State state;
    private boolean open;
    private SchemaPlus defaultSchema;
    private JavaTypeFactory typeFactory;
    private RelOptPlanner planner;
    private RelOptPlanner.Executor executor;
    private CalciteSqlValidator validator;
    private SqlNode validatedSqlNode;
    private RelRoot root;

    public PlannerImpl(FrameworkConfig config) {
        this.config = config;
        this.defaultSchema = config.getDefaultSchema();
        this.operatorTable = config.getOperatorTable();
        this.programs = config.getPrograms();
        this.parserConfig = config.getParserConfig();
        this.state = State.STATE_0_CLOSED;
        this.traitDefs = config.getTraitDefs();
        this.convertletTable = config.getConvertletTable();
        this.executor = config.getExecutor();
        this.reset();
    }

    private void ensure(State state) {
        if (state == this.state) {
            return;
        }
        if (state.ordinal() < this.state.ordinal()) {
            throw new IllegalArgumentException("cannot move to " + (Object)((Object)state) + " from " + (Object)((Object)this.state));
        }
        state.from(this);
    }

    @Override
    public RelTraitSet getEmptyTraitSet() {
        return this.planner.emptyTraitSet();
    }

    @Override
    public void close() {
        this.open = false;
        this.typeFactory = null;
        this.state = State.STATE_0_CLOSED;
    }

    @Override
    public void reset() {
        this.ensure(State.STATE_0_CLOSED);
        this.open = true;
        this.state = State.STATE_1_RESET;
    }

    private void ready() {
        switch (this.state) {
            case STATE_0_CLOSED: {
                this.reset();
            }
        }
        this.ensure(State.STATE_1_RESET);
        Frameworks.withPlanner(new Frameworks.PlannerAction<Void>(){

            @Override
            public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
                Util.discard(rootSchema);
                PlannerImpl.this.typeFactory = (JavaTypeFactory)cluster.getTypeFactory();
                PlannerImpl.this.planner = cluster.getPlanner();
                PlannerImpl.this.planner.setExecutor(PlannerImpl.this.executor);
                return null;
            }
        }, this.config);
        this.state = State.STATE_2_READY;
        if (this.traitDefs != null) {
            this.planner.clearRelTraitDefs();
            for (RelTraitDef def : this.traitDefs) {
                this.planner.addRelTraitDef(def);
            }
        }
    }

    @Override
    public SqlNode parse(String sql) throws SqlParseException {
        switch (this.state) {
            case STATE_0_CLOSED: 
            case STATE_1_RESET: {
                this.ready();
            }
        }
        this.ensure(State.STATE_2_READY);
        SqlParser parser = SqlParser.create(sql, this.parserConfig);
        SqlNode sqlNode = parser.parseStmt();
        this.state = State.STATE_3_PARSED;
        return sqlNode;
    }

    @Override
    public SqlNode validate(SqlNode sqlNode) throws ValidationException {
        this.ensure(State.STATE_3_PARSED);
        SqlConformance conformance = this.conformance();
        CalciteCatalogReader catalogReader = this.createCatalogReader();
        this.validator = new CalciteSqlValidator(this.operatorTable, catalogReader, this.typeFactory, conformance);
        this.validator.setIdentifierExpansion(true);
        try {
            this.validatedSqlNode = this.validator.validate(sqlNode);
        }
        catch (RuntimeException e) {
            throw new ValidationException(e);
        }
        this.state = State.STATE_4_VALIDATED;
        return this.validatedSqlNode;
    }

    private SqlConformance conformance() {
        CalciteConnectionConfig connectionConfig;
        Context context = this.config.getContext();
        if (context != null && (connectionConfig = context.unwrap(CalciteConnectionConfig.class)) != null) {
            return connectionConfig.conformance();
        }
        return SqlConformance.DEFAULT;
    }

    @Override
    public Pair<SqlNode, RelDataType> validateAndGetType(SqlNode sqlNode) throws ValidationException {
        SqlNode validatedNode = this.validate(sqlNode);
        RelDataType type = this.validator.getValidatedNodeType(validatedNode);
        return Pair.of(validatedNode, type);
    }

    @Override
    public final RelNode convert(SqlNode sql) throws RelConversionException {
        return this.rel((SqlNode)sql).rel;
    }

    @Override
    public RelRoot rel(SqlNode sql) throws RelConversionException {
        this.ensure(State.STATE_4_VALIDATED);
        assert (this.validatedSqlNode != null);
        RexBuilder rexBuilder = this.createRexBuilder();
        RelOptCluster cluster = RelOptCluster.create(this.planner, rexBuilder);
        SqlToRelConverter sqlToRelConverter = new SqlToRelConverter(new ViewExpanderImpl(), this.validator, this.createCatalogReader(), cluster, this.convertletTable);
        sqlToRelConverter.setTrimUnusedFields(false);
        sqlToRelConverter.enableTableAccessConversion(false);
        this.root = sqlToRelConverter.convertQuery(this.validatedSqlNode, false, true);
        this.root = this.root.withRel(sqlToRelConverter.flattenTypes(this.root.rel, true));
        this.root = this.root.withRel(RelDecorrelator.decorrelateQuery(this.root.rel));
        this.state = State.STATE_5_CONVERTED;
        return this.root;
    }

    private CalciteCatalogReader createCatalogReader() {
        SchemaPlus rootSchema = PlannerImpl.rootSchema(this.defaultSchema);
        return new CalciteCatalogReader(CalciteSchema.from(rootSchema), this.parserConfig.caseSensitive(), CalciteSchema.from(this.defaultSchema).path(null), this.typeFactory);
    }

    private static SchemaPlus rootSchema(SchemaPlus schema) {
        while (schema.getParentSchema() != null) {
            schema = schema.getParentSchema();
        }
        return schema;
    }

    private RexBuilder createRexBuilder() {
        return new RexBuilder(this.typeFactory);
    }

    @Override
    public JavaTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public RelNode transform(int ruleSetIndex, RelTraitSet requiredOutputTraits, RelNode rel) throws RelConversionException {
        this.ensure(State.STATE_5_CONVERTED);
        rel.getCluster().setMetadataProvider(new CachingRelMetadataProvider(rel.getCluster().getMetadataProvider(), rel.getCluster().getPlanner()));
        Program program = (Program)this.programs.get(ruleSetIndex);
        return program.run(this.planner, rel, requiredOutputTraits);
    }

    private static enum State {
        STATE_0_CLOSED{

            @Override
            void from(PlannerImpl planner) {
                planner.close();
            }
        }
        ,
        STATE_1_RESET{

            @Override
            void from(PlannerImpl planner) {
                planner.ensure(2.STATE_0_CLOSED);
                planner.reset();
            }
        }
        ,
        STATE_2_READY{

            @Override
            void from(PlannerImpl planner) {
                STATE_1_RESET.from(planner);
                planner.ready();
            }
        }
        ,
        STATE_3_PARSED,
        STATE_4_VALIDATED,
        STATE_5_CONVERTED;


        void from(PlannerImpl planner) {
            throw new IllegalArgumentException("cannot move from " + (Object)((Object)planner.state) + " to " + (Object)((Object)this));
        }
    }

    public class ViewExpanderImpl
    implements RelOptTable.ViewExpander {
        @Override
        public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath) {
            SqlNode sqlNode;
            SqlParser parser = SqlParser.create(queryString, PlannerImpl.this.parserConfig);
            try {
                sqlNode = parser.parseQuery();
            }
            catch (SqlParseException e) {
                throw new RuntimeException("parse failed", e);
            }
            SqlConformance conformance = PlannerImpl.this.conformance();
            Prepare.CatalogReader catalogReader = PlannerImpl.this.createCatalogReader().withSchemaPath((List)schemaPath);
            CalciteSqlValidator validator = new CalciteSqlValidator(PlannerImpl.this.operatorTable, (CalciteCatalogReader)catalogReader, PlannerImpl.this.typeFactory, conformance);
            validator.setIdentifierExpansion(true);
            SqlNode validatedSqlNode = validator.validate(sqlNode);
            RexBuilder rexBuilder = PlannerImpl.this.createRexBuilder();
            RelOptCluster cluster = RelOptCluster.create(PlannerImpl.this.planner, rexBuilder);
            SqlToRelConverter sqlToRelConverter = new SqlToRelConverter(new ViewExpanderImpl(), validator, catalogReader, cluster, PlannerImpl.this.convertletTable);
            sqlToRelConverter.setTrimUnusedFields(false);
            sqlToRelConverter.enableTableAccessConversion(false);
            PlannerImpl.this.root = sqlToRelConverter.convertQuery(validatedSqlNode, true, false);
            PlannerImpl.this.root = PlannerImpl.this.root.withRel(sqlToRelConverter.flattenTypes(((PlannerImpl)PlannerImpl.this).root.rel, true));
            PlannerImpl.this.root = PlannerImpl.this.root.withRel(RelDecorrelator.decorrelateQuery(((PlannerImpl)PlannerImpl.this).root.rel));
            return PlannerImpl.this.root;
        }
    }
}

