/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.type;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.type.DynamicRecordType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeHolder;
import org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import org.apache.calcite.sql.type.SqlTypeExplicitPrecedenceList;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;

public class DynamicRecordTypeImpl
extends DynamicRecordType {
    private final RelDataTypeFactory typeFactory;
    private final RelDataTypeHolder holder;

    public DynamicRecordTypeImpl(RelDataTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
        this.holder = new RelDataTypeHolder();
        this.holder.setRelDataTypeFactory(typeFactory);
        this.computeDigest();
    }

    @Override
    public List<RelDataTypeField> getFieldList() {
        return this.holder.getFieldList(this.typeFactory);
    }

    @Override
    public int getFieldCount() {
        return this.holder.getFieldCount();
    }

    @Override
    public RelDataTypeField getField(String fieldName, boolean caseSensitive, boolean elideRecord) {
        Pair<RelDataTypeField, Boolean> pair = this.holder.getFieldOrInsert(this.typeFactory, fieldName, caseSensitive);
        if (((Boolean)pair.right).booleanValue()) {
            this.computeDigest();
        }
        return (RelDataTypeField)pair.left;
    }

    @Override
    public List<String> getFieldNames() {
        return this.holder.getFieldNames();
    }

    @Override
    public SqlTypeName getSqlTypeName() {
        return SqlTypeName.ROW;
    }

    @Override
    public RelDataTypePrecedenceList getPrecedenceList() {
        return new SqlTypeExplicitPrecedenceList(Collections.emptyList());
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("(DynamicRecordRow" + this.getFieldNames() + ")");
    }

    @Override
    public boolean isStruct() {
        return true;
    }

    @Override
    public RelDataTypeFamily getFamily() {
        return this.getSqlTypeName().getFamily();
    }
}

