/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.util.Litmus;

public class RexCall
extends RexNode {
    public final SqlOperator op;
    public final ImmutableList<RexNode> operands;
    public final RelDataType type;

    protected RexCall(RelDataType type, SqlOperator op, List<? extends RexNode> operands) {
        assert (type != null) : "precondition: type != null";
        assert (op != null) : "precondition: op != null";
        assert (operands != null) : "precondition: operands != null";
        this.type = type;
        this.op = op;
        this.operands = ImmutableList.copyOf(operands);
        assert (op.getKind() != null) : op;
        this.digest = this.computeDigest(true);
        assert (op.validRexOperands(operands.size(), Litmus.THROW)) : this;
    }

    protected String computeDigest(boolean withType) {
        StringBuilder sb = new StringBuilder(this.op.getName());
        if (this.operands.size() != 0 || this.op.getSyntax() != SqlSyntax.FUNCTION_ID) {
            sb.append("(");
            for (int i = 0; i < this.operands.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                RexNode operand = (RexNode)this.operands.get(i);
                sb.append(operand.toString());
            }
            sb.append(")");
        }
        if (withType) {
            sb.append(":");
            sb.append(this.type.getFullTypeString());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.computeDigest(this.isA(SqlKind.CAST) || this.isA(SqlKind.NEW_SPECIFICATION));
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitCall(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitCall(this, arg);
    }

    @Override
    public RelDataType getType() {
        return this.type;
    }

    @Override
    public boolean isAlwaysTrue() {
        switch (this.getKind()) {
            case IS_NOT_NULL: {
                return !((RexNode)this.operands.get(0)).getType().isNullable();
            }
            case IS_NOT_FALSE: 
            case NOT: {
                return ((RexNode)this.operands.get(0)).isAlwaysFalse();
            }
            case IS_NOT_TRUE: 
            case IS_FALSE: 
            case CAST: {
                return ((RexNode)this.operands.get(0)).isAlwaysTrue();
            }
        }
        return false;
    }

    @Override
    public boolean isAlwaysFalse() {
        switch (this.getKind()) {
            case IS_NULL: {
                return !((RexNode)this.operands.get(0)).getType().isNullable();
            }
            case NOT: 
            case IS_NOT_TRUE: {
                return ((RexNode)this.operands.get(0)).isAlwaysTrue();
            }
            case IS_NOT_FALSE: 
            case CAST: 
            case IS_TRUE: {
                return ((RexNode)this.operands.get(0)).isAlwaysFalse();
            }
        }
        return false;
    }

    @Override
    public SqlKind getKind() {
        return this.op.kind;
    }

    public List<RexNode> getOperands() {
        return this.operands;
    }

    public SqlOperator getOperator() {
        return this.op;
    }

    public RexCall clone(RelDataType type, List<RexNode> operands) {
        return new RexCall(type, this.op, operands);
    }
}

