/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.tools.apt.AbstractAnnotationProcessor;
import org.apache.camel.tools.apt.CollectionStringBuffer;
import org.apache.camel.tools.apt.Func1;
import org.apache.camel.tools.apt.JsonSchemaHelper;
import org.apache.camel.tools.apt.Strings;

@SupportedAnnotationTypes(value={"org.apache.camel.spi.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class EndpointAnnotationProcessor
extends AbstractAnnotationProcessor {
    private static final String HEADER_FILTER_STRATEGY_JAVADOC = "To use a custom HeaderFilterStrategy to filter header to and from Camel message.";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(UriEndpoint.class);
        for (Element element : elements) {
            if (!(element instanceof TypeElement)) continue;
            this.processEndpointClass(roundEnv, (TypeElement)element);
        }
        return true;
    }

    protected void processEndpointClass(final RoundEnvironment roundEnv, final TypeElement classElement) {
        final UriEndpoint uriEndpoint = classElement.getAnnotation(UriEndpoint.class);
        if (uriEndpoint != null) {
            String scheme = uriEndpoint.scheme();
            String title = uriEndpoint.title();
            final String label = uriEndpoint.label();
            if (!Strings.isNullOrEmpty(scheme)) {
                String[] schemes = scheme.split(",");
                String[] titles = title.split(",");
                for (int i = 0; i < schemes.length; ++i) {
                    final String alias = schemes[i];
                    final String aliasTitle = i < titles.length ? titles[i] : titles[0];
                    String name = Strings.canonicalClassName(classElement.getQualifiedName().toString());
                    String packageName = name.substring(0, name.lastIndexOf("."));
                    String fileName = alias + ".html";
                    Func1<PrintWriter, Void> handler = new Func1<PrintWriter, Void>(){

                        @Override
                        public Void call(PrintWriter writer) {
                            EndpointAnnotationProcessor.this.writeHtmlDocumentation(writer, roundEnv, classElement, uriEndpoint, aliasTitle, alias, label);
                            return null;
                        }
                    };
                    this.processFile(packageName, fileName, handler);
                    fileName = alias + ".json";
                    handler = new Func1<PrintWriter, Void>(){

                        @Override
                        public Void call(PrintWriter writer) {
                            EndpointAnnotationProcessor.this.writeJSonSchemeDocumentation(writer, roundEnv, classElement, uriEndpoint, aliasTitle, alias, label);
                            return null;
                        }
                    };
                    this.processFile(packageName, fileName, handler);
                }
            }
        }
    }

    protected void writeHtmlDocumentation(PrintWriter writer, RoundEnvironment roundEnv, TypeElement classElement, UriEndpoint uriEndpoint, String title, String scheme, String label) {
        TypeElement consumerElement;
        writer.println("<html>");
        writer.println("<header>");
        writer.println("<title>" + title + "</title>");
        writer.println("</header>");
        writer.println("<body>");
        writer.println("<h1>" + title + "</h1>");
        writer.println("<b>Scheme: " + scheme + "</b>");
        if (label != null) {
            String[] labels = label.split(",");
            writer.println("<ul>");
            for (String text : labels) {
                writer.println("<li>" + text + "</li>");
            }
            writer.println("</ul>");
        }
        this.showDocumentationAndFieldInjections(writer, roundEnv, classElement, "");
        TypeMirror consumerType = null;
        try {
            uriEndpoint.consumerClass();
        }
        catch (MirroredTypeException mte) {
            consumerType = mte.getTypeMirror();
        }
        boolean found = false;
        String consumerClassName = null;
        String consumerPrefix = Strings.getOrElse(uriEndpoint.consumerPrefix(), "");
        if (consumerType != null && (consumerElement = this.findTypeElement(roundEnv, consumerClassName = consumerType.toString())) != null) {
            writer.println("<h2>" + scheme + " consumer" + "</h2>");
            this.showDocumentationAndFieldInjections(writer, roundEnv, consumerElement, consumerPrefix);
            found = true;
        }
        if (!found && consumerClassName != null) {
            this.warning("APT could not find consumer class " + consumerClassName);
        }
        writer.println("</body>");
        writer.println("</html>");
    }

    protected void writeJSonSchemeDocumentation(PrintWriter writer, RoundEnvironment roundEnv, TypeElement classElement, UriEndpoint uriEndpoint, String title, String scheme, String label) {
        ComponentModel componentModel = this.findComponentProperties(roundEnv, uriEndpoint, title, scheme, label);
        LinkedHashSet<EndpointPath> endpointPaths = new LinkedHashSet<EndpointPath>();
        LinkedHashSet<EndpointOption> endpointOptions = new LinkedHashSet<EndpointOption>();
        LinkedHashSet<ComponentOption> componentOptions = new LinkedHashSet<ComponentOption>();
        TypeElement componentClassElement = this.findTypeElement(roundEnv, componentModel.getJavaType());
        if (componentClassElement != null) {
            this.findComponentClassProperties(writer, roundEnv, componentOptions, componentClassElement, "");
        }
        this.findClassProperties(writer, roundEnv, endpointPaths, endpointOptions, classElement, "");
        String json = this.createParameterJsonSchema(componentModel, componentOptions, endpointPaths, endpointOptions);
        writer.println(json);
    }

    public String createParameterJsonSchema(ComponentModel componentModel, Set<ComponentOption> componentOptions, Set<EndpointPath> endpointPaths, Set<EndpointOption> endpointOptions) {
        String defaultValue;
        Boolean required;
        String doc;
        String label;
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("\n \"component\": {");
        buffer.append("\n    \"kind\": \"").append("component").append("\",");
        buffer.append("\n    \"scheme\": \"").append(componentModel.getScheme()).append("\",");
        buffer.append("\n    \"syntax\": \"").append(componentModel.getSyntax()).append("\",");
        buffer.append("\n    \"title\": \"").append(componentModel.getTitle()).append("\",");
        buffer.append("\n    \"description\": \"").append(componentModel.getDescription()).append("\",");
        buffer.append("\n    \"label\": \"").append(Strings.getOrElse(componentModel.getLabel(), "")).append("\",");
        if (componentModel.isConsumerOnly()) {
            buffer.append("\n    \"consumerOnly\": \"").append("true").append("\",");
        } else if (componentModel.isProducerOnly()) {
            buffer.append("\n    \"producerOnly\": \"").append("true").append("\",");
        }
        buffer.append("\n    \"javaType\": \"").append(componentModel.getJavaType()).append("\",");
        buffer.append("\n    \"groupId\": \"").append(componentModel.getGroupId()).append("\",");
        buffer.append("\n    \"artifactId\": \"").append(componentModel.getArtifactId()).append("\",");
        buffer.append("\n    \"version\": \"").append(componentModel.getVersionId()).append("\"");
        buffer.append("\n  },");
        buffer.append("\n  \"componentProperties\": {");
        boolean first = true;
        for (ComponentOption componentOption : componentOptions) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n    ");
            String doc2 = componentOption.getDocumentationWithNotes();
            doc2 = JsonSchemaHelper.sanitizeDescription(doc2, false);
            Boolean required2 = componentOption.getRequired() != null ? Boolean.valueOf(componentOption.getRequired()) : null;
            String defaultValue2 = componentOption.getDefaultValue();
            if (Strings.isNullOrEmpty(defaultValue2) && "boolean".equals(componentOption.getType())) {
                defaultValue2 = "false";
            }
            buffer.append(JsonSchemaHelper.toJson(componentOption.getName(), "property", required2, componentOption.getType(), defaultValue2, doc2, componentOption.isDeprecated(), componentOption.getLabel(), componentOption.isEnumType(), componentOption.getEnums(), false, null));
        }
        buffer.append("\n  },");
        buffer.append("\n  \"properties\": {");
        first = true;
        for (EndpointPath endpointPath : endpointPaths) {
            label = endpointPath.getLabel();
            if (label != null && (label.contains("consumer") && componentModel.isProducerOnly() || label.contains("producer") && componentModel.isConsumerOnly())) continue;
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n    ");
            doc = endpointPath.getDocumentation();
            doc = JsonSchemaHelper.sanitizeDescription(doc, false);
            required = endpointPath.getRequired() != null ? Boolean.valueOf(endpointPath.getRequired()) : null;
            defaultValue = endpointPath.getDefaultValue();
            if (Strings.isNullOrEmpty(defaultValue) && "boolean".equals(endpointPath.getType())) {
                defaultValue = "false";
            }
            buffer.append(JsonSchemaHelper.toJson(endpointPath.getName(), "path", required, endpointPath.getType(), defaultValue, doc, endpointPath.isDeprecated(), label, endpointPath.isEnumType(), endpointPath.getEnums(), false, null));
        }
        for (EndpointOption endpointOption : endpointOptions) {
            label = endpointOption.getLabel();
            if (label != null && (label.contains("consumer") && componentModel.isProducerOnly() || label.contains("producer") && componentModel.isConsumerOnly())) continue;
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n    ");
            doc = endpointOption.getDocumentationWithNotes();
            doc = JsonSchemaHelper.sanitizeDescription(doc, false);
            required = endpointOption.getRequired() != null ? Boolean.valueOf(endpointOption.getRequired()) : null;
            defaultValue = endpointOption.getDefaultValue();
            if (Strings.isNullOrEmpty(defaultValue) && "boolean".equals(endpointOption.getType())) {
                defaultValue = "false";
            }
            buffer.append(JsonSchemaHelper.toJson(endpointOption.getName(), "parameter", required, endpointOption.getType(), defaultValue, doc, endpointOption.isDeprecated(), label, endpointOption.isEnumType(), endpointOption.getEnums(), false, null));
        }
        buffer.append("\n  }");
        buffer.append("\n}\n");
        return buffer.toString();
    }

    protected void showDocumentationAndFieldInjections(PrintWriter writer, RoundEnvironment roundEnv, TypeElement classElement, String prefix) {
        String classDoc = this.processingEnv.getElementUtils().getDocComment(classElement);
        if (!Strings.isNullOrEmpty(classDoc)) {
            classDoc = classDoc.replaceFirst("\\@version", "");
            classDoc = classDoc.trim();
            writer.println("<p>" + classDoc + "</p>");
        }
        LinkedHashSet<EndpointPath> endpointPaths = new LinkedHashSet<EndpointPath>();
        LinkedHashSet<EndpointOption> endpointOptions = new LinkedHashSet<EndpointOption>();
        this.findClassProperties(writer, roundEnv, endpointPaths, endpointOptions, classElement, prefix);
        if (!endpointOptions.isEmpty() || !endpointPaths.isEmpty()) {
            writer.println("<table class='table'>");
            writer.println("  <tr>");
            writer.println("    <th>Name</th>");
            writer.println("    <th>Kind</th>");
            writer.println("    <th>Type</th>");
            writer.println("    <th>Required</th>");
            writer.println("    <th>Deprecated</th>");
            writer.println("    <th>Default Value</th>");
            writer.println("    <th>Enum Values</th>");
            writer.println("    <th>Description</th>");
            writer.println("  </tr>");
            for (EndpointPath path : endpointPaths) {
                writer.println("  <tr>");
                writer.println("    <td>" + path.getName() + "</td>");
                writer.println("    <td>path</td>");
                writer.println("    <td>" + path.getType() + "</td>");
                writer.println("    <td>" + Strings.safeNull(path.getRequired()) + "</td>");
                writer.println("    <td>" + path.isDeprecated() + "</td>");
                writer.println("    <td>" + path.getEnumValuesAsHtml() + "</td>");
                writer.println("    <td>" + path.getDocumentation() + "</td>");
                writer.println("  </tr>");
            }
            for (EndpointOption option : endpointOptions) {
                writer.println("  <tr>");
                writer.println("    <td>" + option.getName() + "</td>");
                writer.println("    <td>parameter</td>");
                writer.println("    <td>" + option.getType() + "</td>");
                writer.println("    <td>" + Strings.safeNull(option.getRequired()) + "</td>");
                writer.println("    <td>" + option.isDeprecated() + "</td>");
                writer.println("    <td>" + option.getDefaultValue() + "</td>");
                writer.println("    <td>" + option.getEnumValuesAsHtml() + "</td>");
                writer.println("    <td>" + option.getDocumentationWithNotes() + "</td>");
                writer.println("  </tr>");
            }
            writer.println("</table>");
        }
    }

    protected ComponentModel findComponentProperties(RoundEnvironment roundEnv, UriEndpoint uriEndpoint, String title, String scheme, String label) {
        Map<String, String> map;
        ComponentModel model = new ComponentModel(scheme);
        String syntax = scheme + ":" + Strings.after(uriEndpoint.syntax(), ":");
        model.setSyntax(syntax);
        model.setTitle(title);
        model.setLabel(label);
        model.setConsumerOnly(uriEndpoint.consumerOnly());
        model.setProducerOnly(uriEndpoint.producerOnly());
        String data = this.loadResource("META-INF/services/org/apache/camel/component", scheme);
        if (data != null) {
            map = this.parseAsMap(data);
            model.setJavaType(map.get("class"));
        }
        if ((data = this.loadResource("META-INF/services/org/apache/camel", "component.properties")) != null) {
            map = this.parseAsMap(data);
            String doc = map.get("projectDescription");
            if (doc != null) {
                model.setDescription(JsonSchemaHelper.sanitizeDescription(doc, true));
            } else {
                model.setDescription("");
            }
            if (map.containsKey("groupId")) {
                model.setGroupId(map.get("groupId"));
            } else {
                model.setGroupId("");
            }
            if (map.containsKey("artifactId")) {
                model.setArtifactId(map.get("artifactId"));
            } else {
                model.setArtifactId("");
            }
            if (map.containsKey("version")) {
                model.setVersionId(map.get("version"));
            } else {
                model.setVersionId("");
            }
        }
        if (model.getJavaType() != null) {
            String doc;
            Elements elementUtils = this.processingEnv.getElementUtils();
            TypeElement typeElement = this.findTypeElement(roundEnv, model.getJavaType());
            if (typeElement != null && (doc = elementUtils.getDocComment(typeElement)) != null && !Strings.isNullOrEmpty(doc = JsonSchemaHelper.sanitizeDescription(doc, true))) {
                model.setDescription(doc);
            }
        }
        return model;
    }

    protected void findComponentClassProperties(PrintWriter writer, RoundEnvironment roundEnv, Set<ComponentOption> componentOptions, TypeElement classElement, String prefix) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        while (true) {
            List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
            for (ExecutableElement method : methods) {
                boolean isEnum;
                String methodName = method.getSimpleName().toString();
                boolean deprecated = method.getAnnotation(Deprecated.class) != null;
                Metadata metadata = method.getAnnotation(Metadata.class);
                boolean isSetter = methodName.startsWith("set") && method.getParameters().size() == 1 & method.getReturnType().getKind().equals((Object)TypeKind.VOID);
                if (!isSetter || "setEndpointClass".equals(methodName) || "setCamelContext".equals(methodName) || "setEndpointHeaderFilterStrategy".equals(methodName)) continue;
                String fieldName = methodName.substring(3);
                fieldName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
                ExecutableElement setter = method;
                String name = fieldName;
                name = prefix + name;
                TypeMirror fieldType = setter.getParameters().get(0).asType();
                String fieldTypeName = fieldType.toString();
                TypeElement fieldTypeElement = this.findTypeElement(roundEnv, fieldTypeName);
                String required = metadata != null ? metadata.required() : null;
                String label = metadata != null ? metadata.label() : null;
                String defaultValue = metadata != null ? metadata.defaultValue() : null;
                String defaultValueNote = null;
                String docComment = this.findJavaDoc(elementUtils, method, fieldName, name, classElement, false);
                if (docComment == null) {
                    docComment = "setHeaderFilterStrategy".equals(methodName) ? HEADER_FILTER_STRATEGY_JAVADOC : "";
                }
                LinkedHashSet<String> enums = new LinkedHashSet<String>();
                boolean bl = isEnum = fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.ENUM;
                if (isEnum) {
                    TypeElement enumClass = this.findTypeElement(roundEnv, fieldTypeElement.asType().toString());
                    List<VariableElement> fields = ElementFilter.fieldsIn(enumClass.getEnclosedElements());
                    for (VariableElement var : fields) {
                        if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                        String val = var.toString();
                        enums.add(val);
                    }
                }
                ComponentOption option = new ComponentOption(name, fieldTypeName, required, defaultValue, defaultValueNote, docComment.trim(), deprecated, label, isEnum, enums);
                componentOptions.add(option);
            }
            TypeElement baseTypeElement = null;
            TypeMirror superclass = classElement.getSuperclass();
            if (superclass != null) {
                String superClassName = Strings.canonicalClassName(superclass.toString());
                baseTypeElement = this.findTypeElement(roundEnv, superClassName);
            }
            if (baseTypeElement == null) break;
            classElement = baseTypeElement;
        }
    }

    protected void findClassProperties(PrintWriter writer, RoundEnvironment roundEnv, Set<EndpointPath> endpointPaths, Set<EndpointOption> endpointOptions, TypeElement classElement, String prefix) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        while (true) {
            List<VariableElement> fieldElements = ElementFilter.fieldsIn(classElement.getEnclosedElements());
            for (VariableElement fieldElement : fieldElements) {
                boolean isEnum;
                Metadata metadata = fieldElement.getAnnotation(Metadata.class);
                boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
                UriPath path = fieldElement.getAnnotation(UriPath.class);
                String fieldName = fieldElement.getSimpleName().toString();
                if (path != null) {
                    boolean isEnum2;
                    String name = path.name();
                    if (Strings.isNullOrEmpty(name)) {
                        name = fieldName;
                    }
                    name = prefix + name;
                    String defaultValue = path.defaultValue();
                    if (defaultValue == null && metadata != null) {
                        defaultValue = metadata.defaultValue();
                    }
                    String defaultValueNote = path.defaultValueNote();
                    String required = metadata != null ? metadata.required() : null;
                    String label = path.label();
                    TypeMirror fieldType = fieldElement.asType();
                    String fieldTypeName = fieldType.toString();
                    TypeElement fieldTypeElement = this.findTypeElement(roundEnv, fieldTypeName);
                    String docComment = this.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, false);
                    if (Strings.isNullOrEmpty(docComment)) {
                        docComment = path.description();
                    }
                    LinkedHashSet<String> enums = new LinkedHashSet<String>();
                    if (!Strings.isNullOrEmpty(path.enums())) {
                        String[] values;
                        isEnum2 = true;
                        for (String val : values = path.enums().split(",")) {
                            enums.add(val);
                        }
                    } else {
                        boolean bl = isEnum2 = fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.ENUM;
                        if (isEnum2) {
                            TypeElement enumClass = this.findTypeElement(roundEnv, fieldTypeElement.asType().toString());
                            List<VariableElement> fields = ElementFilter.fieldsIn(enumClass.getEnclosedElements());
                            for (VariableElement var : fields) {
                                if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                                String val = var.toString();
                                enums.add(val);
                            }
                        }
                    }
                    EndpointPath ep = new EndpointPath(name, fieldTypeName, required, defaultValue, docComment, deprecated, label, isEnum2, enums);
                    endpointPaths.add(ep);
                }
                UriParam param = fieldElement.getAnnotation(UriParam.class);
                fieldName = fieldElement.getSimpleName().toString();
                if (param == null) continue;
                String name = param.name();
                if (Strings.isNullOrEmpty(name)) {
                    name = fieldName;
                }
                name = prefix + name;
                String defaultValue = param.defaultValue();
                if (defaultValue == null && metadata != null) {
                    defaultValue = metadata.defaultValue();
                }
                String defaultValueNote = param.defaultValueNote();
                String required = metadata != null ? metadata.required() : null;
                String label = param.label();
                TypeMirror fieldType = fieldElement.asType();
                String fieldTypeName = fieldType.toString();
                TypeElement fieldTypeElement = this.findTypeElement(roundEnv, fieldTypeName);
                UriParams fieldParams = null;
                if (fieldTypeElement != null) {
                    fieldParams = fieldTypeElement.getAnnotation(UriParams.class);
                }
                if (fieldParams != null) {
                    String nestedPrefix = prefix;
                    String extraPrefix = fieldParams.prefix();
                    if (!Strings.isNullOrEmpty(extraPrefix)) {
                        nestedPrefix = nestedPrefix + extraPrefix;
                    }
                    this.findClassProperties(writer, roundEnv, endpointPaths, endpointOptions, fieldTypeElement, nestedPrefix);
                    continue;
                }
                String docComment = this.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, false);
                if (Strings.isNullOrEmpty(docComment)) {
                    docComment = param.description();
                }
                LinkedHashSet<String> enums = new LinkedHashSet<String>();
                if (!Strings.isNullOrEmpty(param.enums())) {
                    String[] values;
                    isEnum = true;
                    for (String val : values = param.enums().split(",")) {
                        enums.add(val);
                    }
                } else {
                    boolean bl = isEnum = fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.ENUM;
                    if (isEnum) {
                        TypeElement enumClass = this.findTypeElement(roundEnv, fieldTypeElement.asType().toString());
                        List<VariableElement> fields = ElementFilter.fieldsIn(enumClass.getEnclosedElements());
                        for (VariableElement var : fields) {
                            String val;
                            if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                            val = var.toString();
                            enums.add(val);
                        }
                    }
                }
                EndpointOption option = new EndpointOption(name, fieldTypeName, required, defaultValue, defaultValueNote, docComment.trim(), deprecated, label, isEnum, enums);
                endpointOptions.add(option);
            }
            TypeElement baseTypeElement = null;
            TypeMirror superclass = classElement.getSuperclass();
            if (superclass != null) {
                String superClassName = Strings.canonicalClassName(superclass.toString());
                baseTypeElement = this.findTypeElement(roundEnv, superClassName);
            }
            if (baseTypeElement == null) break;
            classElement = baseTypeElement;
        }
    }

    protected Map<String, String> parseAsMap(String data) {
        String[] lines;
        HashMap<String, String> answer = new HashMap<String, String>();
        for (String line : lines = data.split("\n")) {
            int idx = line.indexOf(61);
            String key = line.substring(0, idx);
            String value = line.substring(idx + 1);
            value = value.trim().replaceAll("\n", "");
            answer.put(key.trim(), value);
        }
        return answer;
    }

    private static final class EndpointPath {
        private String name;
        private String type;
        private String required;
        private String defaultValue;
        private String documentation;
        private boolean deprecated;
        private String label;
        private boolean enumType;
        private Set<String> enums;

        private EndpointPath(String name, String type, String required, String defaultValue, String documentation, boolean deprecated, String label, boolean enumType, Set<String> enums) {
            this.name = name;
            this.type = type;
            this.required = required;
            this.defaultValue = defaultValue;
            this.documentation = documentation;
            this.deprecated = deprecated;
            this.label = label;
            this.enumType = enumType;
            this.enums = enums;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getRequired() {
            return this.required;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public String getEnumValuesAsHtml() {
            CollectionStringBuffer csb = new CollectionStringBuffer("<br/>");
            if (this.enums != null && this.enums.size() > 0) {
                for (String e : this.enums) {
                    csb.append(e);
                }
            }
            return csb.toString();
        }

        public boolean isEnumType() {
            return this.enumType;
        }

        public Set<String> getEnums() {
            return this.enums;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndpointPath that = (EndpointPath)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static final class EndpointOption {
        private String name;
        private String type;
        private String required;
        private String defaultValue;
        private String defaultValueNote;
        private String documentation;
        private boolean deprecated;
        private String label;
        private boolean enumType;
        private Set<String> enums;

        private EndpointOption(String name, String type, String required, String defaultValue, String defaultValueNote, String documentation, boolean deprecated, String label, boolean enumType, Set<String> enums) {
            this.name = name;
            this.type = type;
            this.required = required;
            this.defaultValue = defaultValue;
            this.defaultValueNote = defaultValueNote;
            this.documentation = documentation;
            this.deprecated = deprecated;
            this.label = label;
            this.enumType = enumType;
            this.enums = enums;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getRequired() {
            return this.required;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public String getEnumValuesAsHtml() {
            CollectionStringBuffer csb = new CollectionStringBuffer("<br/>");
            if (this.enums != null && this.enums.size() > 0) {
                for (String e : this.enums) {
                    csb.append(e);
                }
            }
            return csb.toString();
        }

        public String getDocumentationWithNotes() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.documentation);
            if (!Strings.isNullOrEmpty(this.defaultValueNote)) {
                sb.append(". Default value notice: ").append(this.defaultValueNote);
            }
            return sb.toString();
        }

        public boolean isEnumType() {
            return this.enumType;
        }

        public Set<String> getEnums() {
            return this.enums;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndpointOption that = (EndpointOption)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static final class ComponentOption {
        private String name;
        private String type;
        private String required;
        private String defaultValue;
        private String defaultValueNote;
        private String documentation;
        private boolean deprecated;
        private String label;
        private boolean enumType;
        private Set<String> enums;

        private ComponentOption(String name, String type, String required, String defaultValue, String defaultValueNote, String documentation, boolean deprecated, String label, boolean enumType, Set<String> enums) {
            this.name = name;
            this.type = type;
            this.required = required;
            this.defaultValue = defaultValue;
            this.defaultValueNote = defaultValueNote;
            this.documentation = documentation;
            this.deprecated = deprecated;
            this.label = label;
            this.enumType = enumType;
            this.enums = enums;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getRequired() {
            return this.required;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public String getEnumValuesAsHtml() {
            CollectionStringBuffer csb = new CollectionStringBuffer("<br/>");
            if (this.enums != null && this.enums.size() > 0) {
                for (String e : this.enums) {
                    csb.append(e);
                }
            }
            return csb.toString();
        }

        public String getDocumentationWithNotes() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.documentation);
            if (!Strings.isNullOrEmpty(this.defaultValueNote)) {
                sb.append(". Default value notice: ").append(this.defaultValueNote);
            }
            return sb.toString();
        }

        public boolean isEnumType() {
            return this.enumType;
        }

        public Set<String> getEnums() {
            return this.enums;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentOption that = (ComponentOption)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static final class ComponentModel {
        private String scheme;
        private String syntax;
        private String javaType;
        private String title;
        private String description;
        private String groupId;
        private String artifactId;
        private String versionId;
        private String label;
        private boolean consumerOnly;
        private boolean producerOnly;

        private ComponentModel(String scheme) {
            this.scheme = scheme;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getSyntax() {
            return this.syntax;
        }

        public void setSyntax(String syntax) {
            this.syntax = syntax;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public void setJavaType(String javaType) {
            this.javaType = javaType;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersionId() {
            return this.versionId;
        }

        public void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public boolean isConsumerOnly() {
            return this.consumerOnly;
        }

        public void setConsumerOnly(boolean consumerOnly) {
            this.consumerOnly = consumerOnly;
        }

        public boolean isProducerOnly() {
            return this.producerOnly;
        }

        public void setProducerOnly(boolean producerOnly) {
            this.producerOnly = producerOnly;
        }
    }
}

