/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.List;
import java.util.Map;
import org.apache.camel.tools.apt.helper.IOHelper;
import org.apache.camel.tools.apt.helper.JsonSchemaHelper;

public final class DocumentationHelper {
    private DocumentationHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String findComponentJavaDoc(String scheme, String extendsScheme, String fieldName) {
        File file = DocumentationHelper.jsonFile(scheme, extendsScheme);
        if (file != null) {
            String string;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                String json = DocumentationHelper.loadText(fis);
                List<Map<String, String>> rows = JsonSchemaHelper.parseJsonSchema("componentProperties", json, true);
                string = DocumentationHelper.getPropertyDescription(rows, fieldName);
            }
            catch (Exception exception) {
                IOHelper.close(fis);
                catch (Throwable throwable) {
                    IOHelper.close(fis);
                    throw throwable;
                }
            }
            IOHelper.close(fis);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String findEndpointJavaDoc(String scheme, String extendsScheme, String fieldName) {
        File file = DocumentationHelper.jsonFile(scheme, extendsScheme);
        if (file != null) {
            String string;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                String json = DocumentationHelper.loadText(fis);
                List<Map<String, String>> rows = JsonSchemaHelper.parseJsonSchema("properties", json, true);
                string = DocumentationHelper.getPropertyDescription(rows, fieldName);
            }
            catch (Exception exception) {
                IOHelper.close(fis);
                catch (Throwable throwable) {
                    IOHelper.close(fis);
                    throw throwable;
                }
            }
            IOHelper.close(fis);
            return string;
        }
        return null;
    }

    private static String getPropertyDescription(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String description = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("description")) {
                description = row.get("description");
            }
            if (!found) continue;
            return description;
        }
        return null;
    }

    private static File jsonFile(String scheme, String extendsScheme) {
        if ("file".equals(extendsScheme)) {
            return new File("../../camel-core/target/classes/org/apache/camel/component/file/file.json");
        }
        if ("ahc".equals(extendsScheme)) {
            return new File("../camel-ahc/target/classes/org/apache/camel/component/ahc/ahc.json");
        }
        if ("atom".equals(extendsScheme)) {
            return new File("../camel-atom/target/classes/org/apache/camel/component/atom/atom.json");
        }
        if ("ftp".equals(extendsScheme)) {
            return new File("../camel-ftp/target/classes/org/apache/camel/component/file/remote/ftp.json");
        }
        if ("jms".equals(extendsScheme)) {
            return new File("../camel-jms/target/classes/org/apache/camel/component/jms/jms.json");
        }
        if ("sjms".equals(extendsScheme)) {
            return new File("../camel-sjms/target/classes/org/apache/camel/component/sjms/sjms.json");
        }
        if ("http".equals(extendsScheme)) {
            return new File("../camel-http/target/classes/org/apache/camel/component/http/http.json");
        }
        if ("https".equals(extendsScheme)) {
            return new File("../camel-http/target/classes/org/apache/camel/component/http/https.json");
        }
        if ("netty".equals(extendsScheme)) {
            return new File("../camel-netty/target/classes/org/apache/camel/component/netty/netty.json");
        }
        if ("netty4".equals(extendsScheme)) {
            return new File("../camel-netty4/target/classes/org/apache/camel/component/netty4/netty4.json");
        }
        if ("servlet".equals(extendsScheme)) {
            return new File("../camel-servlet/target/classes/org/apache/camel/component/servlet/servlet.json");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadText(InputStream in) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(in);
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(isr);
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            isr.close();
            in.close();
        }
    }
}

