/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.tools.apt.AnnotationProcessorHelper;
import org.apache.camel.tools.apt.DocumentationHelper;
import org.apache.camel.tools.apt.Func1;
import org.apache.camel.tools.apt.helper.CollectionStringBuffer;
import org.apache.camel.tools.apt.helper.EndpointHelper;
import org.apache.camel.tools.apt.helper.JsonSchemaHelper;
import org.apache.camel.tools.apt.helper.Strings;
import org.apache.camel.tools.apt.model.ComponentModel;
import org.apache.camel.tools.apt.model.ComponentOption;
import org.apache.camel.tools.apt.model.EndpointOption;
import org.apache.camel.tools.apt.model.EndpointPath;

@SupportedAnnotationTypes(value={"org.apache.camel.spi.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class EndpointAnnotationProcessor
extends AbstractProcessor {
    private static final String HEADER_FILTER_STRATEGY_JAVADOC = "To use a custom HeaderFilterStrategy to filter header to and from Camel message.";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (roundEnv.processingOver()) {
                return true;
            }
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(UriEndpoint.class);
            for (Element element : elements) {
                if (!(element instanceof TypeElement)) continue;
                this.processEndpointClass(roundEnv, (TypeElement)element);
            }
        }
        catch (Throwable e) {
            AnnotationProcessorHelper.dumpExceptionToErrorFile("camel-apt-error.log", "Error processing @UriEndpoint", e);
        }
        return true;
    }

    private void processEndpointClass(final RoundEnvironment roundEnv, final TypeElement classElement) {
        final UriEndpoint uriEndpoint = classElement.getAnnotation(UriEndpoint.class);
        if (uriEndpoint != null) {
            String scheme = uriEndpoint.scheme();
            String extendsScheme = uriEndpoint.extendsScheme();
            String title = uriEndpoint.title();
            final String label = uriEndpoint.label();
            if (!Strings.isNullOrEmpty(scheme)) {
                final String[] schemes = scheme.split(",");
                String[] titles = title.split(",");
                String[] extendsSchemes = extendsScheme.split(",");
                for (int i = 0; i < schemes.length; ++i) {
                    String aTitle;
                    final String alias = schemes[i];
                    final String extendsAlias = i < extendsSchemes.length ? extendsSchemes[i] : extendsSchemes[0];
                    String string = aTitle = i < titles.length ? titles[i] : titles[0];
                    if (EndpointAnnotationProcessor.secureAlias(schemes[0], alias)) {
                        aTitle = aTitle + " (Secure)";
                    }
                    final String aliasTitle = aTitle;
                    String name = Strings.canonicalClassName(classElement.getQualifiedName().toString());
                    String packageName = name.substring(0, name.lastIndexOf("."));
                    String fileName = alias + ".json";
                    Func1<PrintWriter, Void> handler = new Func1<PrintWriter, Void>(){

                        @Override
                        public Void call(PrintWriter writer) {
                            EndpointAnnotationProcessor.this.writeJSonSchemeDocumentation(writer, roundEnv, classElement, uriEndpoint, aliasTitle, alias, extendsAlias, label, schemes);
                            return null;
                        }
                    };
                    AnnotationProcessorHelper.processFile(this.processingEnv, packageName, fileName, handler);
                }
            }
        }
    }

    protected void writeJSonSchemeDocumentation(PrintWriter writer, RoundEnvironment roundEnv, TypeElement classElement, UriEndpoint uriEndpoint, String title, String scheme, String extendsScheme, String label, String[] schemes) {
        ComponentModel componentModel = this.findComponentProperties(roundEnv, uriEndpoint, classElement, title, scheme, extendsScheme, label);
        LinkedHashSet<EndpointPath> endpointPaths = new LinkedHashSet<EndpointPath>();
        LinkedHashSet<EndpointOption> endpointOptions = new LinkedHashSet<EndpointOption>();
        LinkedHashSet<ComponentOption> componentOptions = new LinkedHashSet<ComponentOption>();
        TypeElement componentClassElement = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, componentModel.getJavaType());
        if (componentClassElement != null) {
            this.findComponentClassProperties(writer, roundEnv, componentModel, componentOptions, componentClassElement, "");
        }
        this.findClassProperties(writer, roundEnv, componentModel, endpointPaths, endpointOptions, classElement, "", uriEndpoint.excludeProperties());
        String json = this.createParameterJsonSchema(componentModel, componentOptions, endpointPaths, endpointOptions, schemes);
        writer.println(json);
    }

    public String createParameterJsonSchema(ComponentModel componentModel, Set<ComponentOption> componentOptions, Set<EndpointPath> endpointPaths, Set<EndpointOption> endpointOptions, String[] schemes) {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("\n \"component\": {");
        buffer.append("\n    \"kind\": \"").append("component").append("\",");
        buffer.append("\n    \"scheme\": \"").append(componentModel.getScheme()).append("\",");
        if (!Strings.isNullOrEmpty(componentModel.getExtendsScheme())) {
            buffer.append("\n    \"extendsScheme\": \"").append(componentModel.getExtendsScheme()).append("\",");
        }
        if (schemes != null && schemes.length > 1) {
            CollectionStringBuffer csb = new CollectionStringBuffer(",");
            for (String altScheme : schemes) {
                csb.append(altScheme);
            }
            buffer.append("\n    \"alternativeSchemes\": \"").append(csb.toString()).append("\",");
        }
        buffer.append("\n    \"syntax\": \"").append(componentModel.getSyntax()).append("\",");
        if (componentModel.getAlternativeSyntax() != null) {
            buffer.append("\n    \"alternativeSyntax\": \"").append(componentModel.getAlternativeSyntax()).append("\",");
        }
        buffer.append("\n    \"title\": \"").append(componentModel.getTitle()).append("\",");
        buffer.append("\n    \"description\": \"").append(componentModel.getDescription()).append("\",");
        buffer.append("\n    \"label\": \"").append(Strings.getOrElse(componentModel.getLabel(), "")).append("\",");
        buffer.append("\n    \"deprecated\": ").append(componentModel.isDeprecated()).append(",");
        buffer.append("\n    \"async\": ").append(componentModel.isAsync()).append(",");
        buffer.append("\n    \"consumerOnly\": ").append(componentModel.isConsumerOnly()).append(",");
        buffer.append("\n    \"producerOnly\": ").append(componentModel.isProducerOnly()).append(",");
        buffer.append("\n    \"lenientProperties\": ").append(componentModel.isLenientProperties()).append(",");
        buffer.append("\n    \"javaType\": \"").append(componentModel.getJavaType()).append("\",");
        if (componentModel.getFirstVersion() != null) {
            buffer.append("\n    \"firstVersion\": \"").append(componentModel.getFirstVersion()).append("\",");
        }
        buffer.append("\n    \"groupId\": \"").append(componentModel.getGroupId()).append("\",");
        buffer.append("\n    \"artifactId\": \"").append(componentModel.getArtifactId()).append("\",");
        if (componentModel.getVerifiers() != null) {
            buffer.append("\n    \"verifiers\": \"").append(componentModel.getVerifiers()).append("\",");
        }
        buffer.append("\n    \"version\": \"").append(componentModel.getVersionId()).append("\"");
        buffer.append("\n  },");
        buffer.append("\n  \"componentProperties\": {");
        boolean first = true;
        for (ComponentOption entry : componentOptions) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n    ");
            String doc = entry.getDocumentationWithNotes();
            if (Strings.isNullOrEmpty(doc)) {
                doc = DocumentationHelper.findComponentJavaDoc(componentModel.getScheme(), componentModel.getExtendsScheme(), entry.getName());
            }
            doc = JsonSchemaHelper.sanitizeDescription(doc, false);
            Boolean required = entry.getRequired() != null ? Boolean.valueOf(entry.getRequired()) : null;
            String defaultValue = entry.getDefaultValue();
            if (Strings.isNullOrEmpty(defaultValue) && "boolean".equals(entry.getType())) {
                defaultValue = "false";
            }
            String optionalPrefix = "";
            String prefix = "";
            boolean multiValue = false;
            boolean asPredicate = false;
            buffer.append(JsonSchemaHelper.toJson(entry.getName(), entry.getDisplayName(), "property", required, entry.getType(), defaultValue, doc, entry.isDeprecated(), entry.isSecret(), entry.getGroup(), entry.getLabel(), entry.isEnumType(), entry.getEnums(), false, null, asPredicate, optionalPrefix, prefix, multiValue));
        }
        buffer.append("\n  },");
        buffer.append("\n  \"properties\": {");
        first = true;
        ArrayList<EndpointPath> paths = new ArrayList<EndpointPath>();
        paths.addAll(endpointPaths);
        Collections.sort(paths, EndpointHelper.createPathComparator(componentModel.getSyntax()));
        for (EndpointPath entry : paths) {
            String label = entry.getLabel();
            if (label != null && (label.contains("consumer") && componentModel.isProducerOnly() || label.contains("producer") && componentModel.isConsumerOnly())) continue;
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n    ");
            String doc = entry.getDocumentation();
            if (Strings.isNullOrEmpty(doc)) {
                doc = DocumentationHelper.findEndpointJavaDoc(componentModel.getScheme(), componentModel.getExtendsScheme(), entry.getName());
            }
            doc = JsonSchemaHelper.sanitizeDescription(doc, false);
            Boolean required = entry.getRequired() != null ? Boolean.valueOf(entry.getRequired()) : null;
            String defaultValue = entry.getDefaultValue();
            if (Strings.isNullOrEmpty(defaultValue) && "boolean".equals(entry.getType())) {
                defaultValue = "false";
            }
            String optionalPrefix = "";
            String prefix = "";
            boolean multiValue = false;
            boolean asPredicate = false;
            buffer.append(JsonSchemaHelper.toJson(entry.getName(), entry.getDisplayName(), "path", required, entry.getType(), defaultValue, doc, entry.isDeprecated(), entry.isSecret(), entry.getGroup(), entry.getLabel(), entry.isEnumType(), entry.getEnums(), false, null, asPredicate, optionalPrefix, prefix, multiValue));
        }
        ArrayList<EndpointOption> options = new ArrayList<EndpointOption>();
        options.addAll(endpointOptions);
        Collections.sort(options, EndpointHelper.createGroupAndLabelComparator());
        for (EndpointOption entry : options) {
            String label = entry.getLabel();
            if (label != null && (label.contains("consumer") && componentModel.isProducerOnly() || label.contains("producer") && componentModel.isConsumerOnly())) continue;
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append("\n    ");
            String doc = entry.getDocumentationWithNotes();
            if (Strings.isNullOrEmpty(doc)) {
                doc = DocumentationHelper.findEndpointJavaDoc(componentModel.getScheme(), componentModel.getExtendsScheme(), entry.getName());
            }
            doc = JsonSchemaHelper.sanitizeDescription(doc, false);
            Boolean required = entry.getRequired() != null ? Boolean.valueOf(entry.getRequired()) : null;
            String defaultValue = entry.getDefaultValue();
            if (Strings.isNullOrEmpty(defaultValue) && "boolean".equals(entry.getType())) {
                defaultValue = "false";
            }
            String optionalPrefix = entry.getOptionalPrefix();
            String prefix = entry.getPrefix();
            boolean multiValue = entry.isMultiValue();
            boolean asPredicate = false;
            buffer.append(JsonSchemaHelper.toJson(entry.getName(), entry.getDisplayName(), "parameter", required, entry.getType(), defaultValue, doc, entry.isDeprecated(), entry.isSecret(), entry.getGroup(), entry.getLabel(), entry.isEnumType(), entry.getEnums(), false, null, asPredicate, optionalPrefix, prefix, multiValue));
        }
        buffer.append("\n  }");
        buffer.append("\n}\n");
        return buffer.toString();
    }

    protected ComponentModel findComponentProperties(RoundEnvironment roundEnv, UriEndpoint uriEndpoint, TypeElement endpointClassElement, String title, String scheme, String extendsScheme, String label) {
        String doc;
        Map<String, String> map;
        String data;
        ComponentModel model = new ComponentModel(scheme);
        String syntax = scheme + ":" + Strings.after(uriEndpoint.syntax(), ":");
        if (!Strings.isNullOrEmpty(uriEndpoint.alternativeSyntax())) {
            String alternativeSyntax = scheme + ":" + Strings.after(uriEndpoint.alternativeSyntax(), ":");
            model.setAlternativeSyntax(alternativeSyntax);
        }
        model.setExtendsScheme(extendsScheme);
        model.setSyntax(syntax);
        model.setTitle(title);
        model.setLabel(label);
        model.setConsumerOnly(uriEndpoint.consumerOnly());
        model.setProducerOnly(uriEndpoint.producerOnly());
        model.setLenientProperties(uriEndpoint.lenientProperties());
        model.setAsync(AnnotationProcessorHelper.implementsInterface(this.processingEnv, roundEnv, endpointClassElement, "org.apache.camel.AsyncEndpoint"));
        String firstVersion = uriEndpoint.firstVersion();
        if (Strings.isNullOrEmpty(firstVersion) && endpointClassElement.getAnnotation(Metadata.class) != null) {
            firstVersion = endpointClassElement.getAnnotation(Metadata.class).firstVersion();
        }
        if (!Strings.isNullOrEmpty(firstVersion)) {
            model.setFirstVersion(firstVersion);
        }
        if ((data = AnnotationProcessorHelper.loadResource(this.processingEnv, "META-INF/services/org/apache/camel/component", scheme)) != null) {
            map = EndpointAnnotationProcessor.parseAsMap(data);
            model.setJavaType(map.get("class"));
        }
        if ((data = AnnotationProcessorHelper.loadResource(this.processingEnv, "META-INF/services/org/apache/camel", "component.properties")) != null) {
            boolean deprecated;
            map = EndpointAnnotationProcessor.parseAsMap(data);
            String doc2 = map.get("projectDescription");
            if (doc2 != null) {
                model.setDescription(JsonSchemaHelper.sanitizeDescription(doc2, true));
            } else {
                model.setDescription("");
            }
            boolean bl = deprecated = endpointClassElement.getAnnotation(Deprecated.class) != null;
            if (!deprecated) {
                String name = map.get("projectName");
                deprecated = name != null && name.contains("(deprecated)");
            }
            model.setDeprecated(deprecated);
            if (map.containsKey("groupId")) {
                model.setGroupId(map.get("groupId"));
            } else {
                model.setGroupId("");
            }
            if (map.containsKey("artifactId")) {
                model.setArtifactId(map.get("artifactId"));
            } else {
                model.setArtifactId("");
            }
            if (map.containsKey("version")) {
                model.setVersionId(map.get("version"));
            } else {
                model.setVersionId("");
            }
        }
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement typeElement = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, endpointClassElement.getQualifiedName().toString());
        if (typeElement != null && (doc = elementUtils.getDocComment(typeElement)) != null && !Strings.isNullOrEmpty(doc = JsonSchemaHelper.sanitizeDescription(doc, true))) {
            model.setDescription(doc);
        }
        return model;
    }

    protected void findComponentClassProperties(PrintWriter writer, RoundEnvironment roundEnv, ComponentModel componentModel, Set<ComponentOption> componentOptions, TypeElement classElement, String prefix) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        while (true) {
            Metadata componentAnnotation;
            if ((componentAnnotation = classElement.getAnnotation(Metadata.class)) != null && Objects.equals("verifiers", componentAnnotation.label())) {
                componentModel.setVerifiers(componentAnnotation.enums());
            }
            List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
            for (ExecutableElement method : methods) {
                boolean isEnum;
                String methodName = method.getSimpleName().toString();
                boolean deprecated = method.getAnnotation(Deprecated.class) != null;
                Metadata metadata = method.getAnnotation(Metadata.class);
                boolean isSetter = methodName.startsWith("set") && method.getParameters().size() == 1 & method.getReturnType().getKind().equals((Object)TypeKind.VOID);
                if (!isSetter || "setEndpointClass".equals(methodName) || "setCamelContext".equals(methodName) || "setEndpointHeaderFilterStrategy".equals(methodName) || "setApplicationContext".equals(methodName)) continue;
                String fieldName = methodName.substring(3);
                VariableElement field = AnnotationProcessorHelper.findFieldElement(classElement, fieldName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1));
                if (field != null && metadata == null) {
                    metadata = field.getAnnotation(Metadata.class);
                }
                String required = metadata != null ? metadata.required() : null;
                String label = metadata != null ? metadata.label() : null;
                boolean secret = metadata != null && metadata.secret();
                String displayName = metadata != null ? metadata.displayName() : null;
                String defaultValue = metadata != null ? metadata.defaultValue() : null;
                String defaultValueNote = null;
                ExecutableElement setter = method;
                String name = fieldName;
                name = prefix + name;
                TypeMirror fieldType = setter.getParameters().get(0).asType();
                String fieldTypeName = fieldType.toString();
                TypeElement fieldTypeElement = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, fieldTypeName);
                String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, method, fieldName, name, classElement, false);
                if (Strings.isNullOrEmpty(docComment)) {
                    String string = docComment = metadata != null ? metadata.description() : null;
                }
                if (Strings.isNullOrEmpty(docComment)) {
                    docComment = "setHeaderFilterStrategy".equals(methodName) ? HEADER_FILTER_STRATEGY_JAVADOC : "";
                }
                LinkedHashSet<String> enums = new LinkedHashSet<String>();
                if (metadata != null && !Strings.isNullOrEmpty(metadata.enums())) {
                    String[] values;
                    isEnum = true;
                    for (String val : values = metadata.enums().split(",")) {
                        enums.add(val);
                    }
                } else {
                    TypeElement enumClass;
                    boolean bl = isEnum = fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.ENUM;
                    if (isEnum && (enumClass = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, fieldTypeElement.asType().toString())) != null) {
                        List<VariableElement> fields = ElementFilter.fieldsIn(enumClass.getEnclosedElements());
                        for (VariableElement var : fields) {
                            String val;
                            if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                            val = var.toString();
                            enums.add(val);
                        }
                    }
                }
                String group = EndpointHelper.labelAsGroupName(label, componentModel.isConsumerOnly(), componentModel.isProducerOnly());
                ComponentOption option = new ComponentOption(name, displayName, fieldTypeName, required, defaultValue, defaultValueNote, docComment.trim(), deprecated, secret, group, label, isEnum, enums);
                componentOptions.add(option);
            }
            TypeElement baseTypeElement = null;
            TypeMirror superclass = classElement.getSuperclass();
            if (superclass != null) {
                String superClassName = Strings.canonicalClassName(superclass.toString());
                baseTypeElement = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, superClassName);
            }
            if (baseTypeElement == null) break;
            classElement = baseTypeElement;
        }
    }

    protected void findClassProperties(PrintWriter writer, RoundEnvironment roundEnv, ComponentModel componentModel, Set<EndpointPath> endpointPaths, Set<EndpointOption> endpointOptions, TypeElement classElement, String prefix, String excludeProperties) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        while (true) {
            List<VariableElement> fieldElements = ElementFilter.fieldsIn(classElement.getEnclosedElements());
            for (VariableElement fieldElement : fieldElements) {
                boolean isEnum;
                String displayName;
                Metadata metadata = fieldElement.getAnnotation(Metadata.class);
                boolean deprecated = fieldElement.getAnnotation(Deprecated.class) != null;
                Boolean secret = metadata != null ? Boolean.valueOf(metadata.secret()) : null;
                UriPath path = fieldElement.getAnnotation(UriPath.class);
                String fieldName = fieldElement.getSimpleName().toString();
                if (path != null) {
                    boolean isEnum2;
                    String displayName2;
                    String name = path.name();
                    if (Strings.isNullOrEmpty(name)) {
                        name = fieldName;
                    }
                    if (EndpointAnnotationProcessor.excludeProperty(excludeProperties, name = prefix + name)) continue;
                    String defaultValue = path.defaultValue();
                    if (Strings.isNullOrEmpty(defaultValue) && metadata != null) {
                        defaultValue = metadata.defaultValue();
                    }
                    String defaultValueNote = path.defaultValueNote();
                    String required = metadata != null ? metadata.required() : null;
                    String label = path.label();
                    if (Strings.isNullOrEmpty(label) && metadata != null) {
                        label = metadata.label();
                    }
                    if (Strings.isNullOrEmpty(displayName2 = path.displayName())) {
                        displayName2 = metadata != null ? metadata.displayName() : null;
                    }
                    TypeMirror fieldType = fieldElement.asType();
                    String fieldTypeName = fieldType.toString();
                    TypeElement fieldTypeElement = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, fieldTypeName);
                    String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, false);
                    if (Strings.isNullOrEmpty(docComment)) {
                        docComment = path.description();
                    }
                    LinkedHashSet<String> enums = new LinkedHashSet<String>();
                    if (!Strings.isNullOrEmpty(path.enums())) {
                        String[] values;
                        isEnum2 = true;
                        for (String val : values = path.enums().split(",")) {
                            enums.add(val);
                        }
                    } else {
                        TypeElement enumClass;
                        boolean bl = isEnum2 = fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.ENUM;
                        if (isEnum2 && (enumClass = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, fieldTypeElement.asType().toString())) != null) {
                            List<VariableElement> fields = ElementFilter.fieldsIn(enumClass.getEnclosedElements());
                            for (VariableElement var : fields) {
                                if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                                String val = var.toString();
                                enums.add(val);
                            }
                        }
                    }
                    if (!Strings.isNullOrEmpty(path.javaType())) {
                        fieldTypeName = path.javaType();
                    }
                    String group = EndpointHelper.labelAsGroupName(label, componentModel.isConsumerOnly(), componentModel.isProducerOnly());
                    boolean isSecret = secret != null ? secret : false;
                    EndpointPath ep = new EndpointPath(name, displayName2, fieldTypeName, required, defaultValue, docComment, deprecated, isSecret, group, label, isEnum2, enums);
                    endpointPaths.add(ep);
                }
                UriParam param = fieldElement.getAnnotation(UriParam.class);
                fieldName = fieldElement.getSimpleName().toString();
                if (param == null) continue;
                String name = param.name();
                if (Strings.isNullOrEmpty(name)) {
                    name = fieldName;
                }
                if (EndpointAnnotationProcessor.excludeProperty(excludeProperties, name = prefix + name)) continue;
                String paramOptionalPrefix = param.optionalPrefix();
                String paramPrefix = param.prefix();
                boolean multiValue = param.multiValue();
                String defaultValue = param.defaultValue();
                if (defaultValue == null && metadata != null) {
                    defaultValue = metadata.defaultValue();
                }
                String defaultValueNote = param.defaultValueNote();
                String required = metadata != null ? metadata.required() : null;
                String label = param.label();
                if (Strings.isNullOrEmpty(label) && metadata != null) {
                    label = metadata.label();
                }
                if (Strings.isNullOrEmpty(displayName = param.displayName())) {
                    displayName = metadata != null ? metadata.displayName() : null;
                }
                TypeMirror fieldType = fieldElement.asType();
                String fieldTypeName = fieldType.toString();
                TypeElement fieldTypeElement = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, fieldTypeName);
                UriParams fieldParams = null;
                if (fieldTypeElement != null) {
                    fieldParams = fieldTypeElement.getAnnotation(UriParams.class);
                }
                if (fieldParams != null) {
                    String nestedPrefix = prefix;
                    String extraPrefix = fieldParams.prefix();
                    if (!Strings.isNullOrEmpty(extraPrefix)) {
                        nestedPrefix = nestedPrefix + extraPrefix;
                    }
                    this.findClassProperties(writer, roundEnv, componentModel, endpointPaths, endpointOptions, fieldTypeElement, nestedPrefix, excludeProperties);
                    continue;
                }
                String docComment = AnnotationProcessorHelper.findJavaDoc(elementUtils, fieldElement, fieldName, name, classElement, false);
                if (Strings.isNullOrEmpty(docComment)) {
                    docComment = param.description();
                }
                if (Strings.isNullOrEmpty(docComment)) {
                    docComment = "";
                }
                LinkedHashSet<String> enums = new LinkedHashSet<String>();
                if (!Strings.isNullOrEmpty(param.enums())) {
                    String[] values;
                    isEnum = true;
                    for (String val : values = param.enums().split(",")) {
                        enums.add(val);
                    }
                } else {
                    TypeElement enumClass;
                    boolean bl = isEnum = fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.ENUM;
                    if (isEnum && (enumClass = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, fieldTypeElement.asType().toString())) != null) {
                        List<VariableElement> fields = ElementFilter.fieldsIn(enumClass.getEnclosedElements());
                        for (VariableElement var : fields) {
                            String val;
                            if (var.getKind() != ElementKind.ENUM_CONSTANT) continue;
                            val = var.toString();
                            enums.add(val);
                        }
                    }
                }
                if (!Strings.isNullOrEmpty(param.javaType())) {
                    fieldTypeName = param.javaType();
                }
                boolean isSecret = secret != null ? secret.booleanValue() : param.secret();
                String group = EndpointHelper.labelAsGroupName(label, componentModel.isConsumerOnly(), componentModel.isProducerOnly());
                EndpointOption option = new EndpointOption(name, displayName, fieldTypeName, required, defaultValue, defaultValueNote, docComment.trim(), paramOptionalPrefix, paramPrefix, multiValue, deprecated, isSecret, group, label, isEnum, enums);
                endpointOptions.add(option);
            }
            TypeElement baseTypeElement = null;
            TypeMirror superclass = classElement.getSuperclass();
            if (superclass != null) {
                String superClassName = Strings.canonicalClassName(superclass.toString());
                baseTypeElement = AnnotationProcessorHelper.findTypeElement(this.processingEnv, roundEnv, superClassName);
            }
            if (baseTypeElement == null) break;
            classElement = baseTypeElement;
        }
    }

    private static boolean excludeProperty(String excludeProperties, String name) {
        String[] excludes;
        for (String exclude : excludes = excludeProperties.split(",")) {
            if (!name.equals(exclude)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String> parseAsMap(String data) {
        String[] lines;
        HashMap<String, String> answer = new HashMap<String, String>();
        for (String line : lines = data.split("\n")) {
            if (line.isEmpty()) continue;
            int idx = line.indexOf(61);
            String key = line.substring(0, idx);
            String value = line.substring(idx + 1);
            value = value.trim().replaceAll("\n", "");
            answer.put(key.trim(), value);
        }
        return answer;
    }

    private static boolean secureAlias(String scheme, String alias) {
        if (scheme.equals(alias)) {
            return false;
        }
        return (scheme + "s").equals(alias);
    }
}

