/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.cloud;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public interface ServiceHealth {

    /**
     * Gets a key/value metadata associated with the service.
     */
    default Map<String, String> getMetadata() {
        return Collections.EMPTY_MAP;
    }

    /**
     * States if the service is healthy or not
     */
    default boolean isHealthy() {
        return true;
    }

    /**
     * The health enpoint exposed by the service.
     */
    default Optional<URI> getEndpoint() {
        return Optional.empty();
    }
}
