/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleResolver;
import org.apache.camel.spi.FactoryFinder;

public class DefaultDevConsoleResolver
implements DevConsoleResolver,
CamelContextAware {
    public static final String DEV_CONSOLE_RESOURCE_PATH = "META-INF/services/org/apache/camel/dev-console/";
    protected FactoryFinder devConsoleFactory;
    private CamelContext camelContext;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public DevConsole resolveDevConsole(String id) {
        DevConsole answer = (DevConsole)this.camelContext.getRegistry().lookupByNameAndType(id + "-dev-console", DevConsole.class);
        if (answer == null) {
            answer = (DevConsole)this.camelContext.getRegistry().lookupByNameAndType(id, DevConsole.class);
        }
        if (answer != null) {
            return answer;
        }
        Class<?> type = null;
        try {
            type = this.findDevConsole(id, this.camelContext);
        }
        catch (NoFactoryAvailableException noFactoryAvailableException) {
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI, no DevConsole registered for id: " + id, e);
        }
        if (type != null) {
            if (DevConsole.class.isAssignableFrom(type)) {
                answer = (DevConsole)this.camelContext.getInjector().newInstance(type, false);
                CamelContextAware.trySetCamelContext((Object)answer, (CamelContext)this.camelContext);
            } else {
                throw new IllegalArgumentException("Resolving dev-console: " + id + " detected type conflict: Not a DevConsole implementation. Found: " + type.getName());
            }
        }
        return answer;
    }

    protected Class<?> findDevConsole(String name, CamelContext context) throws Exception {
        if (this.devConsoleFactory == null) {
            this.devConsoleFactory = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getFactoryFinder(DEV_CONSOLE_RESOURCE_PATH);
        }
        return this.devConsoleFactory.findOptionalClass(name).orElse(null);
    }
}

