/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExchangeConstantProvider;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.apache.camel.impl.engine.DefaultContextPluginManager;
import org.apache.camel.impl.engine.DefaultManagementStrategyFactory;
import org.apache.camel.impl.engine.ExplicitCamelContextNameStrategy;
import org.apache.camel.impl.engine.HashMapHeadersMapFactory;
import org.apache.camel.impl.engine.InternalRouteController;
import org.apache.camel.spi.BootstrapCloseable;
import org.apache.camel.spi.DebuggerFactory;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.ExchangeFactoryManager;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.ManagementMBeanAssembler;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.ManagementStrategyFactory;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.PluginManager;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.NormalizedUri;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultCamelContextExtension
implements ExtendedCamelContext {
    private final AbstractCamelContext camelContext;
    private final ThreadLocal<Boolean> isSetupRoutes = new ThreadLocal();
    private final List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    private final Map<String, FactoryFinder> factories = new ConcurrentHashMap<String, FactoryFinder>();
    private final Map<String, FactoryFinder> bootstrapFactories = new ConcurrentHashMap<String, FactoryFinder>();
    private final Set<LogListener> logListeners = new LinkedHashSet<LogListener>();
    private final PluginManager pluginManager = new DefaultContextPluginManager();
    private final RouteController internalRouteController;
    private final List<BootstrapCloseable> bootstraps = new CopyOnWriteArrayList<BootstrapCloseable>();
    private volatile String description;
    private volatile ExchangeFactory exchangeFactory;
    private volatile ExchangeFactoryManager exchangeFactoryManager;
    private volatile ProcessorExchangeFactory processorExchangeFactory;
    private volatile ReactiveExecutor reactiveExecutor;
    private volatile Registry registry;
    private volatile ManagementStrategy managementStrategy;
    private volatile ManagementMBeanAssembler managementMBeanAssembler;
    private volatile HeadersMapFactory headersMapFactory;
    private volatile boolean eventNotificationApplicable;
    @Deprecated
    private ErrorHandlerFactory errorHandlerFactory;
    private String basePackageScan;
    private final Object lock = new Object();
    private volatile FactoryFinder bootstrapFactoryFinder;

    public DefaultCamelContextExtension(AbstractCamelContext camelContext) {
        this.camelContext = camelContext;
        this.internalRouteController = new InternalRouteController(camelContext);
    }

    public byte getStatusPhase() {
        return this.camelContext.getStatusPhase();
    }

    public String getName() {
        return this.camelContext.getNameStrategy().getName();
    }

    public void setName(String name) {
        this.camelContext.setNameStrategy(new ExplicitCamelContextNameStrategy(name));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Endpoint hasEndpoint(NormalizedEndpointUri uri) {
        if (this.camelContext.getEndpointRegistry().isEmpty()) {
            return null;
        }
        return (Endpoint)this.camelContext.getEndpointRegistry().get((Object)uri);
    }

    public NormalizedEndpointUri normalizeUri(String uri) {
        try {
            uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders((CamelContext)this.camelContext, (String)uri);
            return NormalizedUri.newNormalizedUri((String)uri, (boolean)false);
        }
        catch (ResolveEndpointFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
    }

    public Endpoint getEndpoint(NormalizedEndpointUri uri) {
        return this.camelContext.doGetEndpoint(uri.getUri(), null, true, false);
    }

    public Endpoint getPrototypeEndpoint(String uri) {
        return this.camelContext.doGetEndpoint(uri, null, false, true);
    }

    public Endpoint getPrototypeEndpoint(NormalizedEndpointUri uri) {
        return this.camelContext.doGetEndpoint(uri.getUri(), null, true, true);
    }

    public Endpoint getEndpoint(NormalizedEndpointUri uri, Map<String, Object> parameters) {
        return this.camelContext.doGetEndpoint(uri.getUri(), parameters, true, false);
    }

    public void registerEndpointCallback(EndpointStrategy strategy) {
        if (!this.camelContext.getEndpointStrategies().contains(strategy)) {
            this.camelContext.getEndpointStrategies().add(strategy);
            for (Endpoint endpoint : this.camelContext.getEndpoints()) {
                Endpoint newEndpoint = strategy.registerEndpoint(endpoint.getEndpointUri(), endpoint);
                if (newEndpoint == null) continue;
                this.camelContext.getEndpointRegistry().put((Object)this.camelContext.getEndpointKey(endpoint.getEndpointUri()), (Object)newEndpoint);
            }
        }
    }

    public List<RouteStartupOrder> getRouteStartupOrder() {
        return this.camelContext.getRouteStartupOrder();
    }

    public boolean isSetupRoutes() {
        Boolean answer = this.isSetupRoutes.get();
        return answer != null && answer != false;
    }

    public void addBootstrap(BootstrapCloseable bootstrap) {
        this.bootstraps.add(bootstrap);
    }

    void closeBootstraps() {
        for (BootstrapCloseable bootstrap : this.bootstraps) {
            try {
                bootstrap.close();
            }
            catch (Exception e) {
                this.logger().warn("Error during closing bootstrap. This exception is ignored.", (Throwable)e);
            }
        }
        this.bootstraps.clear();
    }

    List<BootstrapCloseable> getBootstraps() {
        return this.bootstraps;
    }

    public List<Service> getServices() {
        return this.camelContext.getInternalServiceManager().getServices();
    }

    public String resolvePropertyPlaceholders(String text, boolean keepUnresolvedOptional) {
        if (text != null && text.contains("{{")) {
            String answer = this.camelContext.getPropertiesComponent().parseUri(text, keepUnresolvedOptional);
            this.logger().debug("Resolved text: {} -> {}", (Object)text, (Object)answer);
            return answer;
        }
        if (text != null && text.startsWith("Exchange.")) {
            String field = StringHelper.after((String)text, (String)"Exchange.");
            String constant = ExchangeConstantProvider.lookup((String)field);
            if (constant != null) {
                this.logger().debug("Resolved constant: {} -> {}", (Object)text, (Object)constant);
                return constant;
            }
            throw new IllegalArgumentException("Constant field with name: " + field + " not found on Exchange.class");
        }
        return text;
    }

    public ManagementMBeanAssembler getManagementMBeanAssembler() {
        return this.managementMBeanAssembler;
    }

    void setManagementMBeanAssembler(ManagementMBeanAssembler managementMBeanAssembler) {
        this.managementMBeanAssembler = this.camelContext.getInternalServiceManager().addService(managementMBeanAssembler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registry getRegistry() {
        if (this.registry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.registry == null) {
                    this.setRegistry(this.camelContext.createRegistry());
                }
            }
        }
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        CamelContextAware.trySetCamelContext((Object)registry, (CamelContext)this.camelContext);
        this.registry = registry;
    }

    public void setupRoutes(boolean done) {
        if (done) {
            this.isSetupRoutes.remove();
        } else {
            this.isSetupRoutes.set(true);
        }
    }

    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void addInterceptStrategy(InterceptStrategy interceptStrategy) {
        if (!this.interceptStrategies.contains(interceptStrategy)) {
            this.interceptStrategies.add(interceptStrategy);
        }
    }

    public Set<LogListener> getLogListeners() {
        return this.logListeners;
    }

    public void addLogListener(LogListener listener) {
        this.logListeners.add(listener);
    }

    public ErrorHandlerFactory getErrorHandlerFactory() {
        return this.errorHandlerFactory;
    }

    public void setErrorHandlerFactory(ErrorHandlerFactory errorHandlerFactory) {
        this.errorHandlerFactory = errorHandlerFactory;
    }

    public boolean isEventNotificationApplicable() {
        return this.eventNotificationApplicable;
    }

    public void setEventNotificationApplicable(boolean eventNotificationApplicable) {
        this.eventNotificationApplicable = eventNotificationApplicable;
    }

    public FactoryFinder getDefaultFactoryFinder() {
        return this.getFactoryFinder("META-INF/services/org/apache/camel/");
    }

    public void setDefaultFactoryFinder(FactoryFinder factoryFinder) {
        this.factories.put("META-INF/services/org/apache/camel/", factoryFinder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FactoryFinder getBootstrapFactoryFinder() {
        if (this.bootstrapFactoryFinder == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.bootstrapFactoryFinder == null) {
                    this.bootstrapFactoryFinder = PluginHelper.getFactoryFinderResolver((ExtendedCamelContext)this).resolveBootstrapFactoryFinder(this.camelContext.getClassResolver());
                }
            }
        }
        return this.bootstrapFactoryFinder;
    }

    public void setBootstrapFactoryFinder(FactoryFinder factoryFinder) {
        this.bootstrapFactoryFinder = factoryFinder;
    }

    public FactoryFinder getBootstrapFactoryFinder(String path) {
        return this.bootstrapFactories.computeIfAbsent(path, this.camelContext::createBootstrapFactoryFinder);
    }

    public FactoryFinder getFactoryFinder(String path) {
        return this.factories.computeIfAbsent(path, this.camelContext::createFactoryFinder);
    }

    public void setupManagement(Map<String, Object> options) {
        this.logger().trace("Setting up management");
        DefaultManagementStrategyFactory factory = null;
        if (!this.camelContext.isJMXDisabled()) {
            try {
                DebuggerFactory df;
                Object object;
                FactoryFinder finder = this.camelContext.createFactoryFinder("META-INF/services/org/apache/camel/management/");
                if (finder != null && (object = finder.newInstance("ManagementStrategyFactory").orElse(null)) instanceof ManagementStrategyFactory) {
                    factory = object;
                }
                if ((df = (DebuggerFactory)this.getBootstrapFactoryFinder().newInstance("debugger-factory", DebuggerFactory.class).orElse(null)) != null) {
                    this.logger().info("Detected: {} JAR (Enabling Camel Debugging)", (Object)df);
                    this.camelContext.enableDebugging(df);
                }
            }
            catch (Exception e) {
                this.logger().warn("Cannot create JmxManagementStrategyFactory. Will fallback and disable JMX.", (Throwable)e);
            }
        }
        if (factory == null) {
            factory = new DefaultManagementStrategyFactory();
        }
        this.logger().debug("Setting up management with factory: {}", (Object)factory);
        List notifiers = null;
        if (this.managementStrategy != null) {
            notifiers = this.managementStrategy.getEventNotifiers();
        }
        try {
            ManagementStrategy strategy = factory.create(this.camelContext.getCamelContextReference(), options);
            if (notifiers != null) {
                notifiers.forEach(arg_0 -> ((ManagementStrategy)strategy).addEventNotifier(arg_0));
            }
            LifecycleStrategy lifecycle = factory.createLifecycle(this.camelContext);
            factory.setupManagement(this.camelContext, strategy, lifecycle);
        }
        catch (Exception e) {
            this.logger().warn("Error setting up management due {}", (Object)e.getMessage());
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public String getBasePackageScan() {
        return this.basePackageScan;
    }

    public void setBasePackageScan(String basePackageScan) {
        this.basePackageScan = basePackageScan;
    }

    public HeadersMapFactory getHeadersMapFactory() {
        return this.headersMapFactory;
    }

    public void setHeadersMapFactory(HeadersMapFactory headersMapFactory) {
        this.headersMapFactory = this.camelContext.getInternalServiceManager().addService(headersMapFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initEagerMandatoryServices(boolean caseInsensitive, Supplier<HeadersMapFactory> headersMapFactorySupplier) {
        if (this.headersMapFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.headersMapFactory == null) {
                    if (caseInsensitive) {
                        this.setHeadersMapFactory(headersMapFactorySupplier.get());
                    } else {
                        this.setHeadersMapFactory(new HashMapHeadersMapFactory());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExchangeFactory getExchangeFactory() {
        if (this.exchangeFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.exchangeFactory == null) {
                    this.setExchangeFactory(this.camelContext.createExchangeFactory());
                }
            }
        }
        return this.exchangeFactory;
    }

    public void setExchangeFactory(ExchangeFactory exchangeFactory) {
        exchangeFactory.setCamelContext((CamelContext)this.camelContext);
        this.exchangeFactory = exchangeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExchangeFactoryManager getExchangeFactoryManager() {
        if (this.exchangeFactoryManager == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.exchangeFactoryManager == null) {
                    this.setExchangeFactoryManager(this.camelContext.createExchangeFactoryManager());
                }
            }
        }
        return this.exchangeFactoryManager;
    }

    public void setExchangeFactoryManager(ExchangeFactoryManager exchangeFactoryManager) {
        this.exchangeFactoryManager = this.camelContext.getInternalServiceManager().addService(exchangeFactoryManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessorExchangeFactory getProcessorExchangeFactory() {
        if (this.processorExchangeFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.processorExchangeFactory == null) {
                    this.setProcessorExchangeFactory(this.camelContext.createProcessorExchangeFactory());
                }
            }
        }
        return this.processorExchangeFactory;
    }

    public void setProcessorExchangeFactory(ProcessorExchangeFactory processorExchangeFactory) {
        processorExchangeFactory.setCamelContext((CamelContext)this.camelContext);
        this.processorExchangeFactory = processorExchangeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReactiveExecutor getReactiveExecutor() {
        if (this.reactiveExecutor == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.reactiveExecutor == null) {
                    this.setReactiveExecutor(this.camelContext.createReactiveExecutor());
                }
            }
        }
        return this.reactiveExecutor;
    }

    public void setReactiveExecutor(ReactiveExecutor reactiveExecutor) {
        this.reactiveExecutor = this.camelContext.getInternalServiceManager().addService(reactiveExecutor, false);
    }

    public RouteController getInternalRouteController() {
        return this.internalRouteController;
    }

    public EndpointUriFactory getEndpointUriFactory(String scheme) {
        return PluginHelper.getUriFactoryResolver((ExtendedCamelContext)this).resolveFactory(scheme, (CamelContext)this.camelContext);
    }

    public StartupStepRecorder getStartupStepRecorder() {
        return this.camelContext.startupStepRecorder;
    }

    public void setStartupStepRecorder(StartupStepRecorder startupStepRecorder) {
        this.camelContext.startupStepRecorder = startupStepRecorder;
    }

    public void addRoute(Route route) {
        this.camelContext.addRoute(route);
    }

    public void removeRoute(Route route) {
        this.camelContext.removeRoute(route);
    }

    public Processor createErrorHandler(Route route, Processor processor) throws Exception {
        return this.camelContext.createErrorHandler(route, processor);
    }

    public void disposeModel() {
        this.camelContext.disposeModel();
    }

    public String getTestExcludeRoutes() {
        return this.camelContext.getTestExcludeRoutes();
    }

    ManagementStrategy getManagementStrategy() {
        return this.managementStrategy;
    }

    void setManagementStrategy(ManagementStrategy managementStrategy) {
        this.managementStrategy = managementStrategy;
    }

    public <T> T getContextPlugin(Class<T> type) {
        Object ret = this.pluginManager.getContextPlugin(type);
        if (ret == null && type.isInstance((Object)this.camelContext)) {
            return type.cast((Object)this.camelContext);
        }
        return (T)ret;
    }

    public <T> void addContextPlugin(Class<T> type, T module) {
        T addedModule = this.camelContext.getInternalServiceManager().addService(module);
        this.pluginManager.addContextPlugin(type, addedModule);
    }

    public <T> void lazyAddContextPlugin(Class<T> type, Supplier<T> module) {
        this.pluginManager.lazyAddContextPlugin(type, () -> this.lazyInitAndAdd(module));
    }

    private <T> T lazyInitAndAdd(Supplier<T> supplier) {
        T module = supplier.get();
        return this.camelContext.getInternalServiceManager().addService(module);
    }

    private Logger logger() {
        class Holder {
            static final Logger LOG = LoggerFactory.getLogger(DefaultCamelContextExtension.class);

            Holder() {
            }
        }
        return Holder.LOG;
    }
}

