/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.tokenizer;

import org.apache.camel.Expression;
import org.apache.camel.IsSingleton;
import org.apache.camel.Predicate;
import org.apache.camel.spi.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Language(value="tokenize")
public class TokenizeLanguage
implements Language,
IsSingleton {
    private String token;
    private String endToken;
    private String inheritNamespaceTagName;
    private String headerName;
    private boolean regex;
    private boolean xml;
    private boolean includeTokens;
    private String group;
    private String groupDelimiter;
    private boolean skipFirst;

    public static Expression tokenize(String token) {
        return TokenizeLanguage.tokenize(token, false);
    }

    public static Expression tokenize(String token, boolean regex) {
        TokenizeLanguage language = new TokenizeLanguage();
        language.setToken(token);
        language.setRegex(regex);
        return language.createExpression(null);
    }

    public static Expression tokenize(String headerName, String token) {
        return TokenizeLanguage.tokenize(headerName, token, false);
    }

    public static Expression tokenize(String headerName, String token, boolean regex) {
        TokenizeLanguage language = new TokenizeLanguage();
        language.setHeaderName(headerName);
        language.setToken(token);
        language.setRegex(regex);
        return language.createExpression(null);
    }

    public static Expression tokenizePair(String startToken, String endToken, boolean includeTokens) {
        TokenizeLanguage language = new TokenizeLanguage();
        language.setToken(startToken);
        language.setEndToken(endToken);
        language.setIncludeTokens(includeTokens);
        return language.createExpression(null);
    }

    public static Expression tokenizeXML(String tagName, String inheritNamespaceTagName) {
        TokenizeLanguage language = new TokenizeLanguage();
        language.setToken(tagName);
        language.setInheritNamespaceTagName(inheritNamespaceTagName);
        language.setXml(true);
        return language.createExpression(null);
    }

    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression));
    }

    public Expression createExpression() {
        ObjectHelper.notNull((Object)this.token, (String)"token");
        if (this.endToken != null && this.inheritNamespaceTagName != null) {
            throw new IllegalArgumentException("Cannot have both xml and pair tokenizer enabled.");
        }
        if (this.isXml() && (this.endToken != null || this.includeTokens)) {
            throw new IllegalArgumentException("Cannot have both xml and pair tokenizer enabled.");
        }
        Expression answer = null;
        if (this.isXml()) {
            answer = ExpressionBuilder.tokenizeXMLExpression((String)this.token, (String)this.inheritNamespaceTagName);
        } else if (this.endToken != null) {
            answer = ExpressionBuilder.tokenizePairExpression((String)this.token, (String)this.endToken, (boolean)this.includeTokens);
        }
        if (answer == null) {
            Expression exp = this.headerName == null ? ExpressionBuilder.bodyExpression() : ExpressionBuilder.headerExpression((String)this.headerName);
            answer = this.regex ? ExpressionBuilder.regexTokenizeExpression((Expression)exp, (String)this.token) : ExpressionBuilder.tokenizeExpression((Expression)exp, (String)this.token);
            if (this.group == null && this.skipFirst) {
                answer = ExpressionBuilder.skipFirstExpression((Expression)answer);
            }
        }
        if (this.group != null) {
            if (this.isXml()) {
                answer = ExpressionBuilder.groupXmlIteratorExpression((Expression)answer, (String)this.group);
            } else {
                String delim = this.groupDelimiter != null ? this.groupDelimiter : this.token;
                answer = ExpressionBuilder.groupIteratorExpression((Expression)answer, (String)delim, (String)this.group, (boolean)this.skipFirst);
            }
        }
        return answer;
    }

    public Expression createExpression(String expression) {
        if (ObjectHelper.isNotEmpty((Object)expression)) {
            this.token = expression;
        }
        return this.createExpression();
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getEndToken() {
        return this.endToken;
    }

    public void setEndToken(String endToken) {
        this.endToken = endToken;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public boolean isRegex() {
        return this.regex;
    }

    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    public String getInheritNamespaceTagName() {
        return this.inheritNamespaceTagName;
    }

    public void setInheritNamespaceTagName(String inheritNamespaceTagName) {
        this.inheritNamespaceTagName = inheritNamespaceTagName;
    }

    public boolean isXml() {
        return this.xml;
    }

    public void setXml(boolean xml) {
        this.xml = xml;
    }

    public boolean isIncludeTokens() {
        return this.includeTokens;
    }

    public void setIncludeTokens(boolean includeTokens) {
        this.includeTokens = includeTokens;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroupDelimiter() {
        return this.groupDelimiter;
    }

    public void setGroupDelimiter(String groupDelimiter) {
        this.groupDelimiter = groupDelimiter;
    }

    public boolean isSkipFirst() {
        return this.skipFirst;
    }

    public void setSkipFirst(boolean skipFirst) {
        this.skipFirst = skipFirst;
    }

    public boolean isSingleton() {
        return false;
    }
}

