/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.event;

import org.apache.camel.Exchange;
import org.apache.camel.impl.event.AbstractExchangeEvent;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.util.TimeUtils;

public class ExchangeCompletedEvent
extends AbstractExchangeEvent
implements CamelEvent.ExchangeCompletedEvent {
    private static final long serialVersionUID = -3231801412021356098L;
    private final long timeTaken;

    public ExchangeCompletedEvent(Exchange source) {
        super(source);
        long created = this.getExchange().getCreated();
        this.timeTaken = created > 0L ? System.currentTimeMillis() - created : -1L;
    }

    @Override
    public String toString() {
        if (this.timeTaken > -1L) {
            return this.getExchange().getExchangeId() + " exchange completed took: " + TimeUtils.printDuration((long)this.timeTaken, (boolean)true);
        }
        return this.getExchange().getExchangeId() + " exchange completed";
    }
}

