/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.time.Duration;
import org.apache.camel.Converter;
import org.apache.camel.util.TimeUtils;

@Converter(generateLoader=true)
public final class DurationConverter {
    private DurationConverter() {
    }

    @Converter
    public static Long toMilliSeconds(Duration source) {
        return source.toMillis();
    }

    @Converter
    public static Duration toDuration(Long source) {
        return Duration.ofMillis(source);
    }

    @Converter
    public static Duration toDuration(String source) {
        if (source.startsWith("P") || source.startsWith("-P") || source.startsWith("p") || source.startsWith("-p")) {
            return Duration.parse(source);
        }
        return Duration.ofMillis(TimeUtils.toMilliSeconds((String)source));
    }

    @Converter
    public static String toString(Duration source) {
        return source.toString();
    }
}

