/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.BeanScope;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.AbstractBeanProcessor;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.ParameterMappingStrategyHelper;
import org.apache.camel.spi.ErrorHandlerAware;
import org.apache.camel.support.service.ServiceSupport;

public class BeanProcessor
extends ServiceSupport
implements AsyncProcessor,
ErrorHandlerAware {
    private final DelegateBeanProcessor delegate;

    public BeanProcessor(Object pojo, CamelContext camelContext) {
        this(new ConstantBeanHolder(pojo, camelContext, ParameterMappingStrategyHelper.createParameterMappingStrategy(camelContext), (BeanComponent)camelContext.getComponent("bean", BeanComponent.class)));
    }

    public BeanProcessor(Object pojo, BeanInfo beanInfo) {
        this.delegate = new DelegateBeanProcessor(pojo, beanInfo);
    }

    public BeanProcessor(BeanHolder beanHolder) {
        this.delegate = new DelegateBeanProcessor(beanHolder);
    }

    public Processor getErrorHandler() {
        return null;
    }

    public void setErrorHandler(Processor errorHandler) {
        BeanHolder holder = this.delegate.getBeanHolder();
        if (holder != null) {
            holder.setErrorHandler(errorHandler);
        }
    }

    public void process(Exchange exchange) throws Exception {
        this.delegate.process(exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.delegate.process(exchange, callback);
    }

    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        return this.delegate.processAsync(exchange);
    }

    public Processor getProcessor() {
        return this.delegate.getProcessor();
    }

    public BeanHolder getBeanHolder() {
        return this.delegate.getBeanHolder();
    }

    public Object getBean() {
        return this.delegate.getBean();
    }

    public String getMethod() {
        return this.delegate.getMethod();
    }

    public void setMethod(String method) {
        this.delegate.setMethod(method);
    }

    public BeanScope getScope() {
        return this.delegate.getScope();
    }

    public void setScope(BeanScope scope) {
        this.delegate.setScope(scope);
    }

    public boolean isShorthandMethod() {
        return this.delegate.isShorthandMethod();
    }

    public void setShorthandMethod(boolean shorthandMethod) {
        this.delegate.setShorthandMethod(shorthandMethod);
    }

    protected void doStart() throws Exception {
        this.delegate.doStart();
    }

    protected void doStop() throws Exception {
        this.delegate.doStop();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private static final class DelegateBeanProcessor
    extends AbstractBeanProcessor {
        public DelegateBeanProcessor(Object pojo, BeanInfo beanInfo) {
            super(pojo, beanInfo);
        }

        public DelegateBeanProcessor(BeanHolder beanHolder) {
            super(beanHolder);
        }
    }
}

