/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.camel.dataformat.bindy.format.AbstractNumberFormat;

public class DoubleFormat
extends AbstractNumberFormat<Double> {
    public DoubleFormat(boolean impliedDecimalPosition, int precision, Locale locale) {
        super(impliedDecimalPosition, precision, locale);
    }

    @Override
    public String format(Double object) throws Exception {
        return !super.hasImpliedDecimalPosition() ? super.getFormat().format(object) : super.getFormat().format(object * super.getMultiplier());
    }

    @Override
    public Double parse(String string) throws Exception {
        Double value = null;
        if (!super.hasImpliedDecimalPosition()) {
            value = Double.parseDouble(string.trim());
        } else {
            BigDecimal tmp = new BigDecimal(string.trim());
            BigDecimal div = BigDecimal.valueOf(super.getMultiplier());
            value = tmp.divide(div).doubleValue();
        }
        return value;
    }
}

