/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.fixed;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.bindy.BindyAbstractDataFormat;
import org.apache.camel.dataformat.bindy.BindyAbstractFactory;
import org.apache.camel.dataformat.bindy.BindyFixedLengthFactory;
import org.apache.camel.dataformat.bindy.util.ConverterUtils;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindyFixedLengthDataFormat
extends BindyAbstractDataFormat {
    public static final String CAMEL_BINDY_FIXED_LENGTH_HEADER = "CamelBindyFixedLengthHeader";
    public static final String CAMEL_BINDY_FIXED_LENGTH_FOOTER = "CamelBindyFixedLengthFooter";
    private static final Logger LOG = LoggerFactory.getLogger(BindyFixedLengthDataFormat.class);
    private BindyFixedLengthFactory headerFactory;
    private BindyFixedLengthFactory footerFactory;

    public BindyFixedLengthDataFormat() {
    }

    public BindyFixedLengthDataFormat(Class<?> type) {
        super(type);
    }

    public String getDataFormatName() {
        return "bindy-fixed";
    }

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        Map footerRow;
        Map headerRow;
        ArrayList<Map> models;
        BindyFixedLengthFactory factory = (BindyFixedLengthFactory)this.getFactory();
        ObjectHelper.notNull((Object)factory, (String)"not instantiated");
        byte[] bytesCRLF = ConverterUtils.getByteReturn(factory.getCarriageReturn());
        if (!this.isPreparedList(body)) {
            models = new ArrayList<Map>();
            Iterator it = ObjectHelper.createIterator((Object)body);
            while (it.hasNext()) {
                Object model = it.next();
                String name = model.getClass().getName();
                HashMap row = new HashMap();
                row.put(name, model);
                models.add(row);
            }
        } else {
            models = (ArrayList<Map>)body;
        }
        if ((headerRow = (Map)exchange.getIn().getHeader(CAMEL_BINDY_FIXED_LENGTH_HEADER)) != null) {
            models.add(0, headerRow);
        }
        if ((footerRow = (Map)exchange.getIn().getHeader(CAMEL_BINDY_FIXED_LENGTH_FOOTER)) != null) {
            models.add(models.size(), footerRow);
        }
        int row = 0;
        for (Map model : models) {
            Set<String> modelClassNames;
            String result = null;
            if (++row == 1 && this.headerFactory != null) {
                modelClassNames = model.keySet();
                if (this.headerFactory.supportsModel(modelClassNames)) {
                    if (factory.skipHeader()) {
                        LOG.info("Skipping marshal of header row; 'skipHeader=true'");
                        continue;
                    }
                    result = this.headerFactory.unbind(model);
                }
            } else if (row == models.size() && this.footerFactory != null && this.footerFactory.supportsModel(modelClassNames = model.keySet())) {
                if (factory.skipFooter()) {
                    LOG.info("Skipping marshal of footer row; 'skipFooter=true'");
                    continue;
                }
                result = this.footerFactory.unbind(model);
            }
            if (result == null) {
                result = factory.unbind(model);
            }
            byte[] bytes = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)result);
            outputStream.write(bytes);
            outputStream.write(bytesCRLF);
        }
    }

    private boolean isPreparedList(Object object) {
        Map map;
        Object entry;
        List list;
        return List.class.isAssignableFrom(object.getClass()) && (list = (List)object).size() > 0 && Map.class.isAssignableFrom((entry = list.get(0)).getClass()) && (map = (Map)entry).size() == 1 && map.keySet().toArray()[0] instanceof String;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        BindyFixedLengthFactory factory = (BindyFixedLengthFactory)this.getFactory();
        ObjectHelper.notNull((Object)factory, (String)"not instantiated");
        ArrayList<Map<String, Object>> models = new ArrayList<Map<String, Object>>();
        InputStreamReader in = new InputStreamReader(inputStream, IOHelper.getCharsetName((Exchange)exchange));
        Scanner scanner = new Scanner(in);
        AtomicInteger count = new AtomicInteger(0);
        try {
            Map<String, Object> model;
            if (scanner.hasNextLine() && factory.hasHeader()) {
                String line = this.getNextNonEmptyLine(scanner, count);
                if (!factory.skipHeader()) {
                    Map<String, Object> headerObjMap = this.createModel(this.headerFactory, line, count.intValue());
                    exchange.getOut().setHeader(CAMEL_BINDY_FIXED_LENGTH_HEADER, headerObjMap);
                }
            }
            String thisLine = this.getNextNonEmptyLine(scanner, count);
            String nextLine = null;
            if (thisLine != null) {
                nextLine = this.getNextNonEmptyLine(scanner, count);
            }
            while (thisLine != null && nextLine != null) {
                model = this.createModel(factory, thisLine, count.intValue());
                models.add(model);
                thisLine = nextLine;
                nextLine = this.getNextNonEmptyLine(scanner, count);
            }
            if (thisLine != null) {
                if (factory.hasFooter()) {
                    if (!factory.skipFooter()) {
                        Map<String, Object> footerObjMap = this.createModel(this.footerFactory, thisLine, count.intValue());
                        exchange.getOut().setHeader(CAMEL_BINDY_FIXED_LENGTH_FOOTER, footerObjMap);
                    }
                } else {
                    model = this.createModel(factory, thisLine, count.intValue());
                    models.add(model);
                }
            }
            if (models.size() == 0) {
                throw new IllegalArgumentException("No records have been defined in the the file");
            }
            Object object = this.extractUnmarshalResult(models);
            return object;
        }
        finally {
            scanner.close();
            IOHelper.close((Closeable)in, (String)"in", (Logger)LOG);
        }
    }

    private String getNextNonEmptyLine(Scanner scanner, AtomicInteger count) {
        String line = "";
        while (ObjectHelper.isEmpty((Object)line) && scanner.hasNextLine()) {
            count.incrementAndGet();
            line = scanner.nextLine();
        }
        if (ObjectHelper.isEmpty((Object)line)) {
            return null;
        }
        return line;
    }

    protected Map<String, Object> createModel(BindyFixedLengthFactory factory, String line, int count) throws Exception {
        if (factory.recordLength() > 0 && (line.length() < factory.recordLength() || line.length() > factory.recordLength())) {
            throw new IllegalArgumentException("Size of the record: " + line.length() + " is not equal to the value provided in the model: " + factory.recordLength());
        }
        Map<String, Object> model = factory.factory();
        factory.bind(line, model, count);
        factory.link(model);
        LOG.debug("Graph of objects created: {}", model);
        return model;
    }

    @Override
    protected BindyAbstractFactory createModelFactory() throws Exception {
        BindyFixedLengthFactory factory = new BindyFixedLengthFactory(this.getClassType());
        if (factory.hasHeader()) {
            this.headerFactory = new BindyFixedLengthFactory(factory.header());
        }
        if (factory.hasFooter()) {
            this.footerFactory = new BindyFixedLengthFactory(factory.footer());
        }
        return factory;
    }
}

