/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.format.BigDecimalFormat;
import org.apache.camel.dataformat.bindy.format.BigIntegerFormat;
import org.apache.camel.dataformat.bindy.format.ByteFormat;
import org.apache.camel.dataformat.bindy.format.BytePatternFormat;
import org.apache.camel.dataformat.bindy.format.CharacterFormat;
import org.apache.camel.dataformat.bindy.format.DatePatternFormat;
import org.apache.camel.dataformat.bindy.format.DoubleFormat;
import org.apache.camel.dataformat.bindy.format.DoublePatternFormat;
import org.apache.camel.dataformat.bindy.format.FloatFormat;
import org.apache.camel.dataformat.bindy.format.FloatPatternFormat;
import org.apache.camel.dataformat.bindy.format.IntegerFormat;
import org.apache.camel.dataformat.bindy.format.IntegerPatternFormat;
import org.apache.camel.dataformat.bindy.format.LongFormat;
import org.apache.camel.dataformat.bindy.format.LongPatternFormat;
import org.apache.camel.dataformat.bindy.format.ShortFormat;
import org.apache.camel.dataformat.bindy.format.ShortPatternFormat;
import org.apache.camel.dataformat.bindy.format.StringFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormatFactory {
    private FormatFactory() {
    }

    public static Format<?> getFormat(Class<?> clazz, String pattern, int precision) throws Exception {
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return pattern != null ? new BytePatternFormat(pattern) : new ByteFormat();
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return pattern != null ? new ShortPatternFormat(pattern) : new ShortFormat();
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return pattern != null ? new IntegerPatternFormat(pattern) : new IntegerFormat();
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return pattern != null ? new LongPatternFormat(pattern) : new LongFormat();
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return pattern != null ? new FloatPatternFormat(pattern) : new FloatFormat();
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return pattern != null ? new DoublePatternFormat(pattern) : new DoubleFormat();
        }
        if (clazz == BigDecimal.class) {
            return new BigDecimalFormat(precision);
        }
        if (clazz == BigInteger.class) {
            return new BigIntegerFormat();
        }
        if (clazz == String.class) {
            return new StringFormat();
        }
        if (clazz == Date.class) {
            return new DatePatternFormat(pattern);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return new CharacterFormat();
        }
        throw new IllegalArgumentException("Can not find a suitable formatter for the type: " + clazz.getCanonicalName());
    }
}

