/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import org.apache.camel.CamelContext;
import org.apache.camel.core.osgi.OsgiDataFormatResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class BlueprintDataFormatResolver
extends OsgiDataFormatResolver {
    private static final transient Log LOG = LogFactory.getLog(BlueprintDataFormatResolver.class);

    public BlueprintDataFormatResolver(BundleContext bundleContext) {
        super(bundleContext);
    }

    public DataFormat resolveDataFormat(String name, CamelContext context) {
        try {
            Object bean = context.getRegistry().lookup(".camelBlueprint.dataformatResolver." + name);
            if (bean instanceof DataFormatResolver) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found dataformat resolver: " + name + " in registry: " + bean));
                }
                return ((DataFormatResolver)bean).resolveDataFormat(name, context);
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Ignored error looking up bean: " + name + ". Error: " + e));
        }
        return super.resolveDataFormat(name, context);
    }
}

