/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.CamelContext;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.builder.xml.TimeUnitAdapter;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.util.CamelContextHelper;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelThreadPoolFactoryBean
extends AbstractCamelFactoryBean<ExecutorService> {
    @XmlAttribute(required=true)
    private String poolSize;
    @XmlAttribute
    private String maxPoolSize;
    @XmlAttribute
    private String keepAliveTime;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=TimeUnitAdapter.class)
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    @XmlAttribute
    private String maxQueueSize;
    @XmlAttribute
    private ThreadPoolRejectedPolicy rejectedPolicy = ThreadPoolRejectedPolicy.CallerRuns;
    @XmlAttribute(required=true)
    private String threadName;

    @Override
    public ExecutorService getObject() throws Exception {
        int size = CamelContextHelper.parseInteger((CamelContext)this.getCamelContext(), (String)this.poolSize);
        if (size <= 0) {
            throw new IllegalArgumentException("PoolSize must be a positive number");
        }
        int max = size;
        if (this.maxPoolSize != null) {
            max = CamelContextHelper.parseInteger((CamelContext)this.getCamelContext(), (String)this.maxPoolSize);
        }
        RejectedExecutionHandler rejected = null;
        if (this.rejectedPolicy != null) {
            rejected = this.rejectedPolicy.asRejectedExecutionHandler();
        }
        long keepAlive = 60L;
        if (this.keepAliveTime != null) {
            keepAlive = CamelContextHelper.parseLong((CamelContext)this.getCamelContext(), (String)this.keepAliveTime);
        }
        int queueSize = -1;
        if (this.maxQueueSize != null) {
            queueSize = CamelContextHelper.parseInteger((CamelContext)this.getCamelContext(), (String)this.keepAliveTime);
        }
        ExecutorService answer = this.getCamelContext().getExecutorServiceStrategy().newThreadPool((Object)this.getId(), this.getThreadName(), size, max, keepAlive, this.getTimeUnit(), queueSize, rejected, true);
        return answer;
    }

    @Override
    protected abstract CamelContext getCamelContextWithId(String var1);

    @Override
    public Class<ExecutorService> getObjectType() {
        return ExecutorService.class;
    }

    public String getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(String poolSize) {
        this.poolSize = poolSize;
    }

    public String getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public String getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(String keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(String maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public ThreadPoolRejectedPolicy getRejectedPolicy() {
        return this.rejectedPolicy;
    }

    public void setRejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.rejectedPolicy = rejectedPolicy;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }
}

