/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.InputStream;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.VersionManager;

public class DefaultVersionManager
implements VersionManager {
    private final CamelCatalog camelCatalog;
    private ClassLoader classLoader;

    public DefaultVersionManager(CamelCatalog camelCatalog) {
        this.camelCatalog = camelCatalog;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String getLoadedVersion() {
        return this.camelCatalog.getCatalogVersion();
    }

    @Override
    public boolean loadVersion(String version) {
        return this.getLoadedVersion().equals(version);
    }

    @Override
    public String getRuntimeProviderLoadedVersion() {
        return null;
    }

    @Override
    public boolean loadRuntimeProviderVersion(String groupId, String artifactId, String version) {
        return false;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = null;
        if (this.classLoader != null) {
            is = this.classLoader.getResourceAsStream(name);
        }
        if (is == null) {
            is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(name);
        }
        return is;
    }
}

