/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Producer;
import org.apache.camel.CamelContext;
import org.apache.camel.cdi.CamelContextInjectionTarget;
import org.apache.camel.cdi.CamelContextOsgiProducer;
import org.apache.camel.cdi.CamelContextProducer;
import org.apache.camel.cdi.CdiCamelExtension;
import org.apache.camel.cdi.Vetoed;
import org.apache.camel.core.osgi.utils.BundleContextUtils;

@Vetoed
final class CdiCamelEnvironment {
    private final boolean hasBundleContext = CdiCamelEnvironment.isCamelCoreOsgiPresent() && CdiCamelEnvironment.hasBundleContext(CdiCamelExtension.class);

    CdiCamelEnvironment() {
    }

    <T extends CamelContext> Producer<T> camelContextProducer(Producer<T> delegate, Annotated annotated, BeanManager manager, CdiCamelExtension extension) {
        CamelContextProducer<T> producer = new CamelContextProducer<T>(delegate, annotated, manager, extension);
        return this.hasBundleContext ? new CamelContextOsgiProducer<T>(producer) : producer;
    }

    <T extends CamelContext> InjectionTarget<T> camelContextInjectionTarget(InjectionTarget<T> delegate, Annotated annotated, BeanManager manager, CdiCamelExtension extension) {
        CamelContextProducer<T> producer = new CamelContextProducer<T>(delegate, annotated, manager, extension);
        return new CamelContextInjectionTarget<T>(delegate, this.hasBundleContext ? new CamelContextOsgiProducer<T>(producer) : producer);
    }

    private static boolean isCamelCoreOsgiPresent() {
        try {
            CdiCamelEnvironment.getClassLoader(CdiCamelExtension.class).loadClass("org.apache.camel.core.osgi.OsgiCamelContextHelper");
            return true;
        }
        catch (ClassNotFoundException cause) {
            return false;
        }
    }

    private static boolean hasBundleContext(Class clazz) {
        return BundleContextUtils.getBundleContext((Class)clazz) != null;
    }

    private static ClassLoader getClassLoader(Class<?> clazz) {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return clazz.getClassLoader();
    }
}

