/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.HashSet;
import java.util.Optional;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.TypeConverter;
import org.apache.camel.cdi.CdiCamelExtension;
import org.apache.camel.cdi.CdiEventEndpoint;
import org.apache.camel.cdi.CdiSpiHelper;
import org.apache.camel.cdi.DefaultLiteral;
import org.apache.camel.cdi.Mock;
import org.apache.camel.cdi.Uri;
import org.apache.camel.component.mock.MockEndpoint;

final class CdiCamelFactory {
    CdiCamelFactory() {
    }

    @Produces
    private static TypeConverter typeConverter(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        return CdiCamelFactory.selectContext(ip, instance, extension).getTypeConverter();
    }

    @Produces
    private static ConsumerTemplate consumerTemplate(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        return CdiCamelFactory.selectContext(ip, instance, extension).createConsumerTemplate();
    }

    @Produces
    @Default
    @Uri(value="")
    private static ProducerTemplate producerTemplate(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        return CdiCamelFactory.getQualifierByType(ip, Uri.class).map(uri -> CdiCamelFactory.producerTemplateFromUri(ip, instance, extension, uri)).orElseGet(() -> CdiCamelFactory.defaultProducerTemplate(ip, instance, extension));
    }

    private static ProducerTemplate producerTemplateFromUri(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension, Uri uri) {
        try {
            CamelContext context = uri.context().isEmpty() ? CdiCamelFactory.selectContext(ip, instance, extension) : CdiCamelFactory.selectContext(uri.context(), instance);
            ProducerTemplate producerTemplate = context.createProducerTemplate();
            Endpoint endpoint = context.getEndpoint(uri.value(), Endpoint.class);
            producerTemplate.setDefaultEndpoint(endpoint);
            return producerTemplate;
        }
        catch (Exception cause) {
            throw new InjectionException("Error injecting producer template annotated with " + uri + " into " + ip, (Throwable)cause);
        }
    }

    private static ProducerTemplate defaultProducerTemplate(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        try {
            CamelContext context = CdiCamelFactory.selectContext(ip, instance, extension);
            return context.createProducerTemplate();
        }
        catch (Exception cause) {
            throw new InjectionException("Error injecting producer template into " + ip, (Throwable)cause);
        }
    }

    @Produces
    @Default
    @Uri(value="")
    private static FluentProducerTemplate fluentProducerTemplate(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        return CdiCamelFactory.getQualifierByType(ip, Uri.class).map(uri -> CdiCamelFactory.fluentProducerTemplateFromUri(ip, instance, extension, uri)).orElseGet(() -> CdiCamelFactory.defaultFluentProducerTemplate(ip, instance, extension));
    }

    private static FluentProducerTemplate fluentProducerTemplateFromUri(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension, Uri uri) {
        try {
            CamelContext context = uri.context().isEmpty() ? CdiCamelFactory.selectContext(ip, instance, extension) : CdiCamelFactory.selectContext(uri.context(), instance);
            FluentProducerTemplate producerTemplate = context.createFluentProducerTemplate();
            Endpoint endpoint = context.getEndpoint(uri.value(), Endpoint.class);
            producerTemplate.setDefaultEndpoint(endpoint);
            return producerTemplate;
        }
        catch (Exception cause) {
            throw new InjectionException("Error injecting fluent producer template annotated with " + uri + " into " + ip, (Throwable)cause);
        }
    }

    private static FluentProducerTemplate defaultFluentProducerTemplate(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        try {
            CamelContext context = CdiCamelFactory.selectContext(ip, instance, extension);
            return context.createFluentProducerTemplate();
        }
        catch (Exception cause) {
            throw new InjectionException("Error injecting fluent producer template into " + ip, (Throwable)cause);
        }
    }

    @Produces
    @Typed(value={MockEndpoint.class})
    private static MockEndpoint mockEndpointFromMember(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        String uri = "mock:" + ip.getMember().getName();
        try {
            return (MockEndpoint)CdiCamelFactory.selectContext(ip, instance, extension).getEndpoint(uri, MockEndpoint.class);
        }
        catch (Exception cause) {
            throw new InjectionException("Error injecting mock endpoint into " + ip, (Throwable)cause);
        }
    }

    @Uri(value="")
    @Produces
    @Typed(value={MockEndpoint.class})
    private static MockEndpoint mockEndpointFromUri(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        Uri uri = CdiCamelFactory.getQualifierByType(ip, Uri.class).get();
        try {
            CamelContext context = uri.context().isEmpty() ? CdiCamelFactory.selectContext(ip, instance, extension) : CdiCamelFactory.selectContext(uri.context(), instance);
            return (MockEndpoint)context.getEndpoint(uri.value(), MockEndpoint.class);
        }
        catch (Exception cause) {
            throw new InjectionException("Error injecting mock endpoint annotated with " + uri + " into " + ip, (Throwable)cause);
        }
    }

    @Mock
    @Produces
    @Typed(value={MockEndpoint.class})
    private static MockEndpoint createMockEndpoint(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        Mock mock = CdiCamelFactory.getQualifierByType(ip, Mock.class).get();
        try {
            CamelContext context = mock.context().isEmpty() ? CdiCamelFactory.selectContext(ip, instance, extension) : CdiCamelFactory.selectContext(mock.context(), instance);
            return (MockEndpoint)context.getEndpoint(mock.value(), MockEndpoint.class);
        }
        catch (Exception cause) {
            throw new InjectionException("Error injecting mock endpoint annotated with " + mock + " into " + ip, (Throwable)cause);
        }
    }

    @Uri(value="")
    @Produces
    private static Endpoint endpoint(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension) {
        Uri uri = CdiCamelFactory.getQualifierByType(ip, Uri.class).get();
        try {
            CamelContext context = uri.context().isEmpty() ? CdiCamelFactory.selectContext(ip, instance, extension) : CdiCamelFactory.selectContext(uri.context(), instance);
            return context.getEndpoint(uri.value(), Endpoint.class);
        }
        catch (Exception cause) {
            throw new InjectionException("Error injecting endpoint annotated with " + uri + " into " + ip, (Throwable)cause);
        }
    }

    @Produces
    private static <T> CdiEventEndpoint<T> cdiEventEndpoint(InjectionPoint ip, @Any Instance<CamelContext> instance, CdiCamelExtension extension, @Any Event<Object> event) throws Exception {
        String uri;
        CamelContext context = CdiCamelFactory.selectContext(ip, instance, extension);
        Object type = Object.class;
        if (ip.getType() instanceof ParameterizedType) {
            type = ((ParameterizedType)ip.getType()).getActualTypeArguments()[0];
        }
        if (context.hasEndpoint(uri = CdiEventEndpoint.eventEndpointUri(type, ip.getQualifiers())) == null) {
            context.addEndpoint(uri, extension.getEventEndpoint(uri));
        }
        return (CdiEventEndpoint)context.getEndpoint(uri, CdiEventEndpoint.class);
    }

    private static <T extends CamelContext> T selectContext(String name, Instance<T> instance) {
        for (CamelContext context : instance) {
            if (!name.equals(context.getName())) continue;
            return (T)context;
        }
        throw new UnsatisfiedResolutionException("No Camel context with name [" + name + "] is deployed!");
    }

    private static <T extends CamelContext> T selectContext(InjectionPoint ip, Instance<T> instance, CdiCamelExtension extension) {
        HashSet qualifiers = new HashSet(ip.getQualifiers());
        qualifiers.retainAll(extension.getContextQualifiers());
        if (qualifiers.isEmpty() && !instance.select(new Annotation[]{DefaultLiteral.DEFAULT}).isUnsatisfied()) {
            return (T)((CamelContext)instance.select(new Annotation[]{DefaultLiteral.DEFAULT}).get());
        }
        return (T)((CamelContext)instance.select((Annotation[])qualifiers.stream().toArray(Annotation[]::new)).get());
    }

    private static <T extends Annotation> Optional<T> getQualifierByType(InjectionPoint ip, Class<T> type) {
        return ip.getQualifiers().stream().filter(CdiSpiHelper.isAnnotationType(type)).findAny().map(type::cast);
    }
}

