/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.Nonbinding;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.cdi.AnyLiteral;
import org.apache.camel.cdi.DefaultLiteral;
import org.apache.camel.cdi.SyntheticAnnotated;
import org.apache.camel.cdi.Vetoed;

@Vetoed
final class CdiSpiHelper {
    private CdiSpiHelper() {
    }

    static Predicate<Bean> hasType(Type type) {
        Objects.requireNonNull(type);
        return bean -> bean.getTypes().contains(type);
    }

    static Predicate<Annotation> isAnnotationType(Class<? extends Annotation> clazz) {
        Objects.requireNonNull(clazz);
        return annotation -> clazz.equals(annotation.annotationType());
    }

    static Class<?> getRawType(Type type) {
        Class<?> rawType;
        if (type instanceof Class) {
            return (Class)Class.class.cast(type);
        }
        if (type instanceof ParameterizedType) {
            return CdiSpiHelper.getRawType(((ParameterizedType)ParameterizedType.class.cast(type)).getRawType());
        }
        if (type instanceof TypeVariable) {
            return CdiSpiHelper.getBound(((TypeVariable)TypeVariable.class.cast(type)).getBounds());
        }
        if (type instanceof WildcardType) {
            return CdiSpiHelper.getBound(((WildcardType)WildcardType.class.cast(type)).getUpperBounds());
        }
        if (type instanceof GenericArrayType && (rawType = CdiSpiHelper.getRawType(((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType())) != null) {
            return Array.newInstance(rawType, 0).getClass();
        }
        throw new UnsupportedOperationException("Unable to retrieve raw type for [" + type + "]");
    }

    private static Class<?> getBound(Type[] bounds) {
        if (bounds.length == 0) {
            return Object.class;
        }
        return CdiSpiHelper.getRawType(bounds[0]);
    }

    @SafeVarargs
    static boolean hasAnnotation(AnnotatedType<?> type, Class<? extends Annotation> ... annotations) {
        return Stream.of(annotations).anyMatch(annotation -> CdiSpiHelper.hasAnnotation(type, (Class<? extends Annotation>)annotation));
    }

    static boolean hasAnnotation(AnnotatedType<?> type, Class<? extends Annotation> annotation) {
        if (type.isAnnotationPresent(annotation)) {
            return true;
        }
        for (AnnotatedMethod method : type.getMethods()) {
            if (!method.isAnnotationPresent(annotation)) continue;
            return true;
        }
        for (AnnotatedConstructor constructor : type.getConstructors()) {
            if (!constructor.isAnnotationPresent(annotation)) continue;
            return true;
        }
        for (AnnotatedField field : type.getFields()) {
            if (!field.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    static Set<Annotation> getQualifiers(Annotated annotated, BeanManager manager) {
        return annotated.getAnnotations().stream().filter(annotation -> manager.isQualifier(annotation.annotationType())).collect(Collectors.collectingAndThen(Collectors.toSet(), qualifiers -> {
            if (qualifiers.isEmpty()) {
                qualifiers.add(DefaultLiteral.DEFAULT);
            }
            qualifiers.add(AnyLiteral.ANY);
            return qualifiers;
        }));
    }

    static String createBeanId(Bean<?> bean) {
        return Stream.of(bean.getName(), bean.getScope().getName(), CdiSpiHelper.createAnnotationCollectionId(bean.getQualifiers()), CdiSpiHelper.createTypeCollectionId(bean.getTypes())).filter(Objects::nonNull).collect(Collectors.joining(","));
    }

    private static String createTypeCollectionId(Collection<Type> types) {
        return types.stream().sorted(Comparator.comparing(CdiSpiHelper::createTypeId)).map(CdiSpiHelper::createTypeId).collect(Collectors.joining(",", "[", "]"));
    }

    private static String createTypeId(Type type) {
        if (type instanceof Class) {
            return ((Class)Class.class.cast(type)).getName();
        }
        if (type instanceof ParameterizedType) {
            return CdiSpiHelper.createTypeId(((ParameterizedType)type).getRawType()) + Stream.of(((ParameterizedType)type).getActualTypeArguments()).map(CdiSpiHelper::createTypeId).collect(Collectors.joining(",", "<", ">"));
        }
        if (type instanceof TypeVariable) {
            return ((TypeVariable)TypeVariable.class.cast(type)).getName();
        }
        if (type instanceof GenericArrayType) {
            return CdiSpiHelper.createTypeId(((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType());
        }
        throw new UnsupportedOperationException("Unable to create type id for type [" + type + "]");
    }

    private static String createAnnotationCollectionId(Collection<Annotation> annotations) {
        if (annotations.isEmpty()) {
            return "";
        }
        return annotations.stream().sorted(Comparator.comparing(a -> a.annotationType().getName())).map(CdiSpiHelper::createAnnotationId).collect(Collectors.joining(",", "[", "]"));
    }

    static String createAnnotationId(Annotation annotation) {
        Method[] methods = AccessController.doPrivileged(() -> annotation.annotationType().getDeclaredMethods());
        return Stream.of(methods).filter(method -> !method.isAnnotationPresent(Nonbinding.class)).sorted(Comparator.comparing(Method::getName)).collect(() -> new StringJoiner(",", "@" + annotation.annotationType().getCanonicalName() + "(", ")"), (joiner, method) -> {
            try {
                joiner.add(method.getName() + "=" + method.invoke((Object)annotation, new Object[0]).toString());
            }
            catch (IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException cause) {
                throw new RuntimeCamelException("Error while accessing member [" + method.getName() + "] of annotation [" + annotation.annotationType().getName() + "]", (Throwable)cause);
            }
        }, StringJoiner::merge).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends CamelContext> T createCamelContextWithTCCL(Supplier<T> supplier, Annotated annotated) {
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = CdiSpiHelper.getClassLoader(annotated);
            Thread.currentThread().setContextClassLoader(classLoader);
            CamelContext camelContext = (CamelContext)supplier.get();
            return (T)camelContext;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTccl);
        }
    }

    private static ClassLoader getClassLoader(Annotated annotated) {
        SyntheticAnnotated syntheticAnnotated;
        Class<?> javaClass;
        if (annotated instanceof AnnotatedMember) {
            AnnotatedMember annotatedMember = (AnnotatedMember)annotated;
            AnnotatedType type = annotatedMember.getDeclaringType();
            return type.getJavaClass().getClassLoader();
        }
        if (annotated instanceof AnnotatedType) {
            AnnotatedType type = (AnnotatedType)annotated;
            return type.getJavaClass().getClassLoader();
        }
        if (annotated instanceof SyntheticAnnotated && (javaClass = (syntheticAnnotated = (SyntheticAnnotated)annotated).getJavaClass()) != null) {
            return javaClass.getClassLoader();
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != null) {
            return tccl;
        }
        return CdiSpiHelper.class.getClassLoader();
    }
}

