/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.connector;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.maven.connector.util.FileHelper;
import org.apache.camel.maven.connector.util.GitHelper;
import org.apache.camel.maven.connector.util.JSonSchemaHelper;
import org.apache.camel.maven.connector.util.StringHelper;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.jar.AbstractJarMojo;

@Mojo(name="jar", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ConnectorMojo
extends AbstractJarMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(defaultValue="true")
    private boolean generateToSources;
    @Parameter(defaultValue="false")
    private boolean includeGitUrl;
    @Parameter(defaultValue="true")
    private boolean prettyPrint;
    private CamelCatalog catalog = new DefaultCamelCatalog();

    protected File getClassesDirectory() {
        return this.classesDirectory;
    }

    protected String getClassifier() {
        return null;
    }

    protected String getType() {
        return "jar";
    }

    public File createArchive() throws MojoExecutionException {
        File root = this.classesDirectory.getParentFile().getParentFile();
        String gitUrl = null;
        File file = new File(this.classesDirectory, "camel-connector.json");
        if (file.exists()) {
            String version = this.getProject().getVersion();
            this.updateVersionInCamelConnectorJSon("version", version);
            try {
                File schema;
                ObjectMapper mapper = new ObjectMapper();
                Map dto = (Map)mapper.readValue(file, Map.class);
                if (this.includeGitUrl) {
                    gitUrl = this.embedGitUrlInCamelConnectorJSon(mapper, dto);
                }
                if ((schema = this.embedCamelComponentSchema(file)) != null) {
                    String json = FileHelper.loadText(new FileInputStream(schema));
                    List rows = org.apache.camel.catalog.JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
                    String header = this.buildComponentHeaderSchema(rows, dto, gitUrl);
                    this.getLog().debug((CharSequence)header);
                    rows = org.apache.camel.catalog.JSonSchemaHelper.parseJsonSchema((String)"componentProperties", (String)json, (boolean)true);
                    String componentOptions = this.buildComponentOptionsSchema(rows, dto);
                    this.getLog().debug((CharSequence)componentOptions);
                    rows = org.apache.camel.catalog.JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
                    String endpointOptions = this.buildEndpointOptionsSchema(rows, dto);
                    this.getLog().debug((CharSequence)endpointOptions);
                    String connectorOptions = this.buildConnectorOptionsSchema(dto);
                    this.getLog().debug((CharSequence)connectorOptions);
                    StringBuilder jsonSchema = new StringBuilder();
                    jsonSchema.append("{\n");
                    jsonSchema.append(header);
                    jsonSchema.append(componentOptions);
                    jsonSchema.append(endpointOptions);
                    jsonSchema.append(connectorOptions);
                    jsonSchema.append("}\n");
                    String newJson = jsonSchema.toString();
                    rows = org.apache.camel.catalog.JSonSchemaHelper.parseJsonSchema((String)"component", (String)newJson, (boolean)false);
                    String newScheme = this.getOption(rows, "scheme");
                    this.checkConnectorScheme(newScheme);
                    String javaType = (String)dto.get("javaType");
                    String dir = javaType.substring(0, javaType.lastIndexOf("."));
                    dir = dir.replace('.', '/');
                    File subDir = new File(this.classesDirectory, dir);
                    String name = newScheme + ".json";
                    File out = new File(subDir, name);
                    FileOutputStream fos = new FileOutputStream(out, false);
                    newJson = this.prettyPrint ? JSonSchemaHelper.prettyPrint(newJson) : newJson;
                    fos.write(newJson.getBytes());
                    fos.close();
                    out = new File(this.classesDirectory, "camel-connector-schema.json");
                    fos = new FileOutputStream(out, false);
                    fos.write(newJson.getBytes());
                    fos.close();
                    if (this.generateToSources) {
                        File from = new File(this.classesDirectory, "camel-connector-schema.json");
                        File to = new File(root, "src/main/resources/camel-connector-schema.json");
                        FileHelper.copyFile(from, to);
                    }
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error in camel-connector-maven-plugin", e);
            }
        }
        return super.createArchive();
    }

    private void checkConnectorScheme(String connectorScheme) {
        List componentNames = this.catalog.findComponentNames();
        if (componentNames != null && componentNames.contains(connectorScheme)) {
            String format = "Can't package a connector with scheme '%s' as a component with the same scheme is already registered in the catalog";
            String message = String.format(format, connectorScheme);
            this.getLog().error((CharSequence)message);
            throw new IllegalArgumentException(message);
        }
    }

    private String embedGitUrlInCamelConnectorJSon(ObjectMapper mapper, Map dto) throws MojoExecutionException {
        File gitFolder = GitHelper.findGitFolder();
        try {
            String gitUrl = GitHelper.extractGitUrl(gitFolder);
            if (gitUrl == null) {
                return null;
            }
            String existingGitUrl = (String)dto.get("gitUrl");
            if (existingGitUrl == null || !existingGitUrl.equals(gitUrl)) {
                dto.put("gitUrl", gitUrl);
                File file = new File(this.classesDirectory, "camel-connector.json");
                mapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)dto);
                File root = this.classesDirectory.getParentFile().getParentFile();
                File sourceFile = new File(root, "src/main/resources/camel-connector.json");
                if (sourceFile.exists()) {
                    this.getLog().info((CharSequence)("Updating gitUrl to " + gitUrl + " in " + sourceFile));
                    mapper.writerWithDefaultPrettyPrinter().writeValue(sourceFile, (Object)dto);
                }
            }
            return gitUrl;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error in camel-connector-maven-plugin", (Exception)e);
        }
    }

    private String extractJavaType(String scheme) throws Exception {
        File file = new File(this.classesDirectory, "META-INF/services/org/apache/camel/component/" + scheme);
        if (file.exists()) {
            List<String> lines = FileHelper.loadFile(file);
            String fqn = ConnectorMojo.extractClass(lines);
            return fqn;
        }
        return null;
    }

    private String getOption(List<Map<String, String>> rows, String key) {
        for (Map<String, String> row : rows) {
            if (!row.containsKey(key)) continue;
            return row.get(key);
        }
        return null;
    }

    private String buildComponentOptionsSchema(List<Map<String, String>> rows, Map dto) throws JsonProcessingException {
        List options = (List)dto.get("componentOptions");
        Map values = (Map)dto.get("componentValues");
        Map overrides = (Map)dto.get("componentOverrides");
        StringBuilder sb = new StringBuilder();
        sb.append("  \"componentProperties\": {\n");
        boolean first = true;
        for (int i = 0; i < rows.size(); ++i) {
            Map over;
            Object newDefaultValue;
            Map<String, String> row = rows.get(i);
            String key = row.get("name");
            if (options == null || !options.contains(key)) continue;
            if (values != null && values.containsKey(key) && (newDefaultValue = values.get(key)) != null) {
                row.put("defaultValue", newDefaultValue.toString());
            }
            if (overrides != null && overrides.containsKey(key) && (over = (Map)overrides.get(key)) != null) {
                row.putAll(over);
            }
            String line = ConnectorMojo.buildJSonLineFromRow(row);
            if (!first) {
                sb.append(",\n");
            }
            sb.append("    ").append(line);
            first = false;
        }
        if (!first) {
            sb.append("\n");
        }
        sb.append("  },\n");
        return sb.toString();
    }

    private String buildEndpointOptionsSchema(List<Map<String, String>> rows, Map dto) throws JsonProcessingException {
        List options = (List)dto.get("endpointOptions");
        Map values = (Map)dto.get("endpointValues");
        Map overrides = (Map)dto.get("endpointOverrides");
        if ("timer".equals(dto.get("scheduler"))) {
            LinkedHashMap<String, String> period = new LinkedHashMap<String, String>();
            period.put("name", "schedulerPeriod");
            period.put("kind", "parameter");
            period.put("displayName", "Period");
            period.put("group", "consumer");
            period.put("type", "integer");
            period.put("javaType", "long");
            period.put("deprecated", "false");
            period.put("secret", "false");
            period.put("defaultValue", "1000");
            period.put("description", "Delay in milli seconds between scheduling (executing)");
            this.getLog().debug((CharSequence)"Connector is using scheduler: timer");
            rows.add(period);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("  \"properties\": {\n");
        boolean first = true;
        for (int i = 0; i < rows.size(); ++i) {
            Map over;
            Object newDefaultValue;
            Map<String, String> row = rows.get(i);
            String key = row.get("name");
            if (options == null || !options.contains(key)) continue;
            if (values != null && values.containsKey(key) && (newDefaultValue = values.get(key)) != null) {
                row.put("defaultValue", newDefaultValue.toString());
            }
            if (overrides != null && overrides.containsKey(key) && (over = (Map)overrides.get(key)) != null) {
                row.putAll(over);
            }
            String line = ConnectorMojo.buildJSonLineFromRow(row);
            if (!first) {
                sb.append(",\n");
            }
            sb.append("    ").append(line);
            first = false;
        }
        if (!first) {
            sb.append("\n");
        }
        sb.append("  },\n");
        return sb.toString();
    }

    private String buildConnectorOptionsSchema(Map dto) throws JsonProcessingException {
        Map properties = (Map)dto.get("connectorProperties");
        StringBuilder sb = new StringBuilder();
        sb.append("  \"connectorProperties\": {\n");
        AtomicBoolean first = new AtomicBoolean(true);
        if (properties != null) {
            for (Map.Entry entry : properties.entrySet()) {
                Map row = (Map)entry.getValue();
                row.put("name", entry.getKey());
                String line = ConnectorMojo.buildJSonLineFromRow(row);
                if (!first.get()) {
                    sb.append(",\n");
                }
                sb.append("    ").append(line);
                first.set(false);
            }
        }
        if (!first.get()) {
            sb.append("\n");
        }
        sb.append("  }\n");
        return sb.toString();
    }

    private String buildComponentHeaderSchema(List<Map<String, String>> rows, Map dto, String gitUrl) throws Exception {
        String baseScheme = (String)dto.get("baseScheme");
        String title = (String)dto.get("name");
        String scheme = (String)dto.get("scheme");
        if (scheme == null || scheme.isEmpty()) {
            scheme = StringHelper.camelCaseToDash(title);
        }
        String baseSyntax = this.getOption(rows, "syntax");
        String syntax = baseSyntax.replaceFirst(baseScheme, scheme);
        String description = (String)dto.get("description");
        String label = null;
        List labels = (List)dto.get("labels");
        if (labels != null) {
            label = labels.stream().collect(Collectors.joining(","));
        }
        String async = this.getOption(rows, "async");
        String pattern = (String)dto.get("pattern");
        String producerOnly = "To".equalsIgnoreCase(pattern) ? "true" : null;
        String consumerOnly = "From".equalsIgnoreCase(pattern) ? "true" : null;
        String lenientProperties = this.getOption(rows, "lenientProperties");
        String deprecated = this.getOption(rows, "deprecated");
        String javaType = this.extractJavaType(scheme);
        String groupId = this.getProject().getGroupId();
        String artifactId = this.getProject().getArtifactId();
        String version = this.getProject().getVersion();
        StringBuilder sb = new StringBuilder();
        sb.append("  \"component\": {\n");
        if (gitUrl != null) {
            sb.append("    \"girUrl\": \"" + StringHelper.nullSafe(gitUrl) + "\",\n");
        }
        sb.append("    \"kind\": \"component\",\n");
        sb.append("    \"baseScheme\": \"" + StringHelper.nullSafe(baseScheme) + "\",\n");
        sb.append("    \"scheme\": \"" + scheme + "\",\n");
        sb.append("    \"syntax\": \"" + syntax + "\",\n");
        sb.append("    \"title\": \"" + title + "\",\n");
        if (description != null) {
            String text = JSonSchemaHelper.sanitizeDescription(description, false);
            sb.append("    \"description\": \"" + text + "\",\n");
        }
        if (label != null) {
            sb.append("    \"label\": \"" + label + "\",\n");
        }
        if (deprecated != null) {
            sb.append("    \"deprecated\": " + deprecated + ",\n");
        }
        if (async != null) {
            sb.append("    \"async\": " + async + ",\n");
        }
        if (producerOnly != null) {
            sb.append("    \"producerOnly\": " + producerOnly + ",\n");
        } else if (consumerOnly != null) {
            sb.append("    \"consumerOnly\": " + consumerOnly + ",\n");
        }
        if (lenientProperties != null) {
            sb.append("    \"lenientProperties\": " + lenientProperties + ",\n");
        }
        sb.append("    \"javaType\": \"" + javaType + "\",\n");
        sb.append("    \"groupId\": \"" + groupId + "\",\n");
        sb.append("    \"artifactId\": \"" + artifactId + "\",\n");
        sb.append("    \"version\": \"" + version + "\"\n");
        sb.append("  },\n");
        return sb.toString();
    }

    private File embedCamelComponentSchema(File file) throws MojoExecutionException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map dto = (Map)mapper.readValue(file, Map.class);
            String scheme = ConnectorMojo.extractScheme(dto);
            String groupId = ConnectorMojo.extractGroupId(dto);
            String artifactId = ConnectorMojo.extractArtifactId(dto);
            if (scheme != null && groupId != null && artifactId != null) {
                for (Object obj : this.getProject().getDependencyArtifacts()) {
                    URL url;
                    URLClassLoader child;
                    InputStream is;
                    Artifact artifact = (Artifact)obj;
                    if (!"jar".equals(artifact.getType()) || !groupId.equals(artifact.getGroupId()) || !artifactId.equals(artifact.getArtifactId()) || (is = (child = new URLClassLoader(new URL[]{url = new URL("file:" + artifact.getFile())}, ((Object)((Object)this)).getClass().getClassLoader())).getResourceAsStream("META-INF/services/org/apache/camel/component/" + scheme)) == null) continue;
                    List<String> lines = FileHelper.loadFile(is);
                    String fqn = ConnectorMojo.extractClass(lines);
                    is.close();
                    String pck = fqn.substring(0, fqn.lastIndexOf("."));
                    String name = pck.replace(".", "/") + "/" + scheme + ".json";
                    is = child.getResourceAsStream(name);
                    if (is == null) continue;
                    List<String> schema = FileHelper.loadFile(is);
                    is.close();
                    File out = new File(this.classesDirectory, "camel-component-schema.json");
                    FileOutputStream fos = new FileOutputStream(out, false);
                    for (String line : schema) {
                        fos.write(line.getBytes());
                        fos.write("\n".getBytes());
                    }
                    fos.close();
                    this.getLog().info((CharSequence)("Embedded camel-component-schema.json file for Camel component " + scheme));
                    String baseVersion = artifact.getVersion();
                    this.updateVersionInCamelConnectorJSon("baseVersion", baseVersion);
                    return out;
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot read file camel-connector.json", e);
        }
        return null;
    }

    private void updateVersionInCamelConnectorJSon(String qualifier, String version) throws MojoExecutionException {
        File file = new File(this.classesDirectory, "camel-connector.json");
        if (file.exists()) {
            try {
                String existingVersion;
                ObjectMapper mapper = new ObjectMapper();
                Map dto = (Map)mapper.readValue(file, Map.class);
                if (!(version == null || (existingVersion = (String)dto.get(qualifier)) != null && existingVersion.equals(version))) {
                    dto.put(qualifier, version);
                    mapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)dto);
                    File root = this.classesDirectory.getParentFile().getParentFile();
                    file = new File(root, "src/main/resources/camel-connector.json");
                    if (file.exists()) {
                        this.getLog().info((CharSequence)("Updating " + qualifier + " to " + version + " in " + file));
                        mapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)dto);
                    }
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error in camel-connector-maven-plugin", e);
            }
        }
    }

    private static String buildJSonLineFromRow(Map<String, String> row) {
        String name = row.get("name");
        String displayName = row.get("displayName");
        String kind = row.get("kind");
        boolean required = false;
        String value = row.getOrDefault("required", "false");
        if (value instanceof Boolean) {
            required = (Boolean)((Object)value);
        } else if (value != null) {
            required = Boolean.valueOf(value.toString());
        }
        String javaType = row.get("javaType");
        String defaultValue = row.get("defaultValue");
        String description = row.get("description");
        boolean deprecated = false;
        value = row.getOrDefault("deprecated", "false");
        if (value instanceof Boolean) {
            deprecated = (Boolean)((Object)value);
        } else if (value != null) {
            deprecated = Boolean.valueOf(value.toString());
        }
        boolean secret = false;
        value = row.getOrDefault("secret", "false");
        if (value instanceof Boolean) {
            secret = (Boolean)((Object)value);
        } else if (value != null) {
            secret = Boolean.valueOf(value.toString());
        }
        String group = row.get("group");
        String label = row.get("label");
        LinkedHashSet<String> enums = null;
        value = row.get("enum");
        if (value instanceof List) {
            enums = new LinkedHashSet((List)((Object)value));
        } else if (value instanceof String) {
            String[] array = value.toString().split(",");
            enums = Arrays.stream(array).collect(Collectors.toSet());
        }
        boolean enumType = enums != null;
        String optionalPrefix = row.get("optionalPrefix");
        String prefix = row.get("prefix");
        boolean multiValue = false;
        value = row.getOrDefault("multiValue", "false");
        if (value instanceof Boolean) {
            multiValue = (Boolean)((Object)value);
        } else if (value != null) {
            multiValue = Boolean.valueOf(value.toString());
        }
        return JSonSchemaHelper.toJson(name, displayName, kind, required, javaType, defaultValue, description, deprecated, secret, group, label, enumType, enums, false, null, false, optionalPrefix, prefix, multiValue);
    }

    private static String extractClass(List<String> lines) {
        for (String line : lines) {
            if (!(line = line.trim()).startsWith("class=")) continue;
            return line.substring(6);
        }
        return null;
    }

    private static String extractScheme(Map map) {
        return (String)map.get("baseScheme");
    }

    private static String extractGroupId(Map map) {
        return (String)map.get("baseGroupId");
    }

    private static String extractArtifactId(Map map) {
        return (String)map.get("baseArtifactId");
    }

    private static String extractVersion(Map map) {
        return (String)map.get("baseVersion");
    }
}

