/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.connector;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.PostConstruct;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.apache.camel.maven.connector.model.ComponentModel;
import org.apache.camel.maven.connector.model.ComponentOptionModel;
import org.apache.camel.maven.connector.model.ConnectorOptionModel;
import org.apache.camel.maven.connector.model.EndpointOptionModel;
import org.apache.camel.maven.connector.model.OptionModel;
import org.apache.camel.maven.connector.util.FileHelper;
import org.apache.camel.maven.connector.util.StringHelper;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.PropertySource;
import org.jboss.forge.roaster.model.util.Formatter;
import org.jboss.forge.roaster.model.util.Strings;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Mojo(name="prepare-spring-boot-auto-configuration", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true)
public class SpringBootAutoConfigurationMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(defaultValue="true")
    private boolean includeLicenseHeader;
    @Parameter(defaultValue="camel.connector")
    private String configurationPrefix;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.executeConnector();
        }
        catch (Exception e) {
            throw new MojoFailureException("Error generating Spring-Boot auto configuration for connector", (Throwable)e);
        }
    }

    private void executeConnector() throws Exception {
        String javaType = null;
        String connectorScheme = null;
        List componentOptions = Collections.emptyList();
        List endpointOptions = Collections.emptyList();
        File file = new File(this.classesDirectory, "camel-connector.json");
        if (file.exists()) {
            ObjectMapper mapper = new ObjectMapper();
            Map dto = (Map)mapper.readValue(file, Map.class);
            javaType = (String)dto.get("javaType");
            connectorScheme = (String)dto.get("scheme");
            componentOptions = (List)dto.get("componentOptions");
            endpointOptions = (List)dto.get("endpointOptions");
        }
        if ((file = new File(this.classesDirectory, "camel-connector-schema.json")).exists() && javaType != null && connectorScheme != null) {
            String json = FileHelper.loadText(new FileInputStream(file));
            ComponentModel model = SpringBootAutoConfigurationMojo.generateComponentModel(json);
            boolean hasComponentOptions = model.getComponentOptions().stream().anyMatch(o -> !o.getName().equals("resolvePropertyPlaceholders"));
            boolean hasConnectorOptions = !model.getConnectorOptions().isEmpty();
            int pos = javaType.lastIndexOf(".");
            String pkg = javaType.substring(0, pos) + ".springboot";
            if (hasComponentOptions || hasConnectorOptions) {
                this.getLog().info((CharSequence)("Generating Spring Boot AutoConfiguration for Connector: " + model.getScheme()));
                this.createConnectorConfigurationSource(pkg, model, javaType, connectorScheme, componentOptions, endpointOptions);
                this.createConnectorAutoConfigurationSource(pkg, hasComponentOptions || hasConnectorOptions, javaType, connectorScheme);
                this.createConnectorSpringFactorySource(pkg, javaType);
            }
        }
    }

    private void createConnectorSpringFactorySource(String packageName, String javaType) throws MojoFailureException {
        int pos = javaType.lastIndexOf(".");
        String name = javaType.substring(pos + 1);
        name = name.replace("Component", "ConnectorAutoConfiguration");
        this.writeComponentSpringFactorySource(packageName, name);
    }

    private void writeComponentSpringFactorySource(String packageName, String name) throws MojoFailureException {
        StringBuilder sb = new StringBuilder();
        sb.append("org.springframework.boot.autoconfigure.EnableAutoConfiguration=\\\n");
        String lineToAdd = packageName + "." + name + "\n";
        sb.append(lineToAdd);
        File root = this.classesDirectory.getParentFile().getParentFile();
        String fileName = "src/main/resources/META-INF/spring.factories";
        File target = new File(root, fileName);
        try {
            String header = "";
            if (this.includeLicenseHeader) {
                InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header.txt");
                header = FileHelper.loadText(is);
            }
            String code = sb.toString();
            code = header + "\n" + code;
            this.getLog().debug((CharSequence)("Source code generated:\n" + code));
            FileUtils.write((File)target, (CharSequence)code);
            this.getLog().info((CharSequence)("Created file: " + target));
        }
        catch (Exception e) {
            throw new MojoFailureException("IOError with file " + target, (Throwable)e);
        }
    }

    private void createConnectorConfigurationSource(String packageName, ComponentModel model, String javaType, String connectorScheme, List<String> componentOptions, List<String> endpointOptions) throws MojoFailureException {
        int pos = javaType.lastIndexOf(".");
        String commonName = javaType.substring(pos + 1).replace("Component", "ConnectorConfigurationCommon");
        String configName = javaType.substring(pos + 1).replace("Component", "ConnectorConfiguration");
        JavaClassSource commonClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        commonClass.setPackage(packageName);
        commonClass.setName(commonName);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isBlank((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        doc = doc.replaceAll("Component", "Connector");
        doc = doc.replaceAll("component", "connector");
        commonClass.getJavaDoc().setFullText(doc);
        commonClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        String prefix = "";
        if (!"false".equalsIgnoreCase(this.configurationPrefix) && !(prefix = this.configurationPrefix.toLowerCase(Locale.US)).endsWith(".")) {
            prefix = prefix + ".";
        }
        prefix = prefix + connectorScheme.toLowerCase(Locale.US);
        for (OptionModel optionModel : model.getComponentOptions()) {
            boolean isEndpointOption;
            boolean isComponentOption = componentOptions != null && componentOptions.stream().anyMatch(o -> o.equals(option.getName()));
            boolean bl = isEndpointOption = endpointOptions != null && endpointOptions.stream().anyMatch(o -> o.equals(option.getName()));
            if (!isComponentOption || isEndpointOption) continue;
            this.addProperty(commonClass, model, optionModel);
        }
        for (OptionModel optionModel : model.getEndpointOptions()) {
            if (endpointOptions == null || !endpointOptions.stream().anyMatch(o -> o.equals(option.getName()))) continue;
            this.addProperty(commonClass, model, optionModel);
        }
        for (OptionModel optionModel : model.getConnectorOptions()) {
            this.addProperty(commonClass, model, optionModel);
        }
        SpringBootAutoConfigurationMojo.sortImports(commonClass);
        this.writeSourceIfChanged(commonClass, packageName.replaceAll("\\.", "\\/") + "/" + commonName + ".java");
        JavaClassSource configClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        configClass.setPackage(packageName);
        configClass.setName(configName);
        configClass.extendSuperType((JavaClass)commonClass);
        configClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        configClass.addAnnotation(ConfigurationProperties.class).setStringValue("prefix", prefix);
        configClass.addImport(Map.class);
        configClass.addImport(HashMap.class);
        configClass.removeImport((JavaType)commonClass);
        ((FieldSource)configClass.addField("Map<String, " + commonName + "> configurations = new HashMap<>()").setPrivate()).getJavaDoc().setFullText("Define additional configuration definitions");
        MethodSource methodSource = configClass.addMethod();
        methodSource.setName("getConfigurations");
        methodSource.setReturnType("Map<String, " + commonName + ">");
        methodSource.setPublic();
        methodSource.setBody("return configurations;");
        SpringBootAutoConfigurationMojo.sortImports(configClass);
        this.writeSourceIfChanged(configClass, packageName.replaceAll("\\.", "\\/") + "/" + configName + ".java");
    }

    private void createConnectorAutoConfigurationSource(String packageName, boolean hasOptions, String javaType, String connectorScheme) throws MojoFailureException {
        JavaClassSource javaClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        int pos = javaType.lastIndexOf(".");
        String name = javaType.substring(pos + 1);
        name = name.replace("Component", "ConnectorAutoConfiguration");
        String configNameCommon = javaType.substring(pos + 1).replace("Component", "ConnectorConfigurationCommon");
        String configName = javaType.substring(pos + 1).replace("Component", "ConnectorConfiguration");
        String shortJavaType = StringHelper.getShortJavaType(javaType);
        String beanName = connectorScheme + "-component";
        ((JavaClassSource)javaClass.setPackage(packageName)).setName(name);
        String doc = "Generated by camel-connector-maven-plugin - do not edit this file!";
        javaClass.getJavaDoc().setFullText(doc);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation(Configuration.class);
        javaClass.addAnnotation(ConditionalOnBean.class).setStringValue("type", "org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addAnnotation(AutoConfigureAfter.class).setStringValue("name", "org.apache.camel.spring.boot.CamelAutoConfiguration");
        String configurationName = name.replace("ConnectorAutoConfiguration", "ConnectorConfiguration");
        if (hasOptions) {
            AnnotationSource ann = javaClass.addAnnotation(EnableConfigurationProperties.class);
            ann.setLiteralValue("value", configurationName + ".class");
            javaClass.addImport(HashMap.class);
            javaClass.addImport(Map.class);
            javaClass.addImport("org.apache.camel.spring.boot.util.CamelPropertiesHelper");
        }
        javaClass.addImport(javaType);
        javaClass.addImport(ApplicationContext.class);
        javaClass.addImport(BeanCreationException.class);
        javaClass.addImport(List.class);
        javaClass.addImport("org.slf4j.Logger");
        javaClass.addImport("org.slf4j.LoggerFactory");
        javaClass.addImport("org.apache.camel.CamelContext");
        javaClass.addImport("org.apache.camel.component.connector.ConnectorCustomizer");
        javaClass.addImport("org.apache.camel.spi.HasId");
        javaClass.addImport("org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator");
        javaClass.addImport("org.apache.camel.util.ObjectHelper");
        javaClass.addImport("org.apache.camel.util.IntrospectionSupport");
        ((FieldSource)((FieldSource)((FieldSource)((FieldSource)javaClass.addField().setPrivate()).setStatic(true)).setFinal(true)).setName("LOGGER")).setType("Logger").setLiteralInitializer("LoggerFactory.getLogger(" + name + ".class)");
        ((FieldSource)((FieldSource)javaClass.addField().setPrivate()).setName("applicationContext")).setType("ApplicationContext").addAnnotation(Autowired.class);
        ((FieldSource)((FieldSource)javaClass.addField().setName("camelContext")).setType("org.apache.camel.CamelContext").setPrivate()).addAnnotation(Autowired.class);
        ((FieldSource)((FieldSource)javaClass.addField().setName("configuration")).setType(configName).setPrivate()).addAnnotation(Autowired.class);
        ((FieldSource)((FieldSource)javaClass.addField().setPrivate()).setName("customizers")).setType("List<ConnectorCustomizer<" + shortJavaType + ">>").addAnnotation(Autowired.class).setLiteralValue("required", "false");
        MethodSource configureMethod = ((MethodSource)((MethodSource)javaClass.addMethod().setName("configure" + shortJavaType)).setPublic()).setBody(SpringBootAutoConfigurationMojo.createComponentBody(shortJavaType, hasOptions, connectorScheme.toLowerCase(Locale.US))).setReturnType(shortJavaType).addThrows(Exception.class);
        configureMethod.addAnnotation(Lazy.class);
        configureMethod.addAnnotation(Bean.class).setStringValue("name", beanName);
        configureMethod.addAnnotation(ConditionalOnClass.class).setLiteralValue("value", "CamelContext.class");
        configureMethod.addAnnotation(ConditionalOnMissingBean.class);
        MethodSource postProcessMethod = ((MethodSource)((MethodSource)javaClass.addMethod().setName("postConstruct" + shortJavaType)).setPublic()).setBody(SpringBootAutoConfigurationMojo.createPostConstructBody(shortJavaType, configNameCommon, connectorScheme.toLowerCase(Locale.US)));
        postProcessMethod.addAnnotation(PostConstruct.class);
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName);
    }

    private void writeSourceIfChanged(JavaClassSource source, String fileName) throws MojoFailureException {
        File root = this.classesDirectory.getParentFile().getParentFile();
        File target = new File(root, "src/main/java/" + fileName);
        try {
            String header = "";
            if (this.includeLicenseHeader) {
                InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header-java.txt");
                header = FileHelper.loadText(is);
            }
            String code = SpringBootAutoConfigurationMojo.sourceToString(source);
            code = header + code;
            this.getLog().debug((CharSequence)("Source code generated:\n" + code));
            if (target.exists()) {
                String existing = FileUtils.readFileToString((File)target);
                if (!code.equals(existing)) {
                    FileUtils.write((File)target, (CharSequence)code, (boolean)false);
                    this.getLog().info((CharSequence)("Updated existing file: " + target));
                } else {
                    this.getLog().debug((CharSequence)("No changes to existing file: " + target));
                }
            } else {
                FileUtils.write((File)target, (CharSequence)code);
                this.getLog().info((CharSequence)("Created file: " + target));
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("IOError with file " + target, (Throwable)e);
        }
    }

    private static String createComponentBody(String shortJavaType, boolean hasOptions, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(shortJavaType).append(" connector = new ").append(shortJavaType).append("();").append("\n");
        sb.append("connector.setCamelContext(camelContext);\n");
        sb.append("\n");
        if (hasOptions) {
            sb.append("Map<String, Object> parameters = new HashMap<>();\n");
            sb.append("IntrospectionSupport.getProperties(configuration, parameters, null, false);\n");
            sb.append("CamelPropertiesHelper.setCamelProperties(camelContext, connector, parameters, false);\n");
            sb.append("connector.setOptions(parameters);\n");
        }
        sb.append("if (ObjectHelper.isNotEmpty(customizers)) {\n");
        sb.append("    for (ConnectorCustomizer<").append(shortJavaType).append("> customizer : customizers) {\n");
        sb.append("\n");
        sb.append("        boolean useCustomizer = (customizer instanceof HasId)");
        sb.append("            ? HierarchicalPropertiesEvaluator.evaluate(\n");
        sb.append("                applicationContext.getEnvironment(),\n");
        sb.append("               \"camel.connector.customizer\",\n");
        sb.append("               \"camel.connector.").append(name).append(".customizer\",\n");
        sb.append("               ((HasId)customizer).getId())\n");
        sb.append("            : HierarchicalPropertiesEvaluator.evaluate(\n");
        sb.append("                applicationContext.getEnvironment(),\n");
        sb.append("               \"camel.connector.customizer\",\n");
        sb.append("               \"camel.connector.").append(name).append(".customizer\");\n");
        sb.append("\n");
        sb.append("        if (useCustomizer) {\n");
        sb.append("            LOGGER.debug(\"Configure connector {}, with customizer {}\", connector, customizer);\n");
        sb.append("            customizer.customize(connector);\n");
        sb.append("        }\n");
        sb.append("    }\n");
        sb.append("}\n");
        sb.append("\n");
        sb.append("return connector;");
        return sb.toString();
    }

    private static String createPostConstructBody(String shortJavaType, String commonConfigurationName, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("Map<String, Object> parameters = new HashMap<>();\n");
        sb.append("\n");
        sb.append("for (Map.Entry<String, " + commonConfigurationName + "> entry : configuration.getConfigurations().entrySet()) {\n");
        sb.append("parameters.clear();\n");
        sb.append("\n");
        sb.append(shortJavaType).append(" connector = new ").append(shortJavaType).append("(").append("entry.getKey()").append(");\n");
        sb.append("connector.setCamelContext(camelContext);\n");
        sb.append("\n");
        sb.append("try {\n");
        sb.append("IntrospectionSupport.getProperties(entry.getValue(), parameters, null, false);\n");
        sb.append("CamelPropertiesHelper.setCamelProperties(camelContext, connector, parameters, false);\n");
        sb.append("connector.setOptions(parameters);\n");
        sb.append("if (ObjectHelper.isNotEmpty(customizers)) {\n");
        sb.append("    for (ConnectorCustomizer<").append(shortJavaType).append("> customizer : customizers) {\n");
        sb.append("\n");
        sb.append("        boolean useCustomizer = (customizer instanceof HasId)");
        sb.append("            ? HierarchicalPropertiesEvaluator.evaluate(\n");
        sb.append("                applicationContext.getEnvironment(),\n");
        sb.append("               \"camel.connector.customizer\",\n");
        sb.append("               \"camel.connector.").append(name).append(".\" + entry.getKey() + \".customizer\",\n");
        sb.append("               ((HasId)customizer).getId())\n");
        sb.append("            : HierarchicalPropertiesEvaluator.evaluate(\n");
        sb.append("                applicationContext.getEnvironment(),\n");
        sb.append("               \"camel.connector.customizer\",\n");
        sb.append("               \"camel.connector.").append(name).append(".\" + entry.getKey() + \".customizer\");\n");
        sb.append("\n");
        sb.append("        if (useCustomizer) {\n");
        sb.append("            LOGGER.debug(\"Configure connector {}, with customizer {}\", connector, customizer);\n");
        sb.append("            customizer.customize(connector);\n");
        sb.append("        }\n");
        sb.append("    }\n");
        sb.append("}\n");
        sb.append("\n");
        sb.append("camelContext.addComponent(entry.getKey(), connector);\n");
        sb.append("} catch (Exception e) {\n");
        sb.append("throw new BeanCreationException(entry.getKey(), e.getMessage(), e);\n");
        sb.append("}\n");
        sb.append("}\n");
        return sb.toString();
    }

    private static void sortImports(JavaClassSource javaClass) {
        List imports = javaClass.getImports();
        ArrayList<String> names = new ArrayList<String>();
        for (Import imp : imports) {
            names.add(imp.getQualifiedName());
        }
        Collections.sort(names, (s1, s2) -> {
            if (s1.startsWith("java.")) {
                s1 = "___" + s1;
            }
            if (s2.startsWith("java.")) {
                s2 = "___" + s2;
            }
            if (s1.startsWith("javax.")) {
                s1 = "__" + s1;
            }
            if (s2.startsWith("javax.")) {
                s2 = "__" + s2;
            }
            if (s1.startsWith("org.w3c.")) {
                s1 = "_" + s1;
            }
            if (s2.startsWith("org.w3c.")) {
                s2 = "_" + s2;
            }
            return s1.compareTo((String)s2);
        });
        for (String name : names) {
            javaClass.removeImport(name);
        }
        for (String name : names) {
            javaClass.addImport(name);
        }
    }

    private static String sourceToString(JavaClassSource javaClass) {
        String code = Formatter.format((JavaClassSource)javaClass);
        code = code.replaceAll("\\t", "    ");
        return code;
    }

    private static ComponentModel generateComponentModel(String json) {
        OptionModel option;
        List rows = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        ComponentModel component = new ComponentModel();
        component.setScheme(StringHelper.getSafeValue("scheme", rows));
        component.setSyntax(StringHelper.getSafeValue("syntax", rows));
        component.setAlternativeSyntax(StringHelper.getSafeValue("alternativeSyntax", rows));
        component.setTitle(StringHelper.getSafeValue("title", rows));
        component.setDescription(StringHelper.getSafeValue("description", rows));
        component.setFirstVersion(StringHelper.getSafeValue("firstVersion", rows));
        component.setLabel(StringHelper.getSafeValue("label", rows));
        component.setDeprecated(StringHelper.getSafeValue("deprecated", rows));
        component.setConsumerOnly(StringHelper.getSafeValue("consumerOnly", rows));
        component.setProducerOnly(StringHelper.getSafeValue("producerOnly", rows));
        component.setJavaType(StringHelper.getSafeValue("javaType", rows));
        component.setGroupId(StringHelper.getSafeValue("groupId", rows));
        component.setArtifactId(StringHelper.getSafeValue("artifactId", rows));
        component.setVersion(StringHelper.getSafeValue("version", rows));
        rows = JSonSchemaHelper.parseJsonSchema((String)"componentProperties", (String)json, (boolean)true);
        for (Map row : rows) {
            option = new ComponentOptionModel();
            option.setName(StringHelper.getSafeValue("name", row));
            option.setDisplayName(StringHelper.getSafeValue("displayName", row));
            option.setKind(StringHelper.getSafeValue("kind", row));
            option.setType(StringHelper.getSafeValue("type", row));
            option.setJavaType(StringHelper.getSafeValue("javaType", row));
            option.setDeprecated(StringHelper.getSafeValue("deprecated", row));
            option.setDescription(StringHelper.getSafeValue("description", row));
            option.setDefaultValue(StringHelper.getSafeValue("defaultValue", row));
            option.setEnums(StringHelper.getSafeValue("enum", row));
            component.addComponentOption((ComponentOptionModel)option);
        }
        rows = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        for (Map row : rows) {
            option = new EndpointOptionModel();
            option.setName(StringHelper.getSafeValue("name", row));
            option.setDisplayName(StringHelper.getSafeValue("displayName", row));
            option.setKind(StringHelper.getSafeValue("kind", row));
            option.setGroup(StringHelper.getSafeValue("group", row));
            option.setRequired(StringHelper.getSafeValue("required", row));
            option.setType(StringHelper.getSafeValue("type", row));
            option.setJavaType(StringHelper.getSafeValue("javaType", row));
            option.setEnums(StringHelper.getSafeValue("enum", row));
            ((EndpointOptionModel)option).setPrefix(StringHelper.getSafeValue("prefix", row));
            ((EndpointOptionModel)option).setMultiValue(StringHelper.getSafeValue("multiValue", row));
            option.setDeprecated(StringHelper.getSafeValue("deprecated", row));
            option.setDefaultValue(StringHelper.getSafeValue("defaultValue", row));
            option.setDescription(StringHelper.getSafeValue("description", row));
            ((EndpointOptionModel)option).setEnumValues(StringHelper.getSafeValue("enum", row));
            component.addEndpointOption((EndpointOptionModel)option);
        }
        rows = JSonSchemaHelper.parseJsonSchema((String)"connectorProperties", (String)json, (boolean)true);
        for (Map row : rows) {
            option = new ConnectorOptionModel();
            option.setName(StringHelper.getSafeValue("name", row));
            option.setDisplayName(StringHelper.getSafeValue("displayName", row));
            option.setKind(StringHelper.getSafeValue("kind", row));
            option.setType(StringHelper.getSafeValue("type", row));
            option.setJavaType(StringHelper.getSafeValue("javaType", row));
            option.setDeprecated(StringHelper.getSafeValue("deprecated", row));
            option.setDescription(StringHelper.getSafeValue("description", row));
            option.setDefaultValue(StringHelper.getSafeValue("defaultValue", row));
            option.setEnums(StringHelper.getSafeValue("enum", row));
            component.addConnectorOption((ConnectorOptionModel)option);
        }
        return component;
    }

    private void addProperty(JavaClassSource clazz, ComponentModel model, OptionModel option) {
        String type = option.getJavaType();
        PropertySource prop = clazz.addProperty(type, option.getName());
        if ("true".equals(option.getDeprecated())) {
            prop.getField().addAnnotation(Deprecated.class);
            prop.getAccessor().addAnnotation(Deprecated.class);
            prop.getMutator().addAnnotation(Deprecated.class);
            prop.getAccessor().addAnnotation(DeprecatedConfigurationProperty.class);
        }
        if (!Strings.isBlank((String)option.getDescription())) {
            prop.getField().getJavaDoc().setFullText(option.getDescription());
        }
        if (!Strings.isBlank((String)option.getDefaultValue())) {
            if ("java.lang.String".equals(option.getJavaType())) {
                prop.getField().setStringInitializer(option.getDefaultValue());
            } else if ("long".equals(option.getJavaType()) || "java.lang.Long".equals(option.getJavaType())) {
                String value = option.getDefaultValue() + "L";
                prop.getField().setLiteralInitializer(value);
            } else if ("integer".equals(option.getType()) || "boolean".equals(option.getType())) {
                prop.getField().setLiteralInitializer(option.getDefaultValue());
            } else if (!Strings.isBlank((String)option.getEnums())) {
                String enumShortName = type.substring(type.lastIndexOf(".") + 1);
                prop.getField().setLiteralInitializer(enumShortName + "." + option.getDefaultValue());
                clazz.addImport(model.getJavaType());
            }
        }
    }
}

