/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.connector.model;

import com.google.common.base.CaseFormat;
import org.apache.camel.maven.connector.model.OptionModel;

public class EndpointOptionModel
extends OptionModel {
    private String prefix;
    private String multiValue;
    private String enumValues;
    private boolean newGroup;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getMultiValue() {
        return this.multiValue;
    }

    public void setMultiValue(String multiValue) {
        this.multiValue = multiValue;
    }

    public String getEnumValues() {
        return this.enumValues;
    }

    public void setEnumValues(String enumValues) {
        this.enumValues = enumValues;
    }

    public boolean isNewGroup() {
        return this.newGroup;
    }

    public void setNewGroup(boolean newGroup) {
        this.newGroup = newGroup;
    }

    @Override
    public String getShortJavaType() {
        return this.getShortJavaType(40);
    }

    public String getShortJavaType(int watermark) {
        String group = this.getGroup();
        String type = this.getType();
        String javaType = this.getJavaType();
        if (javaType.startsWith("java.util.Map")) {
            return "Map";
        }
        if (javaType.startsWith("java.util.Set")) {
            return "Set";
        }
        if (javaType.startsWith("java.util.List")) {
            return "List";
        }
        String text = javaType;
        int pos = text.lastIndexOf(".");
        if (pos != -1) {
            text = text.substring(pos + 1);
        }
        if ("object".equals(type)) {
            text = this.wrapCamelCaseWords(text, watermark, " ");
        }
        return text;
    }

    public String getShortGroup() {
        String group = this.getGroup();
        if (group.endsWith(" (advanced)")) {
            return group.substring(0, group.length() - 11);
        }
        return group;
    }

    public String getShortDefaultValue(int watermark) {
        String defaultValue = this.getDefaultValue();
        if (defaultValue.isEmpty()) {
            return "";
        }
        String text = defaultValue;
        if (text.endsWith("<T>")) {
            text = text.substring(0, text.length() - 3);
        } else if (text.endsWith("<T>>")) {
            text = text.substring(0, text.length() - 4);
        }
        if ("AUTO_ACKNOWLEDGE".equals(text)) {
            return "AUTO_ ACKNOWLEDGE";
        }
        return text;
    }

    public String getShortName(int watermark) {
        String text = this.wrapCamelCaseWords(this.getName(), watermark, " ");
        return Character.toLowerCase(text.charAt(0)) + text.substring(1);
    }

    private String wrapCamelCaseWords(String option, int watermark, String newLine) {
        String text = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, option);
        text = text.replace('-', ' ');
        text = this.wrapWords(text, "\n", watermark, false);
        text = text.replace(' ', '-');
        text = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, text);
        String[] lines = text.split("\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            line = Character.toUpperCase(line.charAt(0)) + line.substring(1);
            sb.append(line);
            if (i >= lines.length - 1) continue;
            sb.append(newLine);
        }
        return sb.toString();
    }

    private String wrapWords(String line, String newLine, int watermark, boolean wrapLongWords) {
        if (line == null) {
            return null;
        }
        if (newLine == null) {
            newLine = System.lineSeparator();
        }
        if (watermark < 1) {
            watermark = 1;
        }
        int inputLineLength = line.length();
        int offset = 0;
        StringBuilder sb = new StringBuilder(inputLineLength + 32);
        while (inputLineLength - offset > watermark) {
            if (line.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = line.lastIndexOf(32, watermark + offset);
            if (spaceToWrapAt >= offset) {
                sb.append(line.substring(offset, spaceToWrapAt));
                sb.append(newLine);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                sb.append(line.substring(offset, watermark + offset));
                sb.append(newLine);
                offset += watermark;
                continue;
            }
            spaceToWrapAt = line.indexOf(32, watermark + offset);
            if (spaceToWrapAt >= 0) {
                sb.append(line.substring(offset, spaceToWrapAt));
                sb.append(newLine);
                offset = spaceToWrapAt + 1;
                continue;
            }
            sb.append(line.substring(offset));
            offset = inputLineLength;
        }
        sb.append(line.substring(offset));
        return sb.toString();
    }
}

