/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.connector.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import org.apache.camel.maven.connector.util.FileHelper;

public final class GitHelper {
    private GitHelper() {
    }

    public static File findGitFolder() {
        File baseDir = new File("").getAbsoluteFile();
        return GitHelper.findGitFolder(baseDir);
    }

    private static File findGitFolder(File basedir) {
        File gitDir = new File(basedir, ".git");
        if (gitDir.exists() && gitDir.isDirectory()) {
            return gitDir;
        }
        File parent = basedir.getParentFile();
        if (parent != null) {
            return GitHelper.findGitFolder(parent);
        }
        return null;
    }

    public static String extractGitUrl(File basedir) throws IOException {
        File gitConfig;
        if (basedir == null) {
            return null;
        }
        if (basedir.exists() && basedir.isDirectory() && (gitConfig = new File(basedir, ".git/config")).isFile() && gitConfig.exists()) {
            String text = FileHelper.loadText(new FileInputStream(gitConfig));
            return GitHelper.extractGitUrl(text);
        }
        File parentFile = basedir.getParentFile();
        if (parentFile != null) {
            return GitHelper.extractGitUrl(parentFile);
        }
        return null;
    }

    private static String extractGitUrl(String configText) {
        String remote = null;
        String lastUrl = null;
        String firstUrl = null;
        BufferedReader reader = new BufferedReader(new StringReader(configText));
        HashMap<String, String> remoteUrls = new HashMap<String, String>();
        while (true) {
            String[] parts;
            String trimmed;
            String line = null;
            try {
                line = reader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (line == null) break;
            if (line.startsWith("[remote ")) {
                String[] parts2 = line.split("\"");
                if (parts2.length <= 1) continue;
                remote = parts2[1];
                continue;
            }
            if (line.startsWith("[")) {
                remote = null;
                continue;
            }
            if (remote == null || line.length() <= 0 || !Character.isWhitespace(line.charAt(0)) || !(trimmed = line.trim()).startsWith("url ") || (parts = trimmed.split("=", 2)).length <= 1) continue;
            lastUrl = parts[1].trim();
            if (firstUrl == null) {
                firstUrl = lastUrl;
            }
            remoteUrls.put(remote, lastUrl);
        }
        String answer = null;
        if (remoteUrls.size() == 1) {
            return lastUrl;
        }
        if (remoteUrls.size() > 1 && (answer = (String)remoteUrls.get("origin")) == null) {
            answer = firstUrl;
        }
        return answer;
    }
}

