/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.spi.ModelDumpLine;
import org.apache.camel.spi.ModelToStructureDumper;
import org.apache.camel.spi.annotations.JdkService;

@JdkService(value="modelstructure-dumper")
public class DefaultModelToStructureDumper
implements ModelToStructureDumper {
    public List<ModelDumpLine> dumpStructure(CamelContext context, Route def, boolean brief) throws Exception {
        ArrayList<ModelDumpLine> answer = new ArrayList<ModelDumpLine>();
        String loc = def.getSourceLocationShort();
        answer.add(new ModelDumpLine(loc, "route", def.getRouteId(), 0, "route[" + def.getRouteId() + "]"));
        String uri = brief ? def.getEndpoint().getEndpointBaseUri() : def.getEndpoint().getEndpointUri();
        answer.add(new ModelDumpLine(loc, "from", def.getRouteId(), 1, "from[" + uri + "]"));
        MBeanServer server = context.getManagementStrategy().getManagementAgent().getMBeanServer();
        if (server != null) {
            String jmxDomain = context.getManagementStrategy().getManagementAgent().getMBeanObjectDomainName();
            String prefix = context.getManagementStrategy().getManagementAgent().getIncludeHostName() != false ? "*/" : "";
            ObjectName query = ObjectName.getInstance(jmxDomain + ":context=" + prefix + context.getManagementName() + ",type=processors,*");
            Set<ObjectName> names = server.queryNames(query, null);
            ArrayList<ManagedProcessorMBean> mps = new ArrayList<ManagedProcessorMBean>();
            for (ObjectName on : names) {
                ManagedProcessorMBean processor = (ManagedProcessorMBean)context.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedProcessorMBean.class);
                if (!def.getRouteId().equals(processor.getRouteId())) continue;
                mps.add(processor);
            }
            mps.sort(new OrderProcessorMBeans());
            for (ManagedProcessorMBean processor : mps) {
                loc = processor.getSourceLocationShort();
                String kind = processor.getProcessorName();
                String id = processor.getProcessorId();
                int level = processor.getLevel() + 1;
                String code = brief ? processor.getProcessorName() : processor.getModelLabel();
                answer.add(new ModelDumpLine(loc, kind, id, level, code));
            }
        }
        return answer;
    }

    private static final class OrderProcessorMBeans
    implements Comparator<ManagedProcessorMBean> {
        private OrderProcessorMBeans() {
        }

        @Override
        public int compare(ManagedProcessorMBean o1, ManagedProcessorMBean o2) {
            return o1.getIndex().compareTo(o2.getIndex());
        }
    }
}

