/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.language.simple.ast.BaseSimpleNode;
import org.apache.camel.language.simple.ast.SimpleNode;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.language.simple.types.UnaryOperatorType;
import org.apache.camel.util.ObjectHelper;

public class UnaryExpression
extends BaseSimpleNode {
    private UnaryOperatorType operator;
    private SimpleNode left;

    public UnaryExpression(SimpleToken token) {
        super(token);
        this.operator = UnaryOperatorType.asOperator(token.getText());
    }

    @Override
    public String toString() {
        if (this.left != null) {
            return this.left + this.token.getText();
        }
        return this.token.getText();
    }

    public void acceptLeft(SimpleNode left) {
        this.left = left;
    }

    public UnaryOperatorType getOperator() {
        return this.operator;
    }

    public SimpleNode getLeft() {
        return this.left;
    }

    @Override
    public Expression createExpression(CamelContext camelContext, String expression) {
        ObjectHelper.notNull((Object)this.left, (String)"left node", (Object)this);
        Expression leftExp = this.left.createExpression(camelContext, expression);
        if (this.operator == UnaryOperatorType.INC) {
            return this.createIncExpression(camelContext, leftExp);
        }
        if (this.operator == UnaryOperatorType.DEC) {
            return this.createDecExpression(camelContext, leftExp);
        }
        throw new SimpleParserException("Unknown unary operator " + this.operator, this.token.getIndex());
    }

    private Expression createIncExpression(final CamelContext camelContext, final Expression leftExp) {
        return new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                Number num = (Number)leftExp.evaluate(exchange, Number.class);
                if (num != null) {
                    long val = num.longValue();
                    ++val;
                    Object left = leftExp.evaluate(exchange, Object.class);
                    try {
                        left = camelContext.getTypeConverter().mandatoryConvertTo(left.getClass(), exchange, (Object)val);
                    }
                    catch (NoTypeConversionAvailableException e) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                    }
                    return (T)camelContext.getTypeConverter().convertTo(type, left);
                }
                CamelExchangeException cause = new CamelExchangeException("Cannot evaluate " + leftExp + " as a number", exchange);
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)cause);
            }

            public String toString() {
                return UnaryExpression.this.left + UnaryExpression.this.operator.toString();
            }
        };
    }

    private Expression createDecExpression(final CamelContext camelContext, final Expression leftExp) {
        return new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                Number num = (Number)leftExp.evaluate(exchange, Number.class);
                if (num != null) {
                    long val = num.longValue();
                    --val;
                    Object left = leftExp.evaluate(exchange, Object.class);
                    try {
                        left = camelContext.getTypeConverter().mandatoryConvertTo(left.getClass(), exchange, (Object)val);
                    }
                    catch (NoTypeConversionAvailableException e) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                    }
                    return (T)camelContext.getTypeConverter().convertTo(type, left);
                }
                CamelExchangeException cause = new CamelExchangeException("Cannot evaluate " + leftExp + " as a number", exchange);
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)cause);
            }

            public String toString() {
                return UnaryExpression.this.left + UnaryExpression.this.operator.toString();
            }
        };
    }

    @Override
    public String createCode(String expression) throws SimpleParserException {
        ObjectHelper.notNull((Object)this.left, (String)"left node", (Object)this);
        String number = this.left.createCode(expression);
        if (this.operator == UnaryOperatorType.INC) {
            return "increment(exchange, " + number + ")";
        }
        if (this.operator == UnaryOperatorType.DEC) {
            return "decrement(exchange, " + number + ")";
        }
        throw new SimpleParserException("Unknown unary operator " + this.operator, this.token.getIndex());
    }
}

