/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.BeanScope;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="eip,endpoint")
@XmlRootElement(name="bean")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BeanDefinition
extends NoOutputDefinition<BeanDefinition> {
    @XmlAttribute
    private String ref;
    @XmlAttribute
    private String method;
    @XmlAttribute
    private String beanType;
    @XmlAttribute
    @Metadata(defaultValue="true", javaType="java.lang.Boolean")
    @Deprecated
    private String cache;
    @XmlAttribute
    @Metadata(defaultValue="Singleton", enums="Singleton,Request,Prototype")
    private String scope;
    @XmlTransient
    private Class<?> beanClass;
    @XmlTransient
    private Object bean;

    public BeanDefinition() {
    }

    public BeanDefinition(String ref) {
        this.ref = ref;
    }

    public BeanDefinition(String ref, String method) {
        this.ref = ref;
        this.method = method;
    }

    public String toString() {
        return "Bean[" + this.description() + "]";
    }

    public String description() {
        if (this.ref != null) {
            Object methodText = "";
            if (this.method != null) {
                methodText = " method:" + this.method;
            }
            return "ref:" + this.ref + (String)methodText;
        }
        if (this.bean != null) {
            return ObjectHelper.className((Object)this.bean);
        }
        if (this.beanClass != null) {
            return this.beanClass.getName();
        }
        if (this.beanType != null) {
            return this.beanType;
        }
        return "";
    }

    public String getShortName() {
        return "bean";
    }

    @Override
    public String getLabel() {
        return "bean[" + this.description() + "]";
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public String getBeanType() {
        return this.beanType;
    }

    public void setBeanType(String beanType) {
        this.beanType = beanType;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanType(Class<?> beanType) {
        this.beanClass = beanType;
    }

    @Deprecated
    public String getCache() {
        if (this.scope == null || BeanScope.Singleton.name().equals(this.scope)) {
            return "true";
        }
        return "false";
    }

    @Deprecated
    public void setCache(String cache) {
        this.scope = "true".equals(cache) ? BeanScope.Singleton.name() : BeanScope.Prototype.name();
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setScope(BeanScope scope) {
        this.scope = scope.name();
    }
}

