/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.model.EndpointRequiredDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SagaDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public final class RouteDefinitionHelper {
    private RouteDefinitionHelper() {
    }

    public static Set<String> gatherAllStaticEndpointUris(CamelContext camelContext, RouteDefinition route, boolean includeInputs, boolean includeOutputs) {
        return RouteDefinitionHelper.gatherAllEndpointUris(camelContext, route, includeInputs, includeOutputs, false);
    }

    public static Set<String> gatherAllEndpointUris(CamelContext camelContext, RouteDefinition route, boolean includeInput, boolean includeOutputs, boolean includeDynamic) {
        String uri;
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        if (includeInput && (uri = RouteDefinitionHelper.normalizeUri(route.getInput().getEndpointUri())) != null) {
            answer.add(uri);
        }
        if (includeOutputs) {
            Collection<EndpointRequiredDefinition> col = ProcessorDefinitionHelper.filterTypeInOutputs(route.getOutputs(), EndpointRequiredDefinition.class);
            for (EndpointRequiredDefinition erd : col) {
                String uri2 = RouteDefinitionHelper.normalizeUri(erd.getEndpointUri());
                if (uri2 == null) continue;
                answer.add(uri2);
            }
            if (includeDynamic && camelContext.getRuntimeEndpointRegistry() != null) {
                List endpoints = camelContext.getRuntimeEndpointRegistry().getEndpointsPerRoute(route.getId(), false);
                for (String uri2 : endpoints) {
                    if (uri2 == null) continue;
                    answer.add(uri2);
                }
            }
        }
        return answer;
    }

    private static String normalizeUri(String uri) {
        try {
            return URISupport.normalizeUri((String)uri);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static void forceAssignIds(CamelContext context, List<RouteDefinition> routes) throws Exception {
        RestDefinition rest;
        String id;
        ExtendedCamelContext ecc = (ExtendedCamelContext)context.adapt(ExtendedCamelContext.class);
        HashSet<String> customIds = new HashSet<String>();
        for (RouteDefinition route : routes) {
            VerbDefinition verb;
            if (route.hasCustomIdAssigned()) {
                String originalId = route.getId();
                if (!originalId.equals(id = context.resolvePropertyPlaceholders(originalId))) {
                    route.setId(id);
                }
                customIds.add(id);
                continue;
            }
            rest = route.getRestDefinition();
            if (rest == null || !route.isRest().booleanValue() || (verb = RouteDefinitionHelper.findVerbDefinition(rest, route.getInput().getEndpointUri())) == null) continue;
            String id2 = verb.getId();
            if (!verb.hasCustomIdAssigned() || !ObjectHelper.isNotEmpty((Object)id2) || customIds.contains(id2)) continue;
            route.setId(id2);
            customIds.add(id2);
        }
        for (RouteDefinition def : ((ModelCamelContext)context.adapt(ModelCamelContext.class)).getRouteDefinitions()) {
            if (def.getId() == null) continue;
            customIds.add(def.getId());
        }
        for (RouteDefinition route : routes) {
            FromDefinition fromDefinition;
            String endpointUri;
            if (route.getId() == null) {
                boolean done = false;
                id = null;
                for (int attempts = 0; !done && attempts < 1000; ++attempts) {
                    id = route.idOrCreate(ecc.getNodeIdFactory());
                    if (customIds.contains(id)) {
                        route.setId(null);
                        continue;
                    }
                    done = true;
                }
                if (!done) {
                    throw new IllegalArgumentException("Cannot auto assign id to route: " + route);
                }
                route.setId(id);
                route.setCustomId(false);
                customIds.add(route.getId());
            }
            if ((rest = route.getRestDefinition()) == null || !route.isRest().booleanValue() || !ObjectHelper.isNotEmpty((Object)route.getInput()) || !ObjectHelper.isNotEmpty((Object)(endpointUri = (fromDefinition = route.getInput()).getEndpointUri())) || !endpointUri.startsWith("rest:") && !endpointUri.startsWith("rest-api:")) continue;
            HashMap<String, String> options = new HashMap<String, String>(1);
            options.put("routeId", route.getId());
            endpointUri = URISupport.appendParametersToURI((String)endpointUri, options);
            fromDefinition.setUri(endpointUri);
            route.setInput(fromDefinition);
        }
    }

    private static VerbDefinition findVerbDefinition(RestDefinition rest, String endpointUri) throws Exception {
        VerbDefinition ret = null;
        String preVerbUri = "";
        String target = URISupport.normalizeUri((String)endpointUri);
        for (VerbDefinition verb : rest.getVerbs()) {
            String verbUri = URISupport.normalizeUri((String)rest.buildFromUri(verb));
            if (!target.startsWith(verbUri) || preVerbUri.length() >= verbUri.length()) continue;
            preVerbUri = verbUri;
            ret = verb;
        }
        return ret;
    }

    public static String validateUniqueIds(RouteDefinition target, List<RouteDefinition> routes) {
        LinkedHashSet<String> routesIds = new LinkedHashSet<String>();
        for (RouteDefinition route : routes) {
            if (route == target) continue;
            ProcessorDefinitionHelper.gatherAllNodeIds(route, routesIds, true, false);
        }
        LinkedHashSet<String> targetIds = new LinkedHashSet<String>();
        ProcessorDefinitionHelper.gatherAllNodeIds(target, targetIds, true, false);
        for (String id : targetIds) {
            if (!routesIds.contains(id)) continue;
            return id;
        }
        return null;
    }

    public static void initParent(ProcessorDefinition parent) {
        List<ProcessorDefinition<?>> children = parent.getOutputs();
        for (ProcessorDefinition<?> child : children) {
            child.setParent(parent);
            if (child.getOutputs() == null || child.getOutputs().isEmpty()) continue;
            RouteDefinitionHelper.initParent(child);
        }
    }

    public static void prepareRouteForInit(RouteDefinition route, List<ProcessorDefinition<?>> abstracts, List<ProcessorDefinition<?>> lower) {
        for (ProcessorDefinition<?> output : route.getOutputs()) {
            if (output.isAbstract()) {
                abstracts.add(output);
                continue;
            }
            lower.add(output);
        }
    }

    public static void prepareRoute(CamelContext context, RouteDefinition route) {
        RouteDefinitionHelper.prepareRoute(context, route, null, null, null, null, null);
    }

    public static void prepareRoute(CamelContext context, RouteDefinition route, List<OnExceptionDefinition> onExceptions, List<InterceptDefinition> intercepts, List<InterceptFromDefinition> interceptFromDefinitions, List<InterceptSendToEndpointDefinition> interceptSendToEndpointDefinitions, List<OnCompletionDefinition> onCompletions) {
        RouteDefinitionHelper.prepareRouteImp(context, route, onExceptions, intercepts, interceptFromDefinitions, interceptSendToEndpointDefinitions, onCompletions);
    }

    private static void prepareRouteImp(CamelContext context, RouteDefinition route, List<OnExceptionDefinition> onExceptions, List<InterceptDefinition> intercepts, List<InterceptFromDefinition> interceptFromDefinitions, List<InterceptSendToEndpointDefinition> interceptSendToEndpointDefinitions, List<OnCompletionDefinition> onCompletions) {
        RouteDefinitionHelper.initRouteInput(context, route.getInput());
        ArrayList abstracts = new ArrayList();
        ArrayList upper = new ArrayList();
        ArrayList lower = new ArrayList();
        RouteDefinitionHelper.prepareRouteForInit(route, abstracts, lower);
        RouteDefinitionHelper.initParentAndErrorHandlerBuilder(context, route, abstracts, onExceptions);
        RouteDefinitionHelper.validateTopLevel(route.getOutputs());
        RouteDefinitionHelper.initInterceptors(context, route, abstracts, upper, intercepts, interceptFromDefinitions, interceptSendToEndpointDefinitions);
        RouteDefinitionHelper.initOnCompletions(abstracts, upper, onCompletions);
        RouteDefinitionHelper.initSagas(abstracts, lower);
        RouteDefinitionHelper.initTransacted(abstracts, lower);
        RouteDefinitionHelper.initOnExceptions(abstracts, upper, onExceptions);
        route.clearOutput();
        route.getOutputs().addAll(lower);
        route.getOutputs().addAll(0, upper);
    }

    public static void sanityCheckRoute(RouteDefinition route) {
        ObjectHelper.notNull((Object)route, (String)"route");
        if (route.getInput() == null) {
            String msg = "Route has no inputs: " + route;
            if (route.getId() != null) {
                msg = "Route " + route.getId() + " has no inputs: " + route;
            }
            throw new IllegalArgumentException(msg);
        }
        if (route.getOutputs() == null || route.getOutputs().isEmpty()) {
            String msg = "Route has no outputs: " + route;
            if (route.getId() != null) {
                msg = "Route " + route.getId() + " has no outputs: " + route;
            }
            throw new IllegalArgumentException(msg);
        }
    }

    private static void validateTopLevel(List<ProcessorDefinition<?>> children) {
        for (ProcessorDefinition<?> child : children) {
            boolean parentIsRoute;
            RouteDefinition route = ProcessorDefinitionHelper.getRoute(child);
            boolean bl = parentIsRoute = child.getParent() == route;
            if (child.isTopLevelOnly() && !parentIsRoute) {
                throw new IllegalArgumentException("The output must be added as top-level on the route. Try moving " + child + " to the top of route.");
            }
            if (child.getOutputs() == null || child.getOutputs().isEmpty()) continue;
            RouteDefinitionHelper.validateTopLevel(child.getOutputs());
        }
    }

    private static void initRouteInput(CamelContext camelContext, FromDefinition input) {
    }

    private static void initParentAndErrorHandlerBuilder(CamelContext context, RouteDefinition route, List<ProcessorDefinition<?>> abstracts, List<OnExceptionDefinition> onExceptions) {
        ErrorHandlerFactory builder;
        if (context != null && (builder = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getErrorHandlerFactory()) != null) {
            if (builder instanceof ErrorHandlerBuilder) {
                builder = ((ErrorHandlerBuilder)builder).cloneBuilder();
                route.setErrorHandlerFactoryIfNull(builder);
            } else {
                throw new UnsupportedOperationException("The ErrorHandlerFactory must implement ErrorHandlerBuilder");
            }
        }
        RouteDefinitionHelper.initParent(route);
        if (onExceptions != null) {
            for (OnExceptionDefinition global : onExceptions) {
                RouteDefinitionHelper.initParent(global);
            }
        }
    }

    private static void initOnExceptions(List<ProcessorDefinition<?>> abstracts, List<ProcessorDefinition<?>> upper, List<OnExceptionDefinition> onExceptions) {
        if (onExceptions != null && !onExceptions.isEmpty()) {
            for (OnExceptionDefinition onExceptionDefinition : onExceptions) {
                onExceptionDefinition.setRouteScoped(false);
                abstracts.add(onExceptionDefinition);
            }
        }
        for (ProcessorDefinition<?> processorDefinition : abstracts) {
            if (!(processorDefinition instanceof OnExceptionDefinition)) continue;
            int index = 0;
            for (int i = 0; i < upper.size(); ++i) {
                ProcessorDefinition<?> up = upper.get(i);
                if (!(up instanceof OnExceptionDefinition)) {
                    index = i;
                    break;
                }
                ++index;
            }
            upper.add(index, processorDefinition);
        }
    }

    private static void initInterceptors(CamelContext context, RouteDefinition route, List<ProcessorDefinition<?>> abstracts, List<ProcessorDefinition<?>> upper, List<InterceptDefinition> intercepts, List<InterceptFromDefinition> interceptFromDefinitions, List<InterceptSendToEndpointDefinition> interceptSendToEndpointDefinitions) {
        for (ProcessorDefinition<?> processor : abstracts) {
            if (processor instanceof InterceptSendToEndpointDefinition) {
                if (interceptSendToEndpointDefinitions == null) {
                    interceptSendToEndpointDefinitions = new ArrayList<InterceptSendToEndpointDefinition>();
                }
                interceptSendToEndpointDefinitions.add((InterceptSendToEndpointDefinition)processor);
                continue;
            }
            if (processor instanceof InterceptFromDefinition) {
                if (interceptFromDefinitions == null) {
                    interceptFromDefinitions = new ArrayList<InterceptFromDefinition>();
                }
                interceptFromDefinitions.add((InterceptFromDefinition)processor);
                continue;
            }
            if (!(processor instanceof InterceptDefinition)) continue;
            if (intercepts == null) {
                intercepts = new ArrayList<InterceptDefinition>();
            }
            intercepts.add((InterceptDefinition)processor);
        }
        RouteDefinitionHelper.doInitInterceptors(context, route, upper, intercepts, interceptFromDefinitions, interceptSendToEndpointDefinitions);
    }

    private static void doInitInterceptors(CamelContext context, RouteDefinition route, List<ProcessorDefinition<?>> upper, List<InterceptDefinition> intercepts, List<InterceptFromDefinition> interceptFromDefinitions, List<InterceptSendToEndpointDefinition> interceptSendToEndpointDefinitions) {
        if (intercepts != null && !intercepts.isEmpty()) {
            for (InterceptDefinition interceptDefinition : intercepts) {
                interceptDefinition.afterPropertiesSet();
                RouteDefinitionHelper.initParent(interceptDefinition);
                upper.add(0, interceptDefinition);
            }
        }
        if (interceptFromDefinitions != null && !interceptFromDefinitions.isEmpty()) {
            for (InterceptFromDefinition interceptFromDefinition : interceptFromDefinitions) {
                boolean match = true;
                if (interceptFromDefinition.getUri() != null) {
                    String pattern;
                    try {
                        pattern = context.resolvePropertyPlaceholders(interceptFromDefinition.getUri());
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                    }
                    boolean isRefPattern = pattern.startsWith("ref*") || pattern.startsWith("ref:");
                    match = false;
                    String uri = route.getInput().getEndpointUri();
                    if (!isRefPattern && uri != null && uri.startsWith("ref:")) {
                        String ref = uri.substring(4);
                        uri = CamelContextHelper.getMandatoryEndpoint((CamelContext)context, (String)ref).getEndpointUri();
                    }
                    if (EndpointHelper.matchEndpoint((CamelContext)context, (String)uri, (String)pattern)) {
                        match = true;
                    }
                }
                if (!match) continue;
                interceptFromDefinition.afterPropertiesSet();
                RouteDefinitionHelper.initParent(interceptFromDefinition);
                upper.add(0, interceptFromDefinition);
            }
        }
        if (interceptSendToEndpointDefinitions != null && !interceptSendToEndpointDefinitions.isEmpty()) {
            for (InterceptSendToEndpointDefinition interceptSendToEndpointDefinition : interceptSendToEndpointDefinitions) {
                interceptSendToEndpointDefinition.afterPropertiesSet();
                RouteDefinitionHelper.initParent(interceptSendToEndpointDefinition);
                upper.add(0, interceptSendToEndpointDefinition);
            }
        }
    }

    private static void initOnCompletions(List<ProcessorDefinition<?>> abstracts, List<ProcessorDefinition<?>> upper, List<OnCompletionDefinition> onCompletions) {
        List<Object> completions = new ArrayList();
        for (ProcessorDefinition<?> processorDefinition : abstracts) {
            if (!(processorDefinition instanceof OnCompletionDefinition)) continue;
            completions.add((OnCompletionDefinition)processorDefinition);
        }
        if (completions.isEmpty() && onCompletions != null) {
            completions = onCompletions;
            for (OnCompletionDefinition onCompletionDefinition : completions) {
                RouteDefinitionHelper.initParent(onCompletionDefinition);
            }
        }
        if (completions.isEmpty()) {
            return;
        }
        upper.addAll(completions);
    }

    private static void initSagas(List<ProcessorDefinition<?>> abstracts, List<ProcessorDefinition<?>> lower) {
        OutputDefinition saga = null;
        for (ProcessorDefinition<?> type : abstracts) {
            if (!(type instanceof SagaDefinition)) continue;
            if (saga == null) {
                saga = (SagaDefinition)type;
                continue;
            }
            throw new IllegalArgumentException("The route can only have one saga defined");
        }
        if (saga != null) {
            saga.getOutputs().addAll(0, lower);
            lower.clear();
            lower.add(saga);
        }
    }

    private static void initTransacted(List<ProcessorDefinition<?>> abstracts, List<ProcessorDefinition<?>> lower) {
        TransactedDefinition transacted = null;
        for (ProcessorDefinition<?> type : abstracts) {
            if (!(type instanceof TransactedDefinition)) continue;
            if (transacted == null) {
                transacted = (TransactedDefinition)type;
                continue;
            }
            throw new IllegalArgumentException("The route can only have one transacted defined");
        }
        if (transacted != null) {
            transacted.getOutputs().addAll(0, lower);
            lower.clear();
            lower.add(transacted);
        }
    }

    public static void forceAssignIds(CamelContext context, ProcessorDefinition processor) {
        List<ProcessorDefinition<?>> children;
        processor.idOrCreate(((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getNodeIdFactory());
        if (processor.hasCustomIdAssigned()) {
            try {
                String originalId = processor.getId();
                String id = context.resolvePropertyPlaceholders(originalId);
                if (!originalId.equals(id)) {
                    processor.setId(id);
                }
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        if ((children = processor.getOutputs()) != null && !children.isEmpty()) {
            for (ProcessorDefinition<?> child : children) {
                RouteDefinitionHelper.forceAssignIds(context, child);
            }
        }
    }

    public static String getRouteMessage(String route) {
        if (((String)route).length() > 60) {
            route = ((String)route).substring(0, 60) + "...";
        }
        route = URISupport.sanitizeUri((String)route);
        return route;
    }
}

