/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.Endpoint;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.model.DescriptionDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateBeanDefinition;
import org.apache.camel.model.RouteTemplateParameterDefinition;
import org.apache.camel.spi.AsEndpointUri;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration")
@XmlRootElement(name="routeTemplate")
@XmlType(propOrder={"templateParameters", "templateBeans", "route"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RouteTemplateDefinition
extends OptionalIdentifiedDefinition {
    @XmlTransient
    private Consumer<RouteTemplateContext> configurer;
    @XmlElement(name="templateParameter")
    @Metadata(description="Adds a template parameter the route template uses")
    private List<RouteTemplateParameterDefinition> templateParameters;
    @XmlElement(name="templateBean")
    @Metadata(description="Adds a local bean the route template uses")
    private List<RouteTemplateBeanDefinition> templateBeans;
    @XmlElement(name="route", required=true)
    private RouteDefinition route = new RouteDefinition();

    public List<RouteTemplateParameterDefinition> getTemplateParameters() {
        return this.templateParameters;
    }

    public void setTemplateParameters(List<RouteTemplateParameterDefinition> templateParameters) {
        this.templateParameters = templateParameters;
    }

    public List<RouteTemplateBeanDefinition> getTemplateBeans() {
        return this.templateBeans;
    }

    public void setTemplateBeans(List<RouteTemplateBeanDefinition> templateBeans) {
        this.templateBeans = templateBeans;
    }

    public RouteDefinition getRoute() {
        return this.route;
    }

    public void setRoute(RouteDefinition route) {
        this.route = route;
    }

    public void setConfigurer(Consumer<RouteTemplateContext> configurer) {
        this.configurer = configurer;
    }

    public Consumer<RouteTemplateContext> getConfigurer() {
        return this.configurer;
    }

    public RouteDefinition from(@AsEndpointUri String uri) {
        return this.route.from(uri);
    }

    public RouteDefinition from(Endpoint endpoint) {
        return this.route.from(endpoint);
    }

    public RouteDefinition from(EndpointConsumerBuilder endpoint) {
        return this.route.from(endpoint);
    }

    public RouteDefinition route() {
        return this.route;
    }

    public RouteTemplateDefinition description(String text) {
        DescriptionDefinition def = new DescriptionDefinition();
        def.setText(text);
        this.setDescription(def);
        return this;
    }

    public RouteTemplateDefinition templateParameter(String name) {
        this.addTemplateParameter(name, null);
        return this;
    }

    public RouteTemplateDefinition templateOptionalParameter(String name) {
        this.addTemplateOptionalParameter(name, null);
        return this;
    }

    public RouteTemplateDefinition templateOptionalParameter(String name, String description) {
        this.addTemplateOptionalParameter(name, description);
        return this;
    }

    public RouteTemplateDefinition templateParameter(String name, String defaultValue) {
        this.addTemplateParameter(name, defaultValue);
        return this;
    }

    public RouteTemplateDefinition templateParameter(String name, String defaultValue, String description) {
        this.addTemplateParameter(name, defaultValue, description);
        return this;
    }

    public RouteTemplateDefinition templateParameters(Map<String, String> parameters) {
        parameters.forEach(this::addTemplateParameter);
        return this;
    }

    public RouteTemplateDefinition templateBean(String name, Class<?> type) {
        if (this.templateBeans == null) {
            this.templateBeans = new ArrayList<RouteTemplateBeanDefinition>();
        }
        RouteTemplateBeanDefinition def = new RouteTemplateBeanDefinition();
        def.setName(name);
        def.setBeanType(type);
        this.templateBeans.add(def);
        return this;
    }

    public RouteTemplateDefinition templateBean(String name, Object bean) {
        if (this.templateBeans == null) {
            this.templateBeans = new ArrayList<RouteTemplateBeanDefinition>();
        }
        RouteTemplateBeanDefinition def = new RouteTemplateBeanDefinition();
        def.setName(name);
        if (bean instanceof RouteTemplateContext.BeanSupplier) {
            def.setBeanSupplier((RouteTemplateContext.BeanSupplier<Object>)((RouteTemplateContext.BeanSupplier)bean));
        } else if (bean instanceof Supplier) {
            def.setBeanSupplier((RouteTemplateContext.BeanSupplier<Object>)((RouteTemplateContext.BeanSupplier)ctx -> ((Supplier)bean).get()));
        } else if (bean instanceof String) {
            def.setType((String)bean);
        } else {
            def.setBeanSupplier((RouteTemplateContext.BeanSupplier<Object>)((RouteTemplateContext.BeanSupplier)ctx -> bean));
        }
        this.templateBeans.add(def);
        return this;
    }

    public RouteTemplateDefinition templateBean(String name, Supplier<Object> bean) {
        if (this.templateBeans == null) {
            this.templateBeans = new ArrayList<RouteTemplateBeanDefinition>();
        }
        RouteTemplateBeanDefinition def = new RouteTemplateBeanDefinition();
        def.setName(name);
        def.setBeanSupplier((RouteTemplateContext.BeanSupplier<Object>)((RouteTemplateContext.BeanSupplier)ctx -> bean.get()));
        this.templateBeans.add(def);
        return this;
    }

    public RouteTemplateDefinition templateBean(String name, Class<?> type, RouteTemplateContext.BeanSupplier<Object> bean) {
        if (this.templateBeans == null) {
            this.templateBeans = new ArrayList<RouteTemplateBeanDefinition>();
        }
        RouteTemplateBeanDefinition def = new RouteTemplateBeanDefinition();
        def.setName(name);
        def.setBeanType(type);
        def.setBeanSupplier(bean);
        this.templateBeans.add(def);
        return this;
    }

    public RouteTemplateDefinition templateBean(String name, String language, String script) {
        if (this.templateBeans == null) {
            this.templateBeans = new ArrayList<RouteTemplateBeanDefinition>();
        }
        RouteTemplateBeanDefinition def = new RouteTemplateBeanDefinition();
        def.setName(name);
        def.setType(language);
        def.setScript(script);
        this.templateBeans.add(def);
        return this;
    }

    public RouteTemplateDefinition templateBean(String name, Class<?> type, String language, String script) {
        if (this.templateBeans == null) {
            this.templateBeans = new ArrayList<RouteTemplateBeanDefinition>();
        }
        RouteTemplateBeanDefinition def = new RouteTemplateBeanDefinition();
        def.setName(name);
        def.setBeanType(type);
        def.setType(language);
        def.setScript(script);
        this.templateBeans.add(def);
        return this;
    }

    public RouteTemplateBeanDefinition templateBean(String name) {
        if (this.templateBeans == null) {
            this.templateBeans = new ArrayList<RouteTemplateBeanDefinition>();
        }
        RouteTemplateBeanDefinition def = new RouteTemplateBeanDefinition();
        def.setParent(this);
        def.setName(name);
        this.templateBeans.add(def);
        return def;
    }

    public RouteTemplateDefinition configure(Consumer<RouteTemplateContext> configurer) {
        this.configurer = configurer;
        return this;
    }

    public String getShortName() {
        return "routeTemplate";
    }

    public String getLabel() {
        return "RouteTemplate[" + this.route.getInput().getLabel() + "]";
    }

    private void addTemplateParameter(String name, String defaultValue) {
        this.addTemplateParameter(name, defaultValue, null);
    }

    private void addTemplateParameter(String name, String defaultValue, String description) {
        if (this.templateParameters == null) {
            this.templateParameters = new ArrayList<RouteTemplateParameterDefinition>();
        }
        this.templateParameters.add(new RouteTemplateParameterDefinition(name, defaultValue, description));
    }

    private void addTemplateOptionalParameter(String name, String description) {
        if (this.templateParameters == null) {
            this.templateParameters = new ArrayList<RouteTemplateParameterDefinition>();
        }
        RouteTemplateParameterDefinition def = new RouteTemplateParameterDefinition(name, null, description);
        def.setRequired(false);
        this.templateParameters.add(def);
    }

    public RouteDefinition asRouteDefinition() {
        RouteDefinition copy = new RouteDefinition();
        copy.setErrorHandlerRef(this.route.getErrorHandlerRef());
        copy.setErrorHandlerFactory(this.route.getErrorHandlerFactory());
        copy.setAutoStartup(this.route.getAutoStartup());
        copy.setDelayer(this.route.getDelayer());
        copy.setGroup(this.route.getGroup());
        copy.setInheritErrorHandler(this.route.isInheritErrorHandler());
        copy.setInput(this.route.getInput());
        copy.setInputType(this.route.getInputType());
        copy.setLogMask(this.route.getLogMask());
        copy.setMessageHistory(this.route.getMessageHistory());
        copy.setOutputType(this.route.getOutputType());
        copy.setOutputs(this.route.getOutputs());
        copy.setRoutePolicies(this.route.getRoutePolicies());
        copy.setRoutePolicyRef(this.route.getRoutePolicyRef());
        copy.setRouteProperties(this.route.getRouteProperties());
        copy.setShutdownRoute(this.route.getShutdownRoute());
        copy.setShutdownRunningTask(this.route.getShutdownRunningTask());
        copy.setStartupOrder(this.route.getStartupOrder());
        copy.setStreamCache(this.route.getStreamCache());
        copy.setTemplate(true);
        copy.setTrace(this.route.getTrace());
        if (this.route.getDescription() != null) {
            copy.setDescription(this.route.getDescription());
        } else {
            copy.setDescription(this.getDescription());
        }
        copy.setPrecondition(this.route.getPrecondition());
        return copy;
    }

    @FunctionalInterface
    public static interface Converter {
        public static final Converter DEFAULT_CONVERTER = new Converter(){

            @Override
            public RouteDefinition apply(RouteTemplateDefinition in, Map<String, Object> parameters) throws Exception {
                return in.asRouteDefinition();
            }
        };

        public RouteDefinition apply(RouteTemplateDefinition var1, Map<String, Object> var2) throws Exception;
    }
}

