/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.rest.ResponseHeaderDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestPropertyDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.StringHelper;

@Metadata(label="rest")
@XmlRootElement(name="responseMessage")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResponseMessageDefinition {
    @XmlTransient
    private VerbDefinition verb;
    @XmlAttribute
    @Metadata(defaultValue="200")
    private String code = "200";
    @XmlAttribute(required=true)
    private String message = "success";
    @XmlAttribute
    private String responseModel;
    @XmlElement(name="header")
    private List<ResponseHeaderDefinition> headers;
    @XmlElement(name="examples")
    private List<RestPropertyDefinition> examples;

    public ResponseMessageDefinition(VerbDefinition verb) {
        this();
        this.verb = verb;
    }

    public ResponseMessageDefinition() {
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getResponseModel() {
        return this.responseModel != null ? this.responseModel : "";
    }

    public void setResponseModel(String responseModel) {
        this.responseModel = responseModel;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<ResponseHeaderDefinition> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<ResponseHeaderDefinition> headers) {
        this.headers = headers;
    }

    public List<RestPropertyDefinition> getExamples() {
        return this.examples;
    }

    public void setExamples(List<RestPropertyDefinition> examples) {
        this.examples = examples;
    }

    public ResponseMessageDefinition code(int code) {
        this.setCode("" + code);
        return this;
    }

    public ResponseMessageDefinition code(String code) {
        this.setCode(code);
        return this;
    }

    public ResponseMessageDefinition message(String msg) {
        this.setMessage(msg);
        return this;
    }

    public ResponseMessageDefinition responseModel(Class<?> type) {
        this.setResponseModel(type.getCanonicalName());
        return this;
    }

    public ResponseMessageDefinition example(String key, String example) {
        if (this.examples == null) {
            this.examples = new ArrayList<RestPropertyDefinition>();
        }
        this.examples.add(new RestPropertyDefinition(key, example));
        return this;
    }

    public ResponseHeaderDefinition header(String name) {
        if (this.headers == null) {
            this.headers = new ArrayList<ResponseHeaderDefinition>();
        }
        ResponseHeaderDefinition header = new ResponseHeaderDefinition(this);
        header.setName(name);
        this.headers.add(header);
        return header;
    }

    public RestDefinition endResponseMessage() {
        StringHelper.notEmpty((String)this.code, (String)"code");
        StringHelper.notEmpty((String)this.message, (String)"message");
        this.verb.getResponseMsgs().add(this);
        return this.verb.getRest();
    }
}

