/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.model.EndpointRequiredDefinition;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.URISupport;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class SendDefinition<Type extends ProcessorDefinition<Type>>
extends NoOutputDefinition<Type>
implements EndpointRequiredDefinition {
    @XmlTransient
    protected Endpoint endpoint;
    @XmlTransient
    protected EndpointProducerBuilder endpointProducerBuilder;
    @XmlAttribute
    @Metadata(required=true)
    protected String uri;
    @XmlTransient
    private String endpointUriToString;

    public SendDefinition() {
    }

    public SendDefinition(String uri) {
        this.uri = uri;
    }

    @Override
    public String getEndpointUri() {
        if (this.endpointProducerBuilder != null) {
            return this.endpointProducerBuilder.getUri();
        }
        if (this.endpoint != null) {
            return this.endpoint.getEndpointUri();
        }
        return this.uri;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.clear();
        this.uri = uri;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.clear();
        this.endpoint = endpoint;
        this.uri = endpoint != null ? endpoint.getEndpointUri() : null;
    }

    public EndpointProducerBuilder getEndpointProducerBuilder() {
        return this.endpointProducerBuilder;
    }

    public void setEndpointProducerBuilder(EndpointProducerBuilder endpointProducerBuilder) {
        this.clear();
        this.endpointProducerBuilder = endpointProducerBuilder;
    }

    public String getPattern() {
        return null;
    }

    @Override
    public String getLabel() {
        String uri;
        if (this.endpointUriToString == null) {
            String value = null;
            try {
                value = this.getEndpointUri();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.endpointUriToString = URISupport.sanitizeUri((String)value);
        }
        return (uri = this.endpointUriToString) != null ? uri : "no uri supplied";
    }

    protected void clear() {
        this.endpointUriToString = null;
        this.endpointProducerBuilder = null;
        this.endpoint = null;
        this.uri = null;
    }
}

