/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.ContentTypeHeaderAware;
import org.apache.camel.model.dataformat.ProtobufLibrary;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.2.0", label="dataformat,transformation", title="Protobuf")
@XmlRootElement(name="protobuf")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProtobufDataFormat
extends DataFormatDefinition
implements ContentTypeHeaderAware {
    @XmlTransient
    private Object defaultInstance;
    @XmlAttribute
    private String instanceClass;
    @XmlAttribute
    @Metadata(label="advanced")
    private String objectMapper;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true")
    private String useDefaultObjectMapper;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="false")
    private String autoDiscoverObjectMapper;
    @XmlAttribute
    @Metadata(defaultValue="GoogleProtobuf")
    private ProtobufLibrary library = ProtobufLibrary.GoogleProtobuf;
    @XmlAttribute(name="unmarshalType")
    private String unmarshalTypeName;
    @XmlTransient
    private Class<?> unmarshalType;
    @XmlAttribute(name="jsonView")
    private String jsonViewTypeName;
    @XmlTransient
    private Class<?> jsonView;
    @XmlAttribute
    private String include;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String allowJmsType;
    @XmlAttribute(name="collectionType")
    private String collectionTypeName;
    @XmlTransient
    private Class<?> collectionType;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String useList;
    @XmlAttribute
    @Metadata(label="advanced")
    private String moduleClassNames;
    @XmlAttribute
    @Metadata(label="advanced")
    private String moduleRefs;
    @XmlAttribute
    private String enableFeatures;
    @XmlAttribute
    private String disableFeatures;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String allowUnmarshallType;
    @XmlAttribute
    @Metadata(label="advanced")
    private String timezone;
    @XmlAttribute
    @Metadata(label="advanced")
    private String schemaResolver;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String autoDiscoverSchemaResolver;
    @XmlAttribute
    @Metadata(enums="native,json", defaultValue="native")
    private String contentTypeFormat;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true", description="Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON")
    private String contentTypeHeader;

    public ProtobufDataFormat() {
        super("protobuf");
    }

    public ProtobufDataFormat(ProtobufLibrary library) {
        this();
        this.setLibrary(library);
    }

    public ProtobufDataFormat(String instanceClass) {
        this();
        this.setInstanceClass(instanceClass);
    }

    public ProtobufDataFormat(String instanceClass, String contentTypeFormat) {
        this();
        this.setInstanceClass(instanceClass);
        this.setContentTypeFormat(contentTypeFormat);
    }

    private ProtobufDataFormat(Builder builder) {
        this();
        this.defaultInstance = builder.defaultInstance;
        this.instanceClass = builder.instanceClass;
        this.objectMapper = builder.objectMapper;
        this.useDefaultObjectMapper = builder.useDefaultObjectMapper;
        this.autoDiscoverObjectMapper = builder.autoDiscoverObjectMapper;
        this.library = builder.library;
        this.unmarshalTypeName = builder.unmarshalTypeName;
        this.unmarshalType = builder.unmarshalType;
        this.jsonViewTypeName = builder.jsonViewTypeName;
        this.jsonView = builder.jsonView;
        this.include = builder.include;
        this.allowJmsType = builder.allowJmsType;
        this.collectionTypeName = builder.collectionTypeName;
        this.collectionType = builder.collectionType;
        this.useList = builder.useList;
        this.moduleClassNames = builder.moduleClassNames;
        this.moduleRefs = builder.moduleRefs;
        this.enableFeatures = builder.enableFeatures;
        this.disableFeatures = builder.disableFeatures;
        this.allowUnmarshallType = builder.allowUnmarshallType;
        this.timezone = builder.timezone;
        this.schemaResolver = builder.schemaResolver;
        this.autoDiscoverSchemaResolver = builder.autoDiscoverSchemaResolver;
        this.contentTypeFormat = builder.contentTypeFormat;
        this.contentTypeHeader = builder.contentTypeHeader;
    }

    @Override
    public String getDataFormatName() {
        return this.library != null ? this.library.getDataFormatName() : "protobuf";
    }

    public String getInstanceClass() {
        return this.instanceClass;
    }

    public void setInstanceClass(String instanceClass) {
        this.instanceClass = instanceClass;
    }

    public void setContentTypeFormat(String contentTypeFormat) {
        this.contentTypeFormat = contentTypeFormat;
    }

    public String getContentTypeFormat() {
        return this.contentTypeFormat;
    }

    @Override
    public String getContentTypeHeader() {
        return this.contentTypeHeader;
    }

    @Override
    public void setContentTypeHeader(String contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public Object getDefaultInstance() {
        return this.defaultInstance;
    }

    public void setDefaultInstance(Object defaultInstance) {
        this.defaultInstance = defaultInstance;
    }

    public ProtobufLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(ProtobufLibrary library) {
        this.library = library;
    }

    public String getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(String objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String getUseDefaultObjectMapper() {
        return this.useDefaultObjectMapper;
    }

    public void setUseDefaultObjectMapper(String useDefaultObjectMapper) {
        this.useDefaultObjectMapper = useDefaultObjectMapper;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public String getJsonViewTypeName() {
        return this.jsonViewTypeName;
    }

    public void setJsonViewTypeName(String jsonViewTypeName) {
        this.jsonViewTypeName = jsonViewTypeName;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public String getAllowJmsType() {
        return this.allowJmsType;
    }

    public void setAllowJmsType(String allowJmsType) {
        this.allowJmsType = allowJmsType;
    }

    public String getCollectionTypeName() {
        return this.collectionTypeName;
    }

    public void setCollectionTypeName(String collectionTypeName) {
        this.collectionTypeName = collectionTypeName;
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Class<?> collectionType) {
        this.collectionType = collectionType;
    }

    public String getUseList() {
        return this.useList;
    }

    public void setUseList(String useList) {
        this.useList = useList;
    }

    public String getModuleClassNames() {
        return this.moduleClassNames;
    }

    public void setModuleClassNames(String moduleClassNames) {
        this.moduleClassNames = moduleClassNames;
    }

    public String getModuleRefs() {
        return this.moduleRefs;
    }

    public void setModuleRefs(String moduleRefs) {
        this.moduleRefs = moduleRefs;
    }

    public String getEnableFeatures() {
        return this.enableFeatures;
    }

    public void setEnableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
    }

    public String getDisableFeatures() {
        return this.disableFeatures;
    }

    public void setDisableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
    }

    public String getAllowUnmarshallType() {
        return this.allowUnmarshallType;
    }

    public void setAllowUnmarshallType(String allowUnmarshallType) {
        this.allowUnmarshallType = allowUnmarshallType;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getAutoDiscoverObjectMapper() {
        return this.autoDiscoverObjectMapper;
    }

    public void setAutoDiscoverObjectMapper(String autoDiscoverObjectMapper) {
        this.autoDiscoverObjectMapper = autoDiscoverObjectMapper;
    }

    public void setSchemaResolver(String schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public String getSchemaResolver() {
        return this.schemaResolver;
    }

    public String getAutoDiscoverSchemaResolver() {
        return this.autoDiscoverSchemaResolver;
    }

    public void setAutoDiscoverSchemaResolver(String autoDiscoverSchemaResolver) {
        this.autoDiscoverSchemaResolver = autoDiscoverSchemaResolver;
    }

    public ProtobufDataFormat objectMapper(String objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public ProtobufDataFormat useDefaultObjectMapper(boolean useDefaultObjectMapper) {
        return this.useDefaultObjectMapper(Boolean.toString(useDefaultObjectMapper));
    }

    public ProtobufDataFormat useDefaultObjectMapper(String useDefaultObjectMapper) {
        this.useDefaultObjectMapper = useDefaultObjectMapper;
        return this;
    }

    public ProtobufDataFormat unmarshalType(String unmarshalType) {
        this.unmarshalTypeName = unmarshalType;
        return this;
    }

    public ProtobufDataFormat unmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
        return this;
    }

    public ProtobufDataFormat jsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
        return this;
    }

    public ProtobufDataFormat include(String include) {
        this.include = include;
        return this;
    }

    public ProtobufDataFormat collectionType(String collectionType) {
        this.collectionTypeName = collectionType;
        return this;
    }

    public ProtobufDataFormat collectionType(Class<?> collectionType) {
        this.collectionType = collectionType;
        return this;
    }

    public ProtobufDataFormat useList(boolean useList) {
        return this.useList(Boolean.toString(useList));
    }

    public ProtobufDataFormat useList(String useList) {
        this.useList = useList;
        return this;
    }

    public ProtobufDataFormat moduleClassNames(String moduleClassNames) {
        this.moduleClassNames = moduleClassNames;
        return this;
    }

    public ProtobufDataFormat moduleRefs(String moduleRefs) {
        this.moduleRefs = moduleRefs;
        return this;
    }

    public ProtobufDataFormat enableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
        return this;
    }

    public ProtobufDataFormat disableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
        return this;
    }

    public ProtobufDataFormat allowUnmarshallType(boolean allowUnmarshallType) {
        return this.allowUnmarshallType(Boolean.toString(allowUnmarshallType));
    }

    public ProtobufDataFormat allowUnmarshallType(String allowUnmarshallType) {
        this.allowUnmarshallType = allowUnmarshallType;
        return this;
    }

    public ProtobufDataFormat autoDiscoverObjectMapper(boolean autoDiscoverObjectMapper) {
        return this.autoDiscoverObjectMapper(Boolean.toString(autoDiscoverObjectMapper));
    }

    public ProtobufDataFormat autoDiscoverObjectMapper(String autoDiscoverObjectMapper) {
        this.autoDiscoverObjectMapper = autoDiscoverObjectMapper;
        return this;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<ProtobufDataFormat> {
        private Object defaultInstance;
        private String instanceClass;
        private String objectMapper;
        private String useDefaultObjectMapper;
        private String autoDiscoverObjectMapper;
        private ProtobufLibrary library = ProtobufLibrary.GoogleProtobuf;
        private String unmarshalTypeName;
        private Class<?> unmarshalType;
        private String jsonViewTypeName;
        private Class<?> jsonView;
        private String include;
        private String allowJmsType;
        private String collectionTypeName;
        private Class<?> collectionType;
        private String useList;
        private String moduleClassNames;
        private String moduleRefs;
        private String enableFeatures;
        private String disableFeatures;
        private String allowUnmarshallType;
        private String timezone;
        private String schemaResolver;
        private String autoDiscoverSchemaResolver;
        private String contentTypeFormat;
        private String contentTypeHeader;

        public Builder instanceClass(String instanceClass) {
            this.instanceClass = instanceClass;
            return this;
        }

        public Builder contentTypeFormat(String contentTypeFormat) {
            this.contentTypeFormat = contentTypeFormat;
            return this;
        }

        public Builder contentTypeHeader(String contentTypeHeader) {
            this.contentTypeHeader = contentTypeHeader;
            return this;
        }

        public Builder contentTypeHeader(boolean contentTypeHeader) {
            this.contentTypeHeader = Boolean.toString(contentTypeHeader);
            return this;
        }

        public Builder defaultInstance(Object defaultInstance) {
            this.defaultInstance = defaultInstance;
            return this;
        }

        public Builder library(ProtobufLibrary library) {
            this.library = library;
            return this;
        }

        public Builder objectMapper(String objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder useDefaultObjectMapper(String useDefaultObjectMapper) {
            this.useDefaultObjectMapper = useDefaultObjectMapper;
            return this;
        }

        public Builder useDefaultObjectMapper(boolean useDefaultObjectMapper) {
            this.useDefaultObjectMapper = Boolean.toString(useDefaultObjectMapper);
            return this;
        }

        public Builder unmarshalTypeName(String unmarshalTypeName) {
            this.unmarshalTypeName = unmarshalTypeName;
            return this;
        }

        public Builder unmarshalType(Class<?> unmarshalType) {
            this.unmarshalType = unmarshalType;
            return this;
        }

        public Builder jsonViewTypeName(String jsonViewTypeName) {
            this.jsonViewTypeName = jsonViewTypeName;
            return this;
        }

        public Builder jsonView(Class<?> jsonView) {
            this.jsonView = jsonView;
            return this;
        }

        public Builder include(String include) {
            this.include = include;
            return this;
        }

        public Builder allowJmsType(String allowJmsType) {
            this.allowJmsType = allowJmsType;
            return this;
        }

        public Builder allowJmsType(boolean allowJmsType) {
            this.allowJmsType = Boolean.toString(allowJmsType);
            return this;
        }

        public Builder collectionTypeName(String collectionTypeName) {
            this.collectionTypeName = collectionTypeName;
            return this;
        }

        public Builder collectionType(Class<?> collectionType) {
            this.collectionType = collectionType;
            return this;
        }

        public Builder useList(String useList) {
            this.useList = useList;
            return this;
        }

        public Builder useList(boolean useList) {
            this.useList = Boolean.toString(useList);
            return this;
        }

        public Builder moduleClassNames(String moduleClassNames) {
            this.moduleClassNames = moduleClassNames;
            return this;
        }

        public Builder moduleRefs(String moduleRefs) {
            this.moduleRefs = moduleRefs;
            return this;
        }

        public Builder enableFeatures(String enableFeatures) {
            this.enableFeatures = enableFeatures;
            return this;
        }

        public Builder disableFeatures(String disableFeatures) {
            this.disableFeatures = disableFeatures;
            return this;
        }

        public Builder allowUnmarshallType(String allowUnmarshallType) {
            this.allowUnmarshallType = allowUnmarshallType;
            return this;
        }

        public Builder allowUnmarshallType(boolean allowUnmarshallType) {
            this.allowUnmarshallType = Boolean.toString(allowUnmarshallType);
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder autoDiscoverObjectMapper(String autoDiscoverObjectMapper) {
            this.autoDiscoverObjectMapper = autoDiscoverObjectMapper;
            return this;
        }

        public Builder autoDiscoverObjectMapper(boolean autoDiscoverObjectMapper) {
            this.autoDiscoverObjectMapper = Boolean.toString(autoDiscoverObjectMapper);
            return this;
        }

        public Builder schemaResolver(String schemaResolver) {
            this.schemaResolver = schemaResolver;
            return this;
        }

        public Builder autoDiscoverSchemaResolver(String autoDiscoverSchemaResolver) {
            this.autoDiscoverSchemaResolver = autoDiscoverSchemaResolver;
            return this;
        }

        public Builder autoDiscoverSchemaResolver(boolean autoDiscoverSchemaResolver) {
            this.autoDiscoverSchemaResolver = Boolean.toString(autoDiscoverSchemaResolver);
            return this;
        }

        @Override
        public ProtobufDataFormat end() {
            return new ProtobufDataFormat(this);
        }
    }
}

