/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.3.0", label="dataformat,transformation,xml", title="SOAP")
@XmlRootElement(name="soap")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SoapDataFormat
extends DataFormatDefinition {
    @XmlAttribute(required=true)
    private String contextPath;
    @XmlAttribute
    private String encoding;
    @XmlAttribute
    @Metadata(label="advanced")
    private String elementNameStrategyRef;
    @XmlTransient
    private Object elementNameStrategy;
    @XmlAttribute
    @Metadata(defaultValue="1.1", enums="1.1,1.2")
    private String version;
    @XmlAttribute
    @Metadata(label="advanced")
    private String namespacePrefixRef;
    @XmlAttribute
    private String schema;

    public SoapDataFormat() {
        super("soap");
    }

    public SoapDataFormat(String contextPath) {
        this();
        this.setContextPath(contextPath);
    }

    public SoapDataFormat(String contextPath, String elementNameStrategyRef) {
        this();
        this.setContextPath(contextPath);
        this.setElementNameStrategyRef(elementNameStrategyRef);
    }

    public SoapDataFormat(String contextPath, Object elementNameStrategy) {
        this();
        this.setContextPath(contextPath);
        this.setElementNameStrategy(elementNameStrategy);
    }

    private SoapDataFormat(Builder builder) {
        this();
        this.contextPath = builder.contextPath;
        this.encoding = builder.encoding;
        this.elementNameStrategyRef = builder.elementNameStrategyRef;
        this.elementNameStrategy = builder.elementNameStrategy;
        this.version = builder.version;
        this.namespacePrefixRef = builder.namespacePrefixRef;
        this.schema = builder.schema;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setElementNameStrategyRef(String elementNameStrategyRef) {
        this.elementNameStrategyRef = elementNameStrategyRef;
    }

    public String getElementNameStrategyRef() {
        return this.elementNameStrategyRef;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setElementNameStrategy(Object elementNameStrategy) {
        this.elementNameStrategy = elementNameStrategy;
    }

    public Object getElementNameStrategy() {
        return this.elementNameStrategy;
    }

    public String getNamespacePrefixRef() {
        return this.namespacePrefixRef;
    }

    public void setNamespacePrefixRef(String namespacePrefixRef) {
        this.namespacePrefixRef = namespacePrefixRef;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<SoapDataFormat> {
        private String contextPath;
        private String encoding;
        private String elementNameStrategyRef;
        private Object elementNameStrategy;
        private String version;
        private String namespacePrefixRef;
        private String schema;

        public Builder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder elementNameStrategyRef(String elementNameStrategyRef) {
            this.elementNameStrategyRef = elementNameStrategyRef;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder elementNameStrategy(Object elementNameStrategy) {
            this.elementNameStrategy = elementNameStrategy;
            return this;
        }

        public Builder namespacePrefixRef(String namespacePrefixRef) {
            this.namespacePrefixRef = namespacePrefixRef;
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public SoapDataFormat end() {
            return new SoapDataFormat(this);
        }
    }
}

