/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.apache.camel.model.rest.DeleteVerbDefinition;
import org.apache.camel.model.rest.GetVerbDefinition;
import org.apache.camel.model.rest.HeadVerbDefinition;
import org.apache.camel.model.rest.PatchVerbDefinition;
import org.apache.camel.model.rest.PostVerbDefinition;
import org.apache.camel.model.rest.PutVerbDefinition;
import org.apache.camel.model.rest.RestBindingDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.model.rest.RestOperationParamDefinition;
import org.apache.camel.model.rest.RestOperationResponseMsgDefinition;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.model.rest.RestSecuritiesDefinition;
import org.apache.camel.model.rest.SecurityDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

@Metadata(label="rest")
@XmlRootElement(name="rest")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestDefinition
extends OptionalIdentifiedDefinition<RestDefinition> {
    @XmlAttribute
    private String path;
    @XmlAttribute
    private String tag;
    @XmlAttribute
    private String consumes;
    @XmlAttribute
    private String produces;
    @XmlAttribute
    @Metadata(defaultValue="auto")
    private String bindingMode;
    @XmlAttribute
    private String skipBindingOnErrorCode;
    @XmlAttribute
    private String clientRequestValidation;
    @XmlAttribute
    private String enableCORS;
    @XmlAttribute
    private String apiDocs;
    @XmlElement(name="securityDefinitions")
    private RestSecuritiesDefinition securityDefinitions;
    @XmlElementRef
    private List<VerbDefinition> verbs = new ArrayList<VerbDefinition>();

    public String getShortName() {
        return "rest";
    }

    public String getLabel() {
        return "rest";
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public String getProduces() {
        return this.produces;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public String getBindingMode() {
        return this.bindingMode;
    }

    public void setBindingMode(String bindingMode) {
        this.bindingMode = bindingMode;
    }

    public List<VerbDefinition> getVerbs() {
        return this.verbs;
    }

    public RestSecuritiesDefinition getSecurityDefinitions() {
        return this.securityDefinitions;
    }

    public void setSecurityDefinitions(RestSecuritiesDefinition securityDefinitions) {
        this.securityDefinitions = securityDefinitions;
    }

    public void setVerbs(List<VerbDefinition> verbs) {
        this.verbs = verbs;
    }

    public String getSkipBindingOnErrorCode() {
        return this.skipBindingOnErrorCode;
    }

    public void setSkipBindingOnErrorCode(String skipBindingOnErrorCode) {
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
    }

    public String getClientRequestValidation() {
        return this.clientRequestValidation;
    }

    public void setClientRequestValidation(String clientRequestValidation) {
        this.clientRequestValidation = clientRequestValidation;
    }

    public String getEnableCORS() {
        return this.enableCORS;
    }

    public void setEnableCORS(String enableCORS) {
        this.enableCORS = enableCORS;
    }

    public String getApiDocs() {
        return this.apiDocs;
    }

    public void setApiDocs(String apiDocs) {
        this.apiDocs = apiDocs;
    }

    public RestDefinition path(String path) {
        this.setPath(path);
        return this;
    }

    public RestDefinition tag(String tag) {
        this.setTag(tag);
        return this;
    }

    public RestDefinition get() {
        return this.addVerb("get", null);
    }

    public RestDefinition get(String uri) {
        return this.addVerb("get", uri);
    }

    public RestDefinition post() {
        return this.addVerb("post", null);
    }

    public RestDefinition post(String uri) {
        return this.addVerb("post", uri);
    }

    public RestDefinition put() {
        return this.addVerb("put", null);
    }

    public RestDefinition put(String uri) {
        return this.addVerb("put", uri);
    }

    public RestDefinition patch() {
        return this.addVerb("patch", null);
    }

    public RestDefinition patch(String uri) {
        return this.addVerb("patch", uri);
    }

    public RestDefinition delete() {
        return this.addVerb("delete", null);
    }

    public RestDefinition delete(String uri) {
        return this.addVerb("delete", uri);
    }

    public RestDefinition head() {
        return this.addVerb("head", null);
    }

    public RestDefinition head(String uri) {
        return this.addVerb("head", uri);
    }

    public RestDefinition verb(String verb) {
        return this.addVerb(verb, null);
    }

    public RestDefinition verb(String verb, String uri) {
        return this.addVerb(verb, uri);
    }

    @Override
    public RestDefinition id(String id) {
        if (this.getVerbs().isEmpty()) {
            super.id(id);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.id(id);
        }
        return this;
    }

    @Override
    public RestDefinition description(String text) {
        if (this.getVerbs().isEmpty()) {
            super.description(text);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.description(text);
        }
        return this;
    }

    @Override
    public RestDefinition description(String id, String text, String lang) {
        if (this.getVerbs().isEmpty()) {
            super.description(id, text, lang);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.description(id, text, lang);
        }
        return this;
    }

    public RestDefinition consumes(String mediaType) {
        if (this.getVerbs().isEmpty()) {
            this.consumes = mediaType;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setConsumes(mediaType);
        }
        return this;
    }

    public RestOperationParamDefinition param() {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        return this.param(verb);
    }

    public RestDefinition param(RestOperationParamDefinition param) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.getParams().add(param);
        return this;
    }

    public RestDefinition params(List<RestOperationParamDefinition> params) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.getParams().addAll(params);
        return this;
    }

    public RestOperationParamDefinition param(VerbDefinition verb) {
        return new RestOperationParamDefinition(verb);
    }

    public RestDefinition responseMessage(RestOperationResponseMsgDefinition msg) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.getResponseMsgs().add(msg);
        return this;
    }

    public RestOperationResponseMsgDefinition responseMessage() {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        return this.responseMessage(verb);
    }

    public RestOperationResponseMsgDefinition responseMessage(VerbDefinition verb) {
        return new RestOperationResponseMsgDefinition(verb);
    }

    public RestDefinition responseMessages(List<RestOperationResponseMsgDefinition> msgs) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.getResponseMsgs().addAll(msgs);
        return this;
    }

    public RestSecuritiesDefinition securityDefinitions() {
        if (this.securityDefinitions == null) {
            this.securityDefinitions = new RestSecuritiesDefinition(this);
        }
        return this.securityDefinitions;
    }

    public RestDefinition produces(String mediaType) {
        if (this.getVerbs().isEmpty()) {
            this.produces = mediaType;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setProduces(mediaType);
        }
        return this;
    }

    public RestDefinition type(Class<?> classType) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setTypeClass(classType);
        verb.setType(this.asTypeName(classType));
        return this;
    }

    public RestDefinition outType(Class<?> classType) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setOutTypeClass(classType);
        verb.setOutType(this.asTypeName(classType));
        return this;
    }

    public RestDefinition bindingMode(RestBindingMode mode) {
        return this.bindingMode(mode.name());
    }

    public RestDefinition bindingMode(String mode) {
        if (this.getVerbs().isEmpty()) {
            this.bindingMode = mode.toLowerCase();
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setBindingMode(mode.toLowerCase());
        }
        return this;
    }

    public RestDefinition skipBindingOnErrorCode(boolean skipBindingOnErrorCode) {
        if (this.getVerbs().isEmpty()) {
            this.skipBindingOnErrorCode = Boolean.toString(skipBindingOnErrorCode);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setSkipBindingOnErrorCode(Boolean.toString(skipBindingOnErrorCode));
        }
        return this;
    }

    public RestDefinition clientRequestValidation(boolean clientRequestValidation) {
        if (this.getVerbs().isEmpty()) {
            this.clientRequestValidation = Boolean.toString(clientRequestValidation);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setClientRequestValidation(Boolean.toString(clientRequestValidation));
        }
        return this;
    }

    public RestDefinition enableCORS(boolean enableCORS) {
        if (this.getVerbs().isEmpty()) {
            this.enableCORS = Boolean.toString(enableCORS);
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setEnableCORS(Boolean.toString(enableCORS));
        }
        return this;
    }

    public RestDefinition apiDocs(Boolean apiDocs) {
        if (this.getVerbs().isEmpty()) {
            this.apiDocs = apiDocs != null ? apiDocs.toString() : null;
        } else {
            VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
            verb.setApiDocs(apiDocs != null ? apiDocs.toString() : null);
        }
        return this;
    }

    public RestDefinition security(String key) {
        return this.security(key, null);
    }

    public RestDefinition security(String key, String scopes) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        SecurityDefinition sd = new SecurityDefinition();
        sd.setKey(key);
        sd.setScopes(scopes);
        verb.getSecurity().add(sd);
        return this;
    }

    public RestDefinition to(String uri) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        ToDefinition to = new ToDefinition(uri);
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setTo(to);
        return this;
    }

    public RestDefinition toD(String uri) {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        ToDynamicDefinition to = new ToDynamicDefinition(uri);
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setToD(to);
        return this;
    }

    public RouteDefinition route() {
        if (this.getVerbs().isEmpty()) {
            throw new IllegalArgumentException("Must add verb first, such as get/post/delete");
        }
        RouteDefinition route = new RouteDefinition();
        route.setRestDefinition(this);
        VerbDefinition verb = this.getVerbs().get(this.getVerbs().size() - 1);
        verb.setRoute(route);
        return route;
    }

    public String buildFromUri(VerbDefinition verb) {
        return "rest:" + verb.asVerb() + ":" + this.buildUri(verb);
    }

    private RestDefinition addVerb(String verb, String uri) {
        VerbDefinition answer;
        if ("get".equals(verb)) {
            answer = new GetVerbDefinition();
        } else if ("post".equals(verb)) {
            answer = new PostVerbDefinition();
        } else if ("delete".equals(verb)) {
            answer = new DeleteVerbDefinition();
        } else if ("head".equals(verb)) {
            answer = new HeadVerbDefinition();
        } else if ("put".equals(verb)) {
            answer = new PutVerbDefinition();
        } else if ("patch".equals(verb)) {
            answer = new PatchVerbDefinition();
        } else {
            answer = new VerbDefinition();
            answer.setMethod(verb);
        }
        this.getVerbs().add(answer);
        answer.setRest(this);
        answer.setUri(uri);
        return this;
    }

    public List<RouteDefinition> asRouteDefinition(CamelContext camelContext) {
        ObjectHelper.notNull((Object)camelContext, (String)"CamelContext");
        this.validateUniquePaths();
        ArrayList<RouteDefinition> answer = new ArrayList<RouteDefinition>();
        RestConfiguration config = camelContext.getRestConfiguration();
        this.addRouteDefinition(camelContext, answer, config.getComponent(), config.getProducerComponent());
        return answer;
    }

    protected void validateUniquePaths() {
        HashSet<String> paths = new HashSet<String>();
        for (VerbDefinition verb : this.verbs) {
            String path = verb.asVerb();
            if (verb.getUri() != null) {
                path = path + ":" + verb.getUri();
            }
            if (paths.add(path)) continue;
            throw new IllegalArgumentException("Duplicate verb detected in rest-dsl: " + path);
        }
    }

    protected String asTypeName(Class<?> classType) {
        String type = !classType.isPrimitive() ? (classType.isArray() ? StringHelper.between((String)classType.getName(), (String)"[L", (String)";") + "[]" : classType.getName()) : classType.getCanonicalName();
        return type;
    }

    public static RouteDefinition asRouteApiDefinition(CamelContext camelContext, RestConfiguration configuration) {
        RouteDefinition answer = new RouteDefinition();
        String from = "rest-api:" + configuration.getApiContextPath();
        HashMap<String, String> options = new HashMap<String, String>();
        String routeId = configuration.getApiContextRouteId();
        if (routeId == null) {
            routeId = answer.idOrCreate(((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getNodeIdFactory());
        }
        options.put("routeId", routeId);
        if (configuration.getComponent() != null && !configuration.getComponent().isEmpty()) {
            options.put("consumerComponentName", configuration.getComponent());
        }
        if (configuration.getComponent() != null && !configuration.getComponent().isEmpty()) {
            options.put("producerComponentName", configuration.getProducerComponent());
        }
        if (configuration.getApiContextIdPattern() != null) {
            options.put("contextIdPattern", configuration.getApiContextIdPattern());
        }
        if (!options.isEmpty()) {
            String query;
            try {
                query = URISupport.createQueryString(options);
            }
            catch (URISyntaxException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
            from = from + "?" + query;
        }
        String to = from;
        answer.fromRest(from);
        answer.id(routeId);
        answer.to(to);
        return answer;
    }

    private void addRouteDefinition(CamelContext camelContext, List<RouteDefinition> answer, String component, String producerComponent) {
        for (VerbDefinition verb : this.getVerbs()) {
            String description;
            String outType;
            RouteDefinition route = verb.getRoute();
            if (route == null) {
                route = new RouteDefinition();
                NoOutputDefinition def = verb.getTo() != null ? verb.getTo() : verb.getToD();
                route.getOutputs().add(def);
            }
            RestBindingDefinition binding = new RestBindingDefinition();
            binding.setComponent(component);
            binding.setType(verb.getType());
            binding.setTypeClass(verb.getTypeClass());
            binding.setOutType(verb.getOutType());
            binding.setOutTypeClass(verb.getOutTypeClass());
            if (verb.getConsumes() != null) {
                binding.setConsumes(verb.getConsumes());
            } else {
                binding.setConsumes(this.getConsumes());
            }
            if (verb.getProduces() != null) {
                binding.setProduces(verb.getProduces());
            } else {
                binding.setProduces(this.getProduces());
            }
            if (verb.getBindingMode() != null) {
                binding.setBindingMode(verb.getBindingMode());
            } else {
                binding.setBindingMode(this.getBindingMode());
            }
            if (verb.getSkipBindingOnErrorCode() != null) {
                binding.setSkipBindingOnErrorCode(verb.getSkipBindingOnErrorCode());
            } else {
                binding.setSkipBindingOnErrorCode(this.getSkipBindingOnErrorCode());
            }
            if (verb.getClientRequestValidation() != null) {
                binding.setClientRequestValidation(verb.getClientRequestValidation());
            } else {
                binding.setClientRequestValidation(this.getClientRequestValidation());
            }
            if (verb.getEnableCORS() != null) {
                binding.setEnableCORS(verb.getEnableCORS());
            } else {
                binding.setEnableCORS(this.getEnableCORS());
            }
            for (RestOperationParamDefinition param : verb.getParams()) {
                Boolean required;
                RestParamType type = param.getType();
                if ((RestParamType.query == type || RestParamType.header == type) && ObjectHelper.isNotEmpty((Object)param.getDefaultValue())) {
                    binding.addDefaultValue(param.getName(), param.getDefaultValue());
                }
                if ((required = param.getRequired()) == null || !required.booleanValue()) continue;
                if (RestParamType.query == type) {
                    binding.addRequiredQueryParameter(param.getName());
                    continue;
                }
                if (RestParamType.header == type) {
                    binding.addRequiredHeader(param.getName());
                    continue;
                }
                if (RestParamType.body != type) continue;
                binding.setRequiredBody(true);
            }
            route.setRestBindingDefinition(binding);
            String from = this.buildFromUri(verb);
            HashMap<String, String> options = new HashMap<String, String>();
            if (verb.getConsumes() != null) {
                options.put("consumes", verb.getConsumes());
            } else if (this.getConsumes() != null) {
                options.put("consumes", this.getConsumes());
            }
            if (verb.getProduces() != null) {
                options.put("produces", verb.getProduces());
            } else if (this.getProduces() != null) {
                options.put("produces", this.getProduces());
            }
            String inType = binding.getType();
            if (inType != null) {
                options.put("inType", inType);
            }
            if ((outType = binding.getOutType()) != null) {
                options.put("outType", outType);
            }
            if (component != null && !component.isEmpty()) {
                options.put("consumerComponentName", component);
            }
            if (producerComponent != null && !producerComponent.isEmpty()) {
                options.put("producerComponentName", producerComponent);
            }
            String string = description = verb.getTo() != null ? verb.getTo().getDescriptionText() : route.getDescriptionText();
            if (description == null) {
                description = verb.getDescriptionText();
            }
            if (description == null) {
                description = this.getDescriptionText();
            }
            if (description != null) {
                options.put("description", description);
            }
            if (!options.isEmpty()) {
                String query;
                try {
                    query = URISupport.createQueryString(options);
                }
                catch (URISyntaxException e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
                from = from + "?" + query;
            }
            String path = this.getPath();
            String s1 = FileUtil.stripTrailingSeparator((String)path);
            String s2 = FileUtil.stripLeadingSeparator((String)verb.getUri());
            String allPath = s1 != null && s2 != null ? s1 + "/" + s2 : (path != null ? path : verb.getUri());
            if (allPath != null) {
                String[] arr;
                for (String a : arr = allPath.split("\\/")) {
                    try {
                        a = camelContext.resolvePropertyPlaceholders(a);
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                    }
                    Matcher m = Pattern.compile("\\{(.*?)\\}").matcher(a);
                    while (m.find()) {
                        String key = m.group(1);
                        boolean found = false;
                        for (RestOperationParamDefinition param : verb.getParams()) {
                            String name = param.getName();
                            StringHelper.notEmpty((String)name, (String)"parameter name");
                            try {
                                name = camelContext.resolvePropertyPlaceholders(name);
                            }
                            catch (Exception e) {
                                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                            }
                            if (!name.equalsIgnoreCase(key)) continue;
                            param.type(RestParamType.path);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        this.param(verb).name(key).type(RestParamType.path).endParam();
                    }
                }
            }
            if (verb.getType() != null) {
                RestOperationParamDefinition param;
                String bodyType = verb.getType();
                if (bodyType.endsWith("[]")) {
                    bodyType = "List[" + bodyType.substring(0, bodyType.length() - 2) + "]";
                }
                if ((param = this.findParam(verb, RestParamType.body.name())) == null) {
                    this.param(verb).name(RestParamType.body.name()).type(RestParamType.body).dataType(bodyType).endParam();
                } else {
                    param.type(RestParamType.body).dataType(bodyType);
                }
            }
            route.fromRest(from);
            route.setRestDefinition(this);
            answer.add(route);
        }
    }

    private String buildUri(VerbDefinition verb) {
        if (this.path != null && verb.getUri() != null) {
            return this.path + ":" + verb.getUri();
        }
        if (this.path != null) {
            return this.path;
        }
        if (verb.getUri() != null) {
            return verb.getUri();
        }
        return "";
    }

    private RestOperationParamDefinition findParam(VerbDefinition verb, String name) {
        for (RestOperationParamDefinition param : verb.getParams()) {
            if (!name.equals(param.getName())) continue;
            return param;
        }
        return null;
    }
}

